/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.Alias;
import com.mailslurp.models.AliasDto;
import com.mailslurp.models.CreateAliasOptions;
import com.mailslurp.models.PageAlias;
import com.mailslurp.models.PageEmailProjection;
import com.mailslurp.models.PageThreadProjection;
import com.mailslurp.models.ReplyToAliasEmailOptions;
import com.mailslurp.models.SendEmailOptions;
import com.mailslurp.models.SentEmailDto;
import java.util.UUID;
import com.mailslurp.models.UpdateAliasOptions;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AliasControllerApi {
    private ApiClient localVarApiClient;

    public AliasControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AliasControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createAlias
     * @param createAliasOptions createAliasOptions (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createAliasCall(CreateAliasOptions createAliasOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = createAliasOptions;

        // create path and map variables
        String localVarPath = "/aliases";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createAliasValidateBeforeCall(CreateAliasOptions createAliasOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'createAliasOptions' is set
        if (createAliasOptions == null) {
            throw new ApiException("Missing the required parameter 'createAliasOptions' when calling createAlias(Async)");
        }
        

        okhttp3.Call localVarCall = createAliasCall(createAliasOptions, _callback);
        return localVarCall;

    }

    /**
     * Create an email alias. Must be verified by clicking link inside verification email that will be sent to the address. Once verified the alias will be active.
     * Email aliases use a MailSlurp randomly generated email address (or a custom domain inbox that you provide) to mask or proxy a real email address. Emails sent to the alias address will be forwarded to the hidden email address it was created for. If you want to send a reply use the threadId attached
     * @param createAliasOptions createAliasOptions (required)
     * @return AliasDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public AliasDto createAlias(CreateAliasOptions createAliasOptions) throws ApiException {
        ApiResponse<AliasDto> localVarResp = createAliasWithHttpInfo(createAliasOptions);
        return localVarResp.getData();
    }

    /**
     * Create an email alias. Must be verified by clicking link inside verification email that will be sent to the address. Once verified the alias will be active.
     * Email aliases use a MailSlurp randomly generated email address (or a custom domain inbox that you provide) to mask or proxy a real email address. Emails sent to the alias address will be forwarded to the hidden email address it was created for. If you want to send a reply use the threadId attached
     * @param createAliasOptions createAliasOptions (required)
     * @return ApiResponse&lt;AliasDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AliasDto> createAliasWithHttpInfo(CreateAliasOptions createAliasOptions) throws ApiException {
        okhttp3.Call localVarCall = createAliasValidateBeforeCall(createAliasOptions, null);
        Type localVarReturnType = new TypeToken<AliasDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an email alias. Must be verified by clicking link inside verification email that will be sent to the address. Once verified the alias will be active. (asynchronously)
     * Email aliases use a MailSlurp randomly generated email address (or a custom domain inbox that you provide) to mask or proxy a real email address. Emails sent to the alias address will be forwarded to the hidden email address it was created for. If you want to send a reply use the threadId attached
     * @param createAliasOptions createAliasOptions (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createAliasAsync(CreateAliasOptions createAliasOptions, final ApiCallback<AliasDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = createAliasValidateBeforeCall(createAliasOptions, _callback);
        Type localVarReturnType = new TypeToken<AliasDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteAlias
     * @param aliasId aliasId (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAliasCall(UUID aliasId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/aliases/{aliasId}"
            .replaceAll("\\{" + "aliasId" + "\\}", localVarApiClient.escapeString(aliasId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteAliasValidateBeforeCall(UUID aliasId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'aliasId' is set
        if (aliasId == null) {
            throw new ApiException("Missing the required parameter 'aliasId' when calling deleteAlias(Async)");
        }
        

        okhttp3.Call localVarCall = deleteAliasCall(aliasId, _callback);
        return localVarCall;

    }

    /**
     * Delete an email alias
     * 
     * @param aliasId aliasId (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public void deleteAlias(UUID aliasId) throws ApiException {
        deleteAliasWithHttpInfo(aliasId);
    }

    /**
     * Delete an email alias
     * 
     * @param aliasId aliasId (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteAliasWithHttpInfo(UUID aliasId) throws ApiException {
        okhttp3.Call localVarCall = deleteAliasValidateBeforeCall(aliasId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete an email alias (asynchronously)
     * 
     * @param aliasId aliasId (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAliasAsync(UUID aliasId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteAliasValidateBeforeCall(aliasId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAlias
     * @param aliasId aliasId (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAliasCall(UUID aliasId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/aliases/{aliasId}"
            .replaceAll("\\{" + "aliasId" + "\\}", localVarApiClient.escapeString(aliasId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAliasValidateBeforeCall(UUID aliasId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'aliasId' is set
        if (aliasId == null) {
            throw new ApiException("Missing the required parameter 'aliasId' when calling getAlias(Async)");
        }
        

        okhttp3.Call localVarCall = getAliasCall(aliasId, _callback);
        return localVarCall;

    }

    /**
     * Get an email alias
     * Get an email alias by ID
     * @param aliasId aliasId (required)
     * @return AliasDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public AliasDto getAlias(UUID aliasId) throws ApiException {
        ApiResponse<AliasDto> localVarResp = getAliasWithHttpInfo(aliasId);
        return localVarResp.getData();
    }

    /**
     * Get an email alias
     * Get an email alias by ID
     * @param aliasId aliasId (required)
     * @return ApiResponse&lt;AliasDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AliasDto> getAliasWithHttpInfo(UUID aliasId) throws ApiException {
        okhttp3.Call localVarCall = getAliasValidateBeforeCall(aliasId, null);
        Type localVarReturnType = new TypeToken<AliasDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get an email alias (asynchronously)
     * Get an email alias by ID
     * @param aliasId aliasId (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAliasAsync(UUID aliasId, final ApiCallback<AliasDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAliasValidateBeforeCall(aliasId, _callback);
        Type localVarReturnType = new TypeToken<AliasDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAliasEmails
     * @param aliasId aliasId (required)
     * @param page Optional page index alias email list pagination (optional, default to 0)
     * @param size Optional page size alias email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAliasEmailsCall(UUID aliasId, Integer page, Integer size, String sort, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/aliases/{aliasId}/emails"
            .replaceAll("\\{" + "aliasId" + "\\}", localVarApiClient.escapeString(aliasId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAliasEmailsValidateBeforeCall(UUID aliasId, Integer page, Integer size, String sort, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'aliasId' is set
        if (aliasId == null) {
            throw new ApiException("Missing the required parameter 'aliasId' when calling getAliasEmails(Async)");
        }
        

        okhttp3.Call localVarCall = getAliasEmailsCall(aliasId, page, size, sort, _callback);
        return localVarCall;

    }

    /**
     * Get emails for an alias
     * Get paginated emails for an alias by ID
     * @param aliasId aliasId (required)
     * @param page Optional page index alias email list pagination (optional, default to 0)
     * @param size Optional page size alias email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @return PageEmailProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public PageEmailProjection getAliasEmails(UUID aliasId, Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageEmailProjection> localVarResp = getAliasEmailsWithHttpInfo(aliasId, page, size, sort);
        return localVarResp.getData();
    }

    /**
     * Get emails for an alias
     * Get paginated emails for an alias by ID
     * @param aliasId aliasId (required)
     * @param page Optional page index alias email list pagination (optional, default to 0)
     * @param size Optional page size alias email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @return ApiResponse&lt;PageEmailProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageEmailProjection> getAliasEmailsWithHttpInfo(UUID aliasId, Integer page, Integer size, String sort) throws ApiException {
        okhttp3.Call localVarCall = getAliasEmailsValidateBeforeCall(aliasId, page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get emails for an alias (asynchronously)
     * Get paginated emails for an alias by ID
     * @param aliasId aliasId (required)
     * @param page Optional page index alias email list pagination (optional, default to 0)
     * @param size Optional page size alias email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAliasEmailsAsync(UUID aliasId, Integer page, Integer size, String sort, final ApiCallback<PageEmailProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAliasEmailsValidateBeforeCall(aliasId, page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAliasThreads
     * @param aliasId aliasId (required)
     * @param page Optional page index in thread list pagination (optional, default to 0)
     * @param size Optional page size in thread list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAliasThreadsCall(UUID aliasId, Integer page, Integer size, String sort, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/aliases/{aliasId}/threads"
            .replaceAll("\\{" + "aliasId" + "\\}", localVarApiClient.escapeString(aliasId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAliasThreadsValidateBeforeCall(UUID aliasId, Integer page, Integer size, String sort, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'aliasId' is set
        if (aliasId == null) {
            throw new ApiException("Missing the required parameter 'aliasId' when calling getAliasThreads(Async)");
        }
        

        okhttp3.Call localVarCall = getAliasThreadsCall(aliasId, page, size, sort, _callback);
        return localVarCall;

    }

    /**
     * Get threads created for an alias
     * Returns threads created for an email alias in paginated form
     * @param aliasId aliasId (required)
     * @param page Optional page index in thread list pagination (optional, default to 0)
     * @param size Optional page size in thread list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @return PageThreadProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public PageThreadProjection getAliasThreads(UUID aliasId, Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageThreadProjection> localVarResp = getAliasThreadsWithHttpInfo(aliasId, page, size, sort);
        return localVarResp.getData();
    }

    /**
     * Get threads created for an alias
     * Returns threads created for an email alias in paginated form
     * @param aliasId aliasId (required)
     * @param page Optional page index in thread list pagination (optional, default to 0)
     * @param size Optional page size in thread list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @return ApiResponse&lt;PageThreadProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageThreadProjection> getAliasThreadsWithHttpInfo(UUID aliasId, Integer page, Integer size, String sort) throws ApiException {
        okhttp3.Call localVarCall = getAliasThreadsValidateBeforeCall(aliasId, page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageThreadProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get threads created for an alias (asynchronously)
     * Returns threads created for an email alias in paginated form
     * @param aliasId aliasId (required)
     * @param page Optional page index in thread list pagination (optional, default to 0)
     * @param size Optional page size in thread list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAliasThreadsAsync(UUID aliasId, Integer page, Integer size, String sort, final ApiCallback<PageThreadProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAliasThreadsValidateBeforeCall(aliasId, page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageThreadProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAliases
     * @param page Optional page index in alias list pagination (optional, default to 0)
     * @param size Optional page size in alias list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAliasesCall(Integer page, Integer size, String sort, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/aliases";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAliasesValidateBeforeCall(Integer page, Integer size, String sort, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAliasesCall(page, size, sort, _callback);
        return localVarCall;

    }

    /**
     * Get all email aliases you have created
     * Get all email aliases in paginated form
     * @param page Optional page index in alias list pagination (optional, default to 0)
     * @param size Optional page size in alias list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @return PageAlias
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public PageAlias getAliases(Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageAlias> localVarResp = getAliasesWithHttpInfo(page, size, sort);
        return localVarResp.getData();
    }

    /**
     * Get all email aliases you have created
     * Get all email aliases in paginated form
     * @param page Optional page index in alias list pagination (optional, default to 0)
     * @param size Optional page size in alias list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @return ApiResponse&lt;PageAlias&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageAlias> getAliasesWithHttpInfo(Integer page, Integer size, String sort) throws ApiException {
        okhttp3.Call localVarCall = getAliasesValidateBeforeCall(page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageAlias>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all email aliases you have created (asynchronously)
     * Get all email aliases in paginated form
     * @param page Optional page index in alias list pagination (optional, default to 0)
     * @param size Optional page size in alias list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAliasesAsync(Integer page, Integer size, String sort, final ApiCallback<PageAlias> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAliasesValidateBeforeCall(page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageAlias>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for replyToAliasEmail
     * @param aliasId ID of the alias that email belongs to (required)
     * @param emailId ID of the email that should be replied to (required)
     * @param replyToAliasEmailOptions replyToAliasEmailOptions (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call replyToAliasEmailCall(UUID aliasId, UUID emailId, ReplyToAliasEmailOptions replyToAliasEmailOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = replyToAliasEmailOptions;

        // create path and map variables
        String localVarPath = "/aliases/{aliasId}/emails/{emailId}"
            .replaceAll("\\{" + "aliasId" + "\\}", localVarApiClient.escapeString(aliasId.toString()))
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call replyToAliasEmailValidateBeforeCall(UUID aliasId, UUID emailId, ReplyToAliasEmailOptions replyToAliasEmailOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'aliasId' is set
        if (aliasId == null) {
            throw new ApiException("Missing the required parameter 'aliasId' when calling replyToAliasEmail(Async)");
        }
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling replyToAliasEmail(Async)");
        }
        
        // verify the required parameter 'replyToAliasEmailOptions' is set
        if (replyToAliasEmailOptions == null) {
            throw new ApiException("Missing the required parameter 'replyToAliasEmailOptions' when calling replyToAliasEmail(Async)");
        }
        

        okhttp3.Call localVarCall = replyToAliasEmailCall(aliasId, emailId, replyToAliasEmailOptions, _callback);
        return localVarCall;

    }

    /**
     * Reply to an email
     * Send the reply to the email sender or reply-to and include same subject cc bcc etc. Reply to an email and the contents will be sent with the existing subject to the emails &#x60;to&#x60;, &#x60;cc&#x60;, and &#x60;bcc&#x60;.
     * @param aliasId ID of the alias that email belongs to (required)
     * @param emailId ID of the email that should be replied to (required)
     * @param replyToAliasEmailOptions replyToAliasEmailOptions (required)
     * @return SentEmailDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public SentEmailDto replyToAliasEmail(UUID aliasId, UUID emailId, ReplyToAliasEmailOptions replyToAliasEmailOptions) throws ApiException {
        ApiResponse<SentEmailDto> localVarResp = replyToAliasEmailWithHttpInfo(aliasId, emailId, replyToAliasEmailOptions);
        return localVarResp.getData();
    }

    /**
     * Reply to an email
     * Send the reply to the email sender or reply-to and include same subject cc bcc etc. Reply to an email and the contents will be sent with the existing subject to the emails &#x60;to&#x60;, &#x60;cc&#x60;, and &#x60;bcc&#x60;.
     * @param aliasId ID of the alias that email belongs to (required)
     * @param emailId ID of the email that should be replied to (required)
     * @param replyToAliasEmailOptions replyToAliasEmailOptions (required)
     * @return ApiResponse&lt;SentEmailDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SentEmailDto> replyToAliasEmailWithHttpInfo(UUID aliasId, UUID emailId, ReplyToAliasEmailOptions replyToAliasEmailOptions) throws ApiException {
        okhttp3.Call localVarCall = replyToAliasEmailValidateBeforeCall(aliasId, emailId, replyToAliasEmailOptions, null);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Reply to an email (asynchronously)
     * Send the reply to the email sender or reply-to and include same subject cc bcc etc. Reply to an email and the contents will be sent with the existing subject to the emails &#x60;to&#x60;, &#x60;cc&#x60;, and &#x60;bcc&#x60;.
     * @param aliasId ID of the alias that email belongs to (required)
     * @param emailId ID of the email that should be replied to (required)
     * @param replyToAliasEmailOptions replyToAliasEmailOptions (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call replyToAliasEmailAsync(UUID aliasId, UUID emailId, ReplyToAliasEmailOptions replyToAliasEmailOptions, final ApiCallback<SentEmailDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = replyToAliasEmailValidateBeforeCall(aliasId, emailId, replyToAliasEmailOptions, _callback);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendAliasEmail
     * @param aliasId aliasId (required)
     * @param sendEmailOptions Options for the email to be sent (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendAliasEmailCall(UUID aliasId, SendEmailOptions sendEmailOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = sendEmailOptions;

        // create path and map variables
        String localVarPath = "/aliases/{aliasId}/emails"
            .replaceAll("\\{" + "aliasId" + "\\}", localVarApiClient.escapeString(aliasId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendAliasEmailValidateBeforeCall(UUID aliasId, SendEmailOptions sendEmailOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'aliasId' is set
        if (aliasId == null) {
            throw new ApiException("Missing the required parameter 'aliasId' when calling sendAliasEmail(Async)");
        }
        

        okhttp3.Call localVarCall = sendAliasEmailCall(aliasId, sendEmailOptions, _callback);
        return localVarCall;

    }

    /**
     * Send an email from an alias inbox
     * Send an email from an alias. Replies to the email will be forwarded to the alias masked email address
     * @param aliasId aliasId (required)
     * @param sendEmailOptions Options for the email to be sent (optional)
     * @return SentEmailDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public SentEmailDto sendAliasEmail(UUID aliasId, SendEmailOptions sendEmailOptions) throws ApiException {
        ApiResponse<SentEmailDto> localVarResp = sendAliasEmailWithHttpInfo(aliasId, sendEmailOptions);
        return localVarResp.getData();
    }

    /**
     * Send an email from an alias inbox
     * Send an email from an alias. Replies to the email will be forwarded to the alias masked email address
     * @param aliasId aliasId (required)
     * @param sendEmailOptions Options for the email to be sent (optional)
     * @return ApiResponse&lt;SentEmailDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SentEmailDto> sendAliasEmailWithHttpInfo(UUID aliasId, SendEmailOptions sendEmailOptions) throws ApiException {
        okhttp3.Call localVarCall = sendAliasEmailValidateBeforeCall(aliasId, sendEmailOptions, null);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Send an email from an alias inbox (asynchronously)
     * Send an email from an alias. Replies to the email will be forwarded to the alias masked email address
     * @param aliasId aliasId (required)
     * @param sendEmailOptions Options for the email to be sent (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendAliasEmailAsync(UUID aliasId, SendEmailOptions sendEmailOptions, final ApiCallback<SentEmailDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendAliasEmailValidateBeforeCall(aliasId, sendEmailOptions, _callback);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateAlias
     * @param aliasId aliasId (required)
     * @param updateAliasOptions updateAliasOptions (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateAliasCall(UUID aliasId, UpdateAliasOptions updateAliasOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = updateAliasOptions;

        // create path and map variables
        String localVarPath = "/aliases/{aliasId}"
            .replaceAll("\\{" + "aliasId" + "\\}", localVarApiClient.escapeString(aliasId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateAliasValidateBeforeCall(UUID aliasId, UpdateAliasOptions updateAliasOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'aliasId' is set
        if (aliasId == null) {
            throw new ApiException("Missing the required parameter 'aliasId' when calling updateAlias(Async)");
        }
        
        // verify the required parameter 'updateAliasOptions' is set
        if (updateAliasOptions == null) {
            throw new ApiException("Missing the required parameter 'updateAliasOptions' when calling updateAlias(Async)");
        }
        

        okhttp3.Call localVarCall = updateAliasCall(aliasId, updateAliasOptions, _callback);
        return localVarCall;

    }

    /**
     * Update an email alias
     * 
     * @param aliasId aliasId (required)
     * @param updateAliasOptions updateAliasOptions (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public void updateAlias(UUID aliasId, UpdateAliasOptions updateAliasOptions) throws ApiException {
        updateAliasWithHttpInfo(aliasId, updateAliasOptions);
    }

    /**
     * Update an email alias
     * 
     * @param aliasId aliasId (required)
     * @param updateAliasOptions updateAliasOptions (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> updateAliasWithHttpInfo(UUID aliasId, UpdateAliasOptions updateAliasOptions) throws ApiException {
        okhttp3.Call localVarCall = updateAliasValidateBeforeCall(aliasId, updateAliasOptions, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Update an email alias (asynchronously)
     * 
     * @param aliasId aliasId (required)
     * @param updateAliasOptions updateAliasOptions (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 202 </td><td> Accepted </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateAliasAsync(UUID aliasId, UpdateAliasOptions updateAliasOptions, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateAliasValidateBeforeCall(aliasId, updateAliasOptions, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}
