/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.AttachmentMetaData;
import com.mailslurp.models.ContentMatchOptions;
import com.mailslurp.models.DownloadAttachmentDto;
import com.mailslurp.models.Email;
import com.mailslurp.models.EmailContentMatchResult;
import com.mailslurp.models.EmailTextLinesResult;
import com.mailslurp.models.ForwardEmailOptions;
import com.mailslurp.models.PageEmailProjection;
import com.mailslurp.models.RawEmailJson;
import com.mailslurp.models.ReplyToEmailOptions;
import com.mailslurp.models.SentEmailDto;
import java.util.UUID;
import com.mailslurp.models.UnreadCount;
import com.mailslurp.models.ValidationDto;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EmailControllerApi {
    private ApiClient localVarApiClient;

    public EmailControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EmailControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for deleteAllEmails
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAllEmailsCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteAllEmailsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = deleteAllEmailsCall(_callback);
        return localVarCall;

    }

    /**
     * Delete all emails
     * Deletes all emails in your account. Be careful as emails cannot be recovered
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public void deleteAllEmails() throws ApiException {
        deleteAllEmailsWithHttpInfo();
    }

    /**
     * Delete all emails
     * Deletes all emails in your account. Be careful as emails cannot be recovered
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteAllEmailsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = deleteAllEmailsValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete all emails (asynchronously)
     * Deletes all emails in your account. Be careful as emails cannot be recovered
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAllEmailsAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteAllEmailsValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteEmail
     * @param emailId ID of email to delete (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteEmailCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteEmailValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling deleteEmail(Async)");
        }
        

        okhttp3.Call localVarCall = deleteEmailCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Delete an email
     * Deletes an email and removes it from the inbox. Deleted emails cannot be recovered.
     * @param emailId ID of email to delete (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public void deleteEmail(UUID emailId) throws ApiException {
        deleteEmailWithHttpInfo(emailId);
    }

    /**
     * Delete an email
     * Deletes an email and removes it from the inbox. Deleted emails cannot be recovered.
     * @param emailId ID of email to delete (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteEmailWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = deleteEmailValidateBeforeCall(emailId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete an email (asynchronously)
     * Deletes an email and removes it from the inbox. Deleted emails cannot be recovered.
     * @param emailId ID of email to delete (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteEmailAsync(UUID emailId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteEmailValidateBeforeCall(emailId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for downloadAttachment
     * @param attachmentId ID of attachment (required)
     * @param emailId ID of email (required)
     * @param apiKey Can pass apiKey in url for this request if you wish to download the file in a browser. Content type will be set to original content type of the attachment file. This is so that browsers can download the file correctly. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadAttachmentCall(String attachmentId, UUID emailId, String apiKey, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/attachments/{attachmentId}"
            .replaceAll("\\{" + "attachmentId" + "\\}", localVarApiClient.escapeString(attachmentId.toString()))
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiKey != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("apiKey", apiKey));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/octet-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call downloadAttachmentValidateBeforeCall(String attachmentId, UUID emailId, String apiKey, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'attachmentId' is set
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling downloadAttachment(Async)");
        }
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling downloadAttachment(Async)");
        }
        

        okhttp3.Call localVarCall = downloadAttachmentCall(attachmentId, emailId, apiKey, _callback);
        return localVarCall;

    }

    /**
     * Get email attachment bytes. If you have trouble with byte responses try the &#x60;downloadAttachmentBase64&#x60; response endpoints.
     * Returns the specified attachment for a given email as a stream / array of bytes. You can find attachment ids in email responses endpoint responses. The response type is application/octet-stream.
     * @param attachmentId ID of attachment (required)
     * @param emailId ID of email (required)
     * @param apiKey Can pass apiKey in url for this request if you wish to download the file in a browser. Content type will be set to original content type of the attachment file. This is so that browsers can download the file correctly. (optional)
     * @return byte[]
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public byte[] downloadAttachment(String attachmentId, UUID emailId, String apiKey) throws ApiException {
        ApiResponse<byte[]> localVarResp = downloadAttachmentWithHttpInfo(attachmentId, emailId, apiKey);
        return localVarResp.getData();
    }

    /**
     * Get email attachment bytes. If you have trouble with byte responses try the &#x60;downloadAttachmentBase64&#x60; response endpoints.
     * Returns the specified attachment for a given email as a stream / array of bytes. You can find attachment ids in email responses endpoint responses. The response type is application/octet-stream.
     * @param attachmentId ID of attachment (required)
     * @param emailId ID of email (required)
     * @param apiKey Can pass apiKey in url for this request if you wish to download the file in a browser. Content type will be set to original content type of the attachment file. This is so that browsers can download the file correctly. (optional)
     * @return ApiResponse&lt;byte[]&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<byte[]> downloadAttachmentWithHttpInfo(String attachmentId, UUID emailId, String apiKey) throws ApiException {
        okhttp3.Call localVarCall = downloadAttachmentValidateBeforeCall(attachmentId, emailId, apiKey, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email attachment bytes. If you have trouble with byte responses try the &#x60;downloadAttachmentBase64&#x60; response endpoints. (asynchronously)
     * Returns the specified attachment for a given email as a stream / array of bytes. You can find attachment ids in email responses endpoint responses. The response type is application/octet-stream.
     * @param attachmentId ID of attachment (required)
     * @param emailId ID of email (required)
     * @param apiKey Can pass apiKey in url for this request if you wish to download the file in a browser. Content type will be set to original content type of the attachment file. This is so that browsers can download the file correctly. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadAttachmentAsync(String attachmentId, UUID emailId, String apiKey, final ApiCallback<byte[]> _callback) throws ApiException {

        okhttp3.Call localVarCall = downloadAttachmentValidateBeforeCall(attachmentId, emailId, apiKey, _callback);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for downloadAttachmentBase64
     * @param attachmentId ID of attachment (required)
     * @param emailId ID of email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadAttachmentBase64Call(String attachmentId, UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/attachments/{attachmentId}/base64"
            .replaceAll("\\{" + "attachmentId" + "\\}", localVarApiClient.escapeString(attachmentId.toString()))
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call downloadAttachmentBase64ValidateBeforeCall(String attachmentId, UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'attachmentId' is set
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling downloadAttachmentBase64(Async)");
        }
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling downloadAttachmentBase64(Async)");
        }
        

        okhttp3.Call localVarCall = downloadAttachmentBase64Call(attachmentId, emailId, _callback);
        return localVarCall;

    }

    /**
     * Get email attachment as base64 encoded string (alternative to binary responses)
     * Returns the specified attachment for a given email as a base 64 encoded string. The response type is application/json. This method is similar to the &#x60;downloadAttachment&#x60; method but allows some clients to get around issues with binary responses.
     * @param attachmentId ID of attachment (required)
     * @param emailId ID of email (required)
     * @return DownloadAttachmentDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public DownloadAttachmentDto downloadAttachmentBase64(String attachmentId, UUID emailId) throws ApiException {
        ApiResponse<DownloadAttachmentDto> localVarResp = downloadAttachmentBase64WithHttpInfo(attachmentId, emailId);
        return localVarResp.getData();
    }

    /**
     * Get email attachment as base64 encoded string (alternative to binary responses)
     * Returns the specified attachment for a given email as a base 64 encoded string. The response type is application/json. This method is similar to the &#x60;downloadAttachment&#x60; method but allows some clients to get around issues with binary responses.
     * @param attachmentId ID of attachment (required)
     * @param emailId ID of email (required)
     * @return ApiResponse&lt;DownloadAttachmentDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<DownloadAttachmentDto> downloadAttachmentBase64WithHttpInfo(String attachmentId, UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = downloadAttachmentBase64ValidateBeforeCall(attachmentId, emailId, null);
        Type localVarReturnType = new TypeToken<DownloadAttachmentDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email attachment as base64 encoded string (alternative to binary responses) (asynchronously)
     * Returns the specified attachment for a given email as a base 64 encoded string. The response type is application/json. This method is similar to the &#x60;downloadAttachment&#x60; method but allows some clients to get around issues with binary responses.
     * @param attachmentId ID of attachment (required)
     * @param emailId ID of email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call downloadAttachmentBase64Async(String attachmentId, UUID emailId, final ApiCallback<DownloadAttachmentDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = downloadAttachmentBase64ValidateBeforeCall(attachmentId, emailId, _callback);
        Type localVarReturnType = new TypeToken<DownloadAttachmentDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for forwardEmail
     * @param emailId ID of email (required)
     * @param forwardEmailOptions forwardEmailOptions (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call forwardEmailCall(UUID emailId, ForwardEmailOptions forwardEmailOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = forwardEmailOptions;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/forward"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call forwardEmailValidateBeforeCall(UUID emailId, ForwardEmailOptions forwardEmailOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling forwardEmail(Async)");
        }
        
        // verify the required parameter 'forwardEmailOptions' is set
        if (forwardEmailOptions == null) {
            throw new ApiException("Missing the required parameter 'forwardEmailOptions' when calling forwardEmail(Async)");
        }
        

        okhttp3.Call localVarCall = forwardEmailCall(emailId, forwardEmailOptions, _callback);
        return localVarCall;

    }

    /**
     * Forward email
     * Forward an existing email to new recipients.
     * @param emailId ID of email (required)
     * @param forwardEmailOptions forwardEmailOptions (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public void forwardEmail(UUID emailId, ForwardEmailOptions forwardEmailOptions) throws ApiException {
        forwardEmailWithHttpInfo(emailId, forwardEmailOptions);
    }

    /**
     * Forward email
     * Forward an existing email to new recipients.
     * @param emailId ID of email (required)
     * @param forwardEmailOptions forwardEmailOptions (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> forwardEmailWithHttpInfo(UUID emailId, ForwardEmailOptions forwardEmailOptions) throws ApiException {
        okhttp3.Call localVarCall = forwardEmailValidateBeforeCall(emailId, forwardEmailOptions, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Forward email (asynchronously)
     * Forward an existing email to new recipients.
     * @param emailId ID of email (required)
     * @param forwardEmailOptions forwardEmailOptions (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call forwardEmailAsync(UUID emailId, ForwardEmailOptions forwardEmailOptions, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = forwardEmailValidateBeforeCall(emailId, forwardEmailOptions, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAttachmentMetaData
     * @param attachmentId ID of attachment (required)
     * @param emailId ID of email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAttachmentMetaDataCall(String attachmentId, UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/attachments/{attachmentId}/metadata"
            .replaceAll("\\{" + "attachmentId" + "\\}", localVarApiClient.escapeString(attachmentId.toString()))
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAttachmentMetaDataValidateBeforeCall(String attachmentId, UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'attachmentId' is set
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling getAttachmentMetaData(Async)");
        }
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getAttachmentMetaData(Async)");
        }
        

        okhttp3.Call localVarCall = getAttachmentMetaDataCall(attachmentId, emailId, _callback);
        return localVarCall;

    }

    /**
     * Get email attachment metadata
     * Returns the metadata such as name and content-type for a given attachment and email.
     * @param attachmentId ID of attachment (required)
     * @param emailId ID of email (required)
     * @return AttachmentMetaData
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public AttachmentMetaData getAttachmentMetaData(String attachmentId, UUID emailId) throws ApiException {
        ApiResponse<AttachmentMetaData> localVarResp = getAttachmentMetaDataWithHttpInfo(attachmentId, emailId);
        return localVarResp.getData();
    }

    /**
     * Get email attachment metadata
     * Returns the metadata such as name and content-type for a given attachment and email.
     * @param attachmentId ID of attachment (required)
     * @param emailId ID of email (required)
     * @return ApiResponse&lt;AttachmentMetaData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AttachmentMetaData> getAttachmentMetaDataWithHttpInfo(String attachmentId, UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = getAttachmentMetaDataValidateBeforeCall(attachmentId, emailId, null);
        Type localVarReturnType = new TypeToken<AttachmentMetaData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email attachment metadata (asynchronously)
     * Returns the metadata such as name and content-type for a given attachment and email.
     * @param attachmentId ID of attachment (required)
     * @param emailId ID of email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAttachmentMetaDataAsync(String attachmentId, UUID emailId, final ApiCallback<AttachmentMetaData> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAttachmentMetaDataValidateBeforeCall(attachmentId, emailId, _callback);
        Type localVarReturnType = new TypeToken<AttachmentMetaData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAttachments
     * @param emailId ID of email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAttachmentsCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/attachments"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAttachmentsValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getAttachments(Async)");
        }
        

        okhttp3.Call localVarCall = getAttachmentsCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Get all email attachment metadata
     * Returns an array of attachment metadata such as name and content-type for a given email if present.
     * @param emailId ID of email (required)
     * @return List&lt;AttachmentMetaData&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public List<AttachmentMetaData> getAttachments(UUID emailId) throws ApiException {
        ApiResponse<List<AttachmentMetaData>> localVarResp = getAttachmentsWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    /**
     * Get all email attachment metadata
     * Returns an array of attachment metadata such as name and content-type for a given email if present.
     * @param emailId ID of email (required)
     * @return ApiResponse&lt;List&lt;AttachmentMetaData&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<AttachmentMetaData>> getAttachmentsWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = getAttachmentsValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<List<AttachmentMetaData>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all email attachment metadata (asynchronously)
     * Returns an array of attachment metadata such as name and content-type for a given email if present.
     * @param emailId ID of email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAttachmentsAsync(UUID emailId, final ApiCallback<List<AttachmentMetaData>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAttachmentsValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<List<AttachmentMetaData>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmail
     * @param emailId emailId (required)
     * @param decode Decode email body quoted-printable encoding to plain text. SMTP servers often encode text using quoted-printable format (for instance &#x60;&#x3D;D7&#x60;). This can be a pain for testing (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailCall(UUID emailId, Boolean decode, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (decode != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decode", decode));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailValidateBeforeCall(UUID emailId, Boolean decode, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmail(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailCall(emailId, decode, _callback);
        return localVarCall;

    }

    /**
     * Get email content
     * Returns a email summary object with headers and content. To retrieve the raw unparsed email use the getRawEmail endpoints
     * @param emailId emailId (required)
     * @param decode Decode email body quoted-printable encoding to plain text. SMTP servers often encode text using quoted-printable format (for instance &#x60;&#x3D;D7&#x60;). This can be a pain for testing (optional, default to false)
     * @return Email
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public Email getEmail(UUID emailId, Boolean decode) throws ApiException {
        ApiResponse<Email> localVarResp = getEmailWithHttpInfo(emailId, decode);
        return localVarResp.getData();
    }

    /**
     * Get email content
     * Returns a email summary object with headers and content. To retrieve the raw unparsed email use the getRawEmail endpoints
     * @param emailId emailId (required)
     * @param decode Decode email body quoted-printable encoding to plain text. SMTP servers often encode text using quoted-printable format (for instance &#x60;&#x3D;D7&#x60;). This can be a pain for testing (optional, default to false)
     * @return ApiResponse&lt;Email&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Email> getEmailWithHttpInfo(UUID emailId, Boolean decode) throws ApiException {
        okhttp3.Call localVarCall = getEmailValidateBeforeCall(emailId, decode, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email content (asynchronously)
     * Returns a email summary object with headers and content. To retrieve the raw unparsed email use the getRawEmail endpoints
     * @param emailId emailId (required)
     * @param decode Decode email body quoted-printable encoding to plain text. SMTP servers often encode text using quoted-printable format (for instance &#x60;&#x3D;D7&#x60;). This can be a pain for testing (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailAsync(UUID emailId, Boolean decode, final ApiCallback<Email> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailValidateBeforeCall(emailId, decode, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmailContentMatch
     * @param emailId ID of email to match against (required)
     * @param contentMatchOptions contentMatchOptions (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailContentMatchCall(UUID emailId, ContentMatchOptions contentMatchOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = contentMatchOptions;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/contentMatch"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailContentMatchValidateBeforeCall(UUID emailId, ContentMatchOptions contentMatchOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailContentMatch(Async)");
        }
        
        // verify the required parameter 'contentMatchOptions' is set
        if (contentMatchOptions == null) {
            throw new ApiException("Missing the required parameter 'contentMatchOptions' when calling getEmailContentMatch(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailContentMatchCall(emailId, contentMatchOptions, _callback);
        return localVarCall;

    }

    /**
     * Get email content regex pattern match results. Runs regex against email body and returns match groups.
     * Return the matches for a given Java style regex pattern. Do not include the typical &#x60;/&#x60; at start or end of regex in some languages. Given an example &#x60;your code is: 12345&#x60; the pattern to extract match looks like &#x60;code is: (\\d{6})&#x60;. This will return an array of matches with the first matching the entire pattern and the subsequent matching the groups: &#x60;[&#39;code is: 123456&#39;, &#39;123456&#39;]&#x60; See https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html for more information of available patterns. 
     * @param emailId ID of email to match against (required)
     * @param contentMatchOptions contentMatchOptions (required)
     * @return EmailContentMatchResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public EmailContentMatchResult getEmailContentMatch(UUID emailId, ContentMatchOptions contentMatchOptions) throws ApiException {
        ApiResponse<EmailContentMatchResult> localVarResp = getEmailContentMatchWithHttpInfo(emailId, contentMatchOptions);
        return localVarResp.getData();
    }

    /**
     * Get email content regex pattern match results. Runs regex against email body and returns match groups.
     * Return the matches for a given Java style regex pattern. Do not include the typical &#x60;/&#x60; at start or end of regex in some languages. Given an example &#x60;your code is: 12345&#x60; the pattern to extract match looks like &#x60;code is: (\\d{6})&#x60;. This will return an array of matches with the first matching the entire pattern and the subsequent matching the groups: &#x60;[&#39;code is: 123456&#39;, &#39;123456&#39;]&#x60; See https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html for more information of available patterns. 
     * @param emailId ID of email to match against (required)
     * @param contentMatchOptions contentMatchOptions (required)
     * @return ApiResponse&lt;EmailContentMatchResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EmailContentMatchResult> getEmailContentMatchWithHttpInfo(UUID emailId, ContentMatchOptions contentMatchOptions) throws ApiException {
        okhttp3.Call localVarCall = getEmailContentMatchValidateBeforeCall(emailId, contentMatchOptions, null);
        Type localVarReturnType = new TypeToken<EmailContentMatchResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email content regex pattern match results. Runs regex against email body and returns match groups. (asynchronously)
     * Return the matches for a given Java style regex pattern. Do not include the typical &#x60;/&#x60; at start or end of regex in some languages. Given an example &#x60;your code is: 12345&#x60; the pattern to extract match looks like &#x60;code is: (\\d{6})&#x60;. This will return an array of matches with the first matching the entire pattern and the subsequent matching the groups: &#x60;[&#39;code is: 123456&#39;, &#39;123456&#39;]&#x60; See https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html for more information of available patterns. 
     * @param emailId ID of email to match against (required)
     * @param contentMatchOptions contentMatchOptions (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailContentMatchAsync(UUID emailId, ContentMatchOptions contentMatchOptions, final ApiCallback<EmailContentMatchResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailContentMatchValidateBeforeCall(emailId, contentMatchOptions, _callback);
        Type localVarReturnType = new TypeToken<EmailContentMatchResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmailHTML
     * @param emailId emailId (required)
     * @param decode decode (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailHTMLCall(UUID emailId, Boolean decode, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/html"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (decode != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decode", decode));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "text/html"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailHTMLValidateBeforeCall(UUID emailId, Boolean decode, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailHTML(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailHTMLCall(emailId, decode, _callback);
        return localVarCall;

    }

    /**
     * Get email content as HTML
     * Retrieve email content as HTML response for viewing in browsers. Decodes quoted-printable entities and converts charset to UTF-8. Pass your API KEY as a request parameter when viewing in a browser: &#x60;?apiKey&#x3D;xxx&#x60;
     * @param emailId emailId (required)
     * @param decode decode (optional, default to false)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public String getEmailHTML(UUID emailId, Boolean decode) throws ApiException {
        ApiResponse<String> localVarResp = getEmailHTMLWithHttpInfo(emailId, decode);
        return localVarResp.getData();
    }

    /**
     * Get email content as HTML
     * Retrieve email content as HTML response for viewing in browsers. Decodes quoted-printable entities and converts charset to UTF-8. Pass your API KEY as a request parameter when viewing in a browser: &#x60;?apiKey&#x3D;xxx&#x60;
     * @param emailId emailId (required)
     * @param decode decode (optional, default to false)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> getEmailHTMLWithHttpInfo(UUID emailId, Boolean decode) throws ApiException {
        okhttp3.Call localVarCall = getEmailHTMLValidateBeforeCall(emailId, decode, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get email content as HTML (asynchronously)
     * Retrieve email content as HTML response for viewing in browsers. Decodes quoted-printable entities and converts charset to UTF-8. Pass your API KEY as a request parameter when viewing in a browser: &#x60;?apiKey&#x3D;xxx&#x60;
     * @param emailId emailId (required)
     * @param decode decode (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailHTMLAsync(UUID emailId, Boolean decode, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailHTMLValidateBeforeCall(emailId, decode, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmailHTMLQuery
     * @param emailId ID of email to perform HTML query on (required)
     * @param htmlSelector HTML selector to search for. Uses JQuery/JSoup/CSS style selector like &#39;.my-div&#39; to match content. See https://jsoup.org/apidocs/org/jsoup/select/Selector.html for more information. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailHTMLQueryCall(UUID emailId, String htmlSelector, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/htmlQuery"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (htmlSelector != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("htmlSelector", htmlSelector));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailHTMLQueryValidateBeforeCall(UUID emailId, String htmlSelector, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailHTMLQuery(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailHTMLQueryCall(emailId, htmlSelector, _callback);
        return localVarCall;

    }

    /**
     * Parse and return text from an email, stripping HTML and decoding encoded characters
     * Parse an email body and return the content as an array of text. HTML parsing uses JSoup which supports JQuery/CSS style selectors
     * @param emailId ID of email to perform HTML query on (required)
     * @param htmlSelector HTML selector to search for. Uses JQuery/JSoup/CSS style selector like &#39;.my-div&#39; to match content. See https://jsoup.org/apidocs/org/jsoup/select/Selector.html for more information. (optional)
     * @return EmailTextLinesResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public EmailTextLinesResult getEmailHTMLQuery(UUID emailId, String htmlSelector) throws ApiException {
        ApiResponse<EmailTextLinesResult> localVarResp = getEmailHTMLQueryWithHttpInfo(emailId, htmlSelector);
        return localVarResp.getData();
    }

    /**
     * Parse and return text from an email, stripping HTML and decoding encoded characters
     * Parse an email body and return the content as an array of text. HTML parsing uses JSoup which supports JQuery/CSS style selectors
     * @param emailId ID of email to perform HTML query on (required)
     * @param htmlSelector HTML selector to search for. Uses JQuery/JSoup/CSS style selector like &#39;.my-div&#39; to match content. See https://jsoup.org/apidocs/org/jsoup/select/Selector.html for more information. (optional)
     * @return ApiResponse&lt;EmailTextLinesResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EmailTextLinesResult> getEmailHTMLQueryWithHttpInfo(UUID emailId, String htmlSelector) throws ApiException {
        okhttp3.Call localVarCall = getEmailHTMLQueryValidateBeforeCall(emailId, htmlSelector, null);
        Type localVarReturnType = new TypeToken<EmailTextLinesResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Parse and return text from an email, stripping HTML and decoding encoded characters (asynchronously)
     * Parse an email body and return the content as an array of text. HTML parsing uses JSoup which supports JQuery/CSS style selectors
     * @param emailId ID of email to perform HTML query on (required)
     * @param htmlSelector HTML selector to search for. Uses JQuery/JSoup/CSS style selector like &#39;.my-div&#39; to match content. See https://jsoup.org/apidocs/org/jsoup/select/Selector.html for more information. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailHTMLQueryAsync(UUID emailId, String htmlSelector, final ApiCallback<EmailTextLinesResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailHTMLQueryValidateBeforeCall(emailId, htmlSelector, _callback);
        Type localVarReturnType = new TypeToken<EmailTextLinesResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmailTextLines
     * @param emailId ID of email to fetch text for (required)
     * @param decodeHtmlEntities Decode HTML entities (optional)
     * @param lineSeparator Line separator character (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailTextLinesCall(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/textLines"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (decodeHtmlEntities != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("decodeHtmlEntities", decodeHtmlEntities));
        }

        if (lineSeparator != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("lineSeparator", lineSeparator));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailTextLinesValidateBeforeCall(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailTextLines(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailTextLinesCall(emailId, decodeHtmlEntities, lineSeparator, _callback);
        return localVarCall;

    }

    /**
     * Parse and return text from an email, stripping HTML and decoding encoded characters
     * Parse an email body and return the content as an array of strings. HTML parsing uses JSoup and UNIX line separators.
     * @param emailId ID of email to fetch text for (required)
     * @param decodeHtmlEntities Decode HTML entities (optional)
     * @param lineSeparator Line separator character (optional)
     * @return EmailTextLinesResult
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public EmailTextLinesResult getEmailTextLines(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator) throws ApiException {
        ApiResponse<EmailTextLinesResult> localVarResp = getEmailTextLinesWithHttpInfo(emailId, decodeHtmlEntities, lineSeparator);
        return localVarResp.getData();
    }

    /**
     * Parse and return text from an email, stripping HTML and decoding encoded characters
     * Parse an email body and return the content as an array of strings. HTML parsing uses JSoup and UNIX line separators.
     * @param emailId ID of email to fetch text for (required)
     * @param decodeHtmlEntities Decode HTML entities (optional)
     * @param lineSeparator Line separator character (optional)
     * @return ApiResponse&lt;EmailTextLinesResult&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<EmailTextLinesResult> getEmailTextLinesWithHttpInfo(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator) throws ApiException {
        okhttp3.Call localVarCall = getEmailTextLinesValidateBeforeCall(emailId, decodeHtmlEntities, lineSeparator, null);
        Type localVarReturnType = new TypeToken<EmailTextLinesResult>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Parse and return text from an email, stripping HTML and decoding encoded characters (asynchronously)
     * Parse an email body and return the content as an array of strings. HTML parsing uses JSoup and UNIX line separators.
     * @param emailId ID of email to fetch text for (required)
     * @param decodeHtmlEntities Decode HTML entities (optional)
     * @param lineSeparator Line separator character (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailTextLinesAsync(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator, final ApiCallback<EmailTextLinesResult> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailTextLinesValidateBeforeCall(emailId, decodeHtmlEntities, lineSeparator, _callback);
        Type localVarReturnType = new TypeToken<EmailTextLinesResult>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmailsPaginated
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailsPaginatedCall(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "inboxId", inboxId));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (unreadOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailsPaginatedValidateBeforeCall(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getEmailsPaginatedCall(inboxId, page, size, sort, unreadOnly, _callback);
        return localVarCall;

    }

    /**
     * Get all emails
     * By default returns all emails across all inboxes sorted by ascending created at date. Responses are paginated. You can restrict results to a list of inbox IDs. You can also filter out read messages
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @return PageEmailProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public PageEmailProjection getEmailsPaginated(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly) throws ApiException {
        ApiResponse<PageEmailProjection> localVarResp = getEmailsPaginatedWithHttpInfo(inboxId, page, size, sort, unreadOnly);
        return localVarResp.getData();
    }

    /**
     * Get all emails
     * By default returns all emails across all inboxes sorted by ascending created at date. Responses are paginated. You can restrict results to a list of inbox IDs. You can also filter out read messages
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @return ApiResponse&lt;PageEmailProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageEmailProjection> getEmailsPaginatedWithHttpInfo(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly) throws ApiException {
        okhttp3.Call localVarCall = getEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, unreadOnly, null);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all emails (asynchronously)
     * By default returns all emails across all inboxes sorted by ascending created at date. Responses are paginated. You can restrict results to a list of inbox IDs. You can also filter out read messages
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailsPaginatedAsync(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, final ApiCallback<PageEmailProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, unreadOnly, _callback);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getLatestEmail
     * @param inboxIds Optional set of inboxes to filter by. Only get the latest email from these inbox IDs (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLatestEmailCall(List<UUID> inboxIds, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/latest";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxIds != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "inboxIds", inboxIds));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getLatestEmailValidateBeforeCall(List<UUID> inboxIds, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getLatestEmailCall(inboxIds, _callback);
        return localVarCall;

    }

    /**
     * Get latest email
     * Get the newest email in all inboxes or in a passed set of inbox IDs
     * @param inboxIds Optional set of inboxes to filter by. Only get the latest email from these inbox IDs (optional)
     * @return Email
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public Email getLatestEmail(List<UUID> inboxIds) throws ApiException {
        ApiResponse<Email> localVarResp = getLatestEmailWithHttpInfo(inboxIds);
        return localVarResp.getData();
    }

    /**
     * Get latest email
     * Get the newest email in all inboxes or in a passed set of inbox IDs
     * @param inboxIds Optional set of inboxes to filter by. Only get the latest email from these inbox IDs (optional)
     * @return ApiResponse&lt;Email&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Email> getLatestEmailWithHttpInfo(List<UUID> inboxIds) throws ApiException {
        okhttp3.Call localVarCall = getLatestEmailValidateBeforeCall(inboxIds, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get latest email (asynchronously)
     * Get the newest email in all inboxes or in a passed set of inbox IDs
     * @param inboxIds Optional set of inboxes to filter by. Only get the latest email from these inbox IDs (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLatestEmailAsync(List<UUID> inboxIds, final ApiCallback<Email> _callback) throws ApiException {

        okhttp3.Call localVarCall = getLatestEmailValidateBeforeCall(inboxIds, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getLatestEmailInInbox
     * @param inboxId ID of the inbox you want to get the latest email from (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLatestEmailInInboxCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/latestIn";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inboxId", inboxId));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getLatestEmailInInboxValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getLatestEmailInInboxCall(inboxId, _callback);
        return localVarCall;

    }

    /**
     * Get latest email
     * Get the newest email in all inboxes or in a passed set of inbox IDs
     * @param inboxId ID of the inbox you want to get the latest email from (optional)
     * @return Email
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public Email getLatestEmailInInbox(UUID inboxId) throws ApiException {
        ApiResponse<Email> localVarResp = getLatestEmailInInboxWithHttpInfo(inboxId);
        return localVarResp.getData();
    }

    /**
     * Get latest email
     * Get the newest email in all inboxes or in a passed set of inbox IDs
     * @param inboxId ID of the inbox you want to get the latest email from (optional)
     * @return ApiResponse&lt;Email&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Email> getLatestEmailInInboxWithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = getLatestEmailInInboxValidateBeforeCall(inboxId, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get latest email (asynchronously)
     * Get the newest email in all inboxes or in a passed set of inbox IDs
     * @param inboxId ID of the inbox you want to get the latest email from (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getLatestEmailInInboxAsync(UUID inboxId, final ApiCallback<Email> _callback) throws ApiException {

        okhttp3.Call localVarCall = getLatestEmailInInboxValidateBeforeCall(inboxId, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getOrganizationEmailsPaginated
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOrganizationEmailsPaginatedCall(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/organization";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "inboxId", inboxId));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (unreadOnly != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOrganizationEmailsPaginatedValidateBeforeCall(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getOrganizationEmailsPaginatedCall(inboxId, page, size, sort, unreadOnly, _callback);
        return localVarCall;

    }

    /**
     * Get all organization emails
     * By default returns all emails across all team inboxes sorted by ascending created at date. Responses are paginated. You can restrict results to a list of inbox IDs. You can also filter out read messages
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @return PageEmailProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public PageEmailProjection getOrganizationEmailsPaginated(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly) throws ApiException {
        ApiResponse<PageEmailProjection> localVarResp = getOrganizationEmailsPaginatedWithHttpInfo(inboxId, page, size, sort, unreadOnly);
        return localVarResp.getData();
    }

    /**
     * Get all organization emails
     * By default returns all emails across all team inboxes sorted by ascending created at date. Responses are paginated. You can restrict results to a list of inbox IDs. You can also filter out read messages
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @return ApiResponse&lt;PageEmailProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageEmailProjection> getOrganizationEmailsPaginatedWithHttpInfo(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly) throws ApiException {
        okhttp3.Call localVarCall = getOrganizationEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, unreadOnly, null);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get all organization emails (asynchronously)
     * By default returns all emails across all team inboxes sorted by ascending created at date. Responses are paginated. You can restrict results to a list of inbox IDs. You can also filter out read messages
     * @param inboxId Optional inbox ids to filter by. Can be repeated. By default will use all inboxes belonging to your account. (optional)
     * @param page Optional page index in email list pagination (optional, default to 0)
     * @param size Optional page size in email list pagination. Maximum size is 100. Use page index and sort to page through larger results (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param unreadOnly Optional filter for unread emails only. All emails are considered unread until they are viewed in the dashboard or requested directly (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOrganizationEmailsPaginatedAsync(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, final ApiCallback<PageEmailProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getOrganizationEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, unreadOnly, _callback);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRawEmailContents
     * @param emailId ID of email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> text/plain raw email </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRawEmailContentsCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/raw"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRawEmailContentsValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getRawEmailContents(Async)");
        }
        

        okhttp3.Call localVarCall = getRawEmailContentsCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Get raw email string
     * Returns a raw, unparsed, and unprocessed email. If your client has issues processing the response it is likely due to the response content-type which is text/plain. If you need a JSON response content-type use the getRawEmailJson endpoint
     * @param emailId ID of email (required)
     * @return String
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> text/plain raw email </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public String getRawEmailContents(UUID emailId) throws ApiException {
        ApiResponse<String> localVarResp = getRawEmailContentsWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    /**
     * Get raw email string
     * Returns a raw, unparsed, and unprocessed email. If your client has issues processing the response it is likely due to the response content-type which is text/plain. If you need a JSON response content-type use the getRawEmailJson endpoint
     * @param emailId ID of email (required)
     * @return ApiResponse&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> text/plain raw email </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<String> getRawEmailContentsWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = getRawEmailContentsValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get raw email string (asynchronously)
     * Returns a raw, unparsed, and unprocessed email. If your client has issues processing the response it is likely due to the response content-type which is text/plain. If you need a JSON response content-type use the getRawEmailJson endpoint
     * @param emailId ID of email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> text/plain raw email </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRawEmailContentsAsync(UUID emailId, final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRawEmailContentsValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getRawEmailJson
     * @param emailId ID of email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRawEmailJsonCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/raw/json"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getRawEmailJsonValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getRawEmailJson(Async)");
        }
        

        okhttp3.Call localVarCall = getRawEmailJsonCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Get raw email in JSON
     * Returns a raw, unparsed, and unprocessed email wrapped in a JSON response object for easier handling when compared with the getRawEmail text/plain response
     * @param emailId ID of email (required)
     * @return RawEmailJson
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public RawEmailJson getRawEmailJson(UUID emailId) throws ApiException {
        ApiResponse<RawEmailJson> localVarResp = getRawEmailJsonWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    /**
     * Get raw email in JSON
     * Returns a raw, unparsed, and unprocessed email wrapped in a JSON response object for easier handling when compared with the getRawEmail text/plain response
     * @param emailId ID of email (required)
     * @return ApiResponse&lt;RawEmailJson&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<RawEmailJson> getRawEmailJsonWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = getRawEmailJsonValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<RawEmailJson>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get raw email in JSON (asynchronously)
     * Returns a raw, unparsed, and unprocessed email wrapped in a JSON response object for easier handling when compared with the getRawEmail text/plain response
     * @param emailId ID of email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getRawEmailJsonAsync(UUID emailId, final ApiCallback<RawEmailJson> _callback) throws ApiException {

        okhttp3.Call localVarCall = getRawEmailJsonValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<RawEmailJson>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getUnreadEmailCount
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUnreadEmailCountCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/unreadCount";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getUnreadEmailCountValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getUnreadEmailCountCall(_callback);
        return localVarCall;

    }

    /**
     * Get unread email count
     * Get number of emails unread
     * @return UnreadCount
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public UnreadCount getUnreadEmailCount() throws ApiException {
        ApiResponse<UnreadCount> localVarResp = getUnreadEmailCountWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get unread email count
     * Get number of emails unread
     * @return ApiResponse&lt;UnreadCount&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UnreadCount> getUnreadEmailCountWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getUnreadEmailCountValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<UnreadCount>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get unread email count (asynchronously)
     * Get number of emails unread
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getUnreadEmailCountAsync(final ApiCallback<UnreadCount> _callback) throws ApiException {

        okhttp3.Call localVarCall = getUnreadEmailCountValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<UnreadCount>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for replyToEmail
     * @param emailId ID of the email that should be replied to (required)
     * @param replyToEmailOptions replyToEmailOptions (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call replyToEmailCall(UUID emailId, ReplyToEmailOptions replyToEmailOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = replyToEmailOptions;

        // create path and map variables
        String localVarPath = "/emails/{emailId}"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call replyToEmailValidateBeforeCall(UUID emailId, ReplyToEmailOptions replyToEmailOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling replyToEmail(Async)");
        }
        
        // verify the required parameter 'replyToEmailOptions' is set
        if (replyToEmailOptions == null) {
            throw new ApiException("Missing the required parameter 'replyToEmailOptions' when calling replyToEmail(Async)");
        }
        

        okhttp3.Call localVarCall = replyToEmailCall(emailId, replyToEmailOptions, _callback);
        return localVarCall;

    }

    /**
     * Reply to an email
     * Send the reply to the email sender or reply-to and include same subject cc bcc etc. Reply to an email and the contents will be sent with the existing subject to the emails &#x60;to&#x60;, &#x60;cc&#x60;, and &#x60;bcc&#x60;.
     * @param emailId ID of the email that should be replied to (required)
     * @param replyToEmailOptions replyToEmailOptions (required)
     * @return SentEmailDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public SentEmailDto replyToEmail(UUID emailId, ReplyToEmailOptions replyToEmailOptions) throws ApiException {
        ApiResponse<SentEmailDto> localVarResp = replyToEmailWithHttpInfo(emailId, replyToEmailOptions);
        return localVarResp.getData();
    }

    /**
     * Reply to an email
     * Send the reply to the email sender or reply-to and include same subject cc bcc etc. Reply to an email and the contents will be sent with the existing subject to the emails &#x60;to&#x60;, &#x60;cc&#x60;, and &#x60;bcc&#x60;.
     * @param emailId ID of the email that should be replied to (required)
     * @param replyToEmailOptions replyToEmailOptions (required)
     * @return ApiResponse&lt;SentEmailDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SentEmailDto> replyToEmailWithHttpInfo(UUID emailId, ReplyToEmailOptions replyToEmailOptions) throws ApiException {
        okhttp3.Call localVarCall = replyToEmailValidateBeforeCall(emailId, replyToEmailOptions, null);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Reply to an email (asynchronously)
     * Send the reply to the email sender or reply-to and include same subject cc bcc etc. Reply to an email and the contents will be sent with the existing subject to the emails &#x60;to&#x60;, &#x60;cc&#x60;, and &#x60;bcc&#x60;.
     * @param emailId ID of the email that should be replied to (required)
     * @param replyToEmailOptions replyToEmailOptions (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call replyToEmailAsync(UUID emailId, ReplyToEmailOptions replyToEmailOptions, final ApiCallback<SentEmailDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = replyToEmailValidateBeforeCall(emailId, replyToEmailOptions, _callback);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for validateEmail
     * @param emailId ID of email (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call validateEmailCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/emails/{emailId}/validate"
            .replaceAll("\\{" + "emailId" + "\\}", localVarApiClient.escapeString(emailId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call validateEmailValidateBeforeCall(UUID emailId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'emailId' is set
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling validateEmail(Async)");
        }
        

        okhttp3.Call localVarCall = validateEmailCall(emailId, _callback);
        return localVarCall;

    }

    /**
     * Validate email
     * Validate the HTML content of email if HTML is found. Considered valid if no HTML.
     * @param emailId ID of email (required)
     * @return ValidationDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ValidationDto validateEmail(UUID emailId) throws ApiException {
        ApiResponse<ValidationDto> localVarResp = validateEmailWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    /**
     * Validate email
     * Validate the HTML content of email if HTML is found. Considered valid if no HTML.
     * @param emailId ID of email (required)
     * @return ApiResponse&lt;ValidationDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ValidationDto> validateEmailWithHttpInfo(UUID emailId) throws ApiException {
        okhttp3.Call localVarCall = validateEmailValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<ValidationDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Validate email (asynchronously)
     * Validate the HTML content of email if HTML is found. Considered valid if no HTML.
     * @param emailId ID of email (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call validateEmailAsync(UUID emailId, final ApiCallback<ValidationDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = validateEmailValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<ValidationDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
