/*
 * MailSlurp API
 * MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.   ## Resources - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository 
 *
 * The version of the OpenAPI document: 6.5.2
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.mailslurp.apis;

import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.clients.ProgressRequestBody;
import com.mailslurp.clients.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.mailslurp.models.CreateInboxDto;
import com.mailslurp.models.EmailPreview;
import com.mailslurp.models.Inbox;
import java.time.OffsetDateTime;
import com.mailslurp.models.PageEmailPreview;
import com.mailslurp.models.PageInboxProjection;
import com.mailslurp.models.PageOrganizationInboxProjection;
import com.mailslurp.models.PageSentEmailProjection;
import com.mailslurp.models.SendEmailOptions;
import com.mailslurp.models.SentEmailDto;
import com.mailslurp.models.SetInboxFavouritedOptions;
import java.util.UUID;
import com.mailslurp.models.UpdateInboxOptions;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InboxControllerApi {
    private ApiClient localVarApiClient;

    public InboxControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InboxControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createInbox
     * @param allowTeamAccess Grant team access to this inbox and the emails that belong to it for team members of your organization. (optional)
     * @param description Optional description of the inbox for labelling purposes. Is shown in the dashboard and can be used with (optional)
     * @param emailAddress A custom email address to use with the inbox. Defaults to null. When null MailSlurp will assign a random email address to the inbox such as &#x60;123@mailslurp.com&#x60;. If you use the &#x60;useDomainPool&#x60; option when the email address is null it will generate an email address with a more varied domain ending such as &#x60;123@mailslurp.info&#x60; or &#x60;123@mailslurp.biz&#x60;. When a custom email address is provided the address is split into a domain and the domain is queried against your user. If you have created the domain in the MailSlurp dashboard and verified it you can use any email address that ends with the domain. Send an email to this address and the inbox will receive and store it for you. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID. (optional)
     * @param expiresAt Optional inbox expiration date. If null then this inbox is permanent and the emails in it won&#39;t be deleted. If an expiration date is provided or is required by your plan the inbox will be closed when the expiration time is reached. Expired inboxes still contain their emails but can no longer send or receive emails. An ExpiredInboxRecord is created when an inbox and the email address and inbox ID are recorded. The expiresAt property is a timestamp string in ISO DateTime Format yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSXXX. (optional)
     * @param expiresIn Number of milliseconds that inbox should exist for (optional)
     * @param favourite Is the inbox favorited. Favouriting inboxes is typically done in the dashboard for quick access or filtering (optional)
     * @param name Optional name of the inbox. Displayed in the dashboard for easier search (optional)
     * @param tags Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI. (optional)
     * @param useDomainPool Use the MailSlurp domain name pool with this inbox when creating the email address. Defaults to null. If enabled the inbox will be an email address with a domain randomly chosen from a list of the MailSlurp domains. This is useful when the default &#x60;@mailslurp.com&#x60; email addresses used with inboxes are blocked or considered spam by a provider or receiving service. When domain pool is enabled an email address will be generated ending in &#x60;@mailslurp.{world,info,xyz,...}&#x60; . This means a TLD is randomly selecting from a list of &#x60;.biz&#x60;, &#x60;.info&#x60;, &#x60;.xyz&#x60; etc to add variance to the generated email addresses. When null or false MailSlurp uses the default behavior of &#x60;@mailslurp.com&#x60; or custom email address provided by the emailAddress field. (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createInboxCall(Boolean allowTeamAccess, String description, String emailAddress, OffsetDateTime expiresAt, Long expiresIn, Boolean favourite, String name, List<String> tags, Boolean useDomainPool, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (allowTeamAccess != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("allowTeamAccess", allowTeamAccess));
        }

        if (description != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("description", description));
        }

        if (emailAddress != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("emailAddress", emailAddress));
        }

        if (expiresAt != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiresAt", expiresAt));
        }

        if (expiresIn != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiresIn", expiresIn));
        }

        if (favourite != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("favourite", favourite));
        }

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (tags != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "tags", tags));
        }

        if (useDomainPool != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("useDomainPool", useDomainPool));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createInboxValidateBeforeCall(Boolean allowTeamAccess, String description, String emailAddress, OffsetDateTime expiresAt, Long expiresIn, Boolean favourite, String name, List<String> tags, Boolean useDomainPool, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = createInboxCall(allowTeamAccess, description, emailAddress, expiresAt, expiresIn, favourite, name, tags, useDomainPool, _callback);
        return localVarCall;

    }

    /**
     * Create an Inbox (email address)
     * Create a new inbox and with a randomized email address to send and receive from. Pass emailAddress parameter if you wish to use a specific email address. Creating an inbox is required before sending or receiving emails. If writing tests it is recommended that you create a new inbox during each test method so that it is unique and empty. 
     * @param allowTeamAccess Grant team access to this inbox and the emails that belong to it for team members of your organization. (optional)
     * @param description Optional description of the inbox for labelling purposes. Is shown in the dashboard and can be used with (optional)
     * @param emailAddress A custom email address to use with the inbox. Defaults to null. When null MailSlurp will assign a random email address to the inbox such as &#x60;123@mailslurp.com&#x60;. If you use the &#x60;useDomainPool&#x60; option when the email address is null it will generate an email address with a more varied domain ending such as &#x60;123@mailslurp.info&#x60; or &#x60;123@mailslurp.biz&#x60;. When a custom email address is provided the address is split into a domain and the domain is queried against your user. If you have created the domain in the MailSlurp dashboard and verified it you can use any email address that ends with the domain. Send an email to this address and the inbox will receive and store it for you. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID. (optional)
     * @param expiresAt Optional inbox expiration date. If null then this inbox is permanent and the emails in it won&#39;t be deleted. If an expiration date is provided or is required by your plan the inbox will be closed when the expiration time is reached. Expired inboxes still contain their emails but can no longer send or receive emails. An ExpiredInboxRecord is created when an inbox and the email address and inbox ID are recorded. The expiresAt property is a timestamp string in ISO DateTime Format yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSXXX. (optional)
     * @param expiresIn Number of milliseconds that inbox should exist for (optional)
     * @param favourite Is the inbox favorited. Favouriting inboxes is typically done in the dashboard for quick access or filtering (optional)
     * @param name Optional name of the inbox. Displayed in the dashboard for easier search (optional)
     * @param tags Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI. (optional)
     * @param useDomainPool Use the MailSlurp domain name pool with this inbox when creating the email address. Defaults to null. If enabled the inbox will be an email address with a domain randomly chosen from a list of the MailSlurp domains. This is useful when the default &#x60;@mailslurp.com&#x60; email addresses used with inboxes are blocked or considered spam by a provider or receiving service. When domain pool is enabled an email address will be generated ending in &#x60;@mailslurp.{world,info,xyz,...}&#x60; . This means a TLD is randomly selecting from a list of &#x60;.biz&#x60;, &#x60;.info&#x60;, &#x60;.xyz&#x60; etc to add variance to the generated email addresses. When null or false MailSlurp uses the default behavior of &#x60;@mailslurp.com&#x60; or custom email address provided by the emailAddress field. (optional)
     * @return Inbox
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public Inbox createInbox(Boolean allowTeamAccess, String description, String emailAddress, OffsetDateTime expiresAt, Long expiresIn, Boolean favourite, String name, List<String> tags, Boolean useDomainPool) throws ApiException {
        ApiResponse<Inbox> localVarResp = createInboxWithHttpInfo(allowTeamAccess, description, emailAddress, expiresAt, expiresIn, favourite, name, tags, useDomainPool);
        return localVarResp.getData();
    }

    /**
     * Create an Inbox (email address)
     * Create a new inbox and with a randomized email address to send and receive from. Pass emailAddress parameter if you wish to use a specific email address. Creating an inbox is required before sending or receiving emails. If writing tests it is recommended that you create a new inbox during each test method so that it is unique and empty. 
     * @param allowTeamAccess Grant team access to this inbox and the emails that belong to it for team members of your organization. (optional)
     * @param description Optional description of the inbox for labelling purposes. Is shown in the dashboard and can be used with (optional)
     * @param emailAddress A custom email address to use with the inbox. Defaults to null. When null MailSlurp will assign a random email address to the inbox such as &#x60;123@mailslurp.com&#x60;. If you use the &#x60;useDomainPool&#x60; option when the email address is null it will generate an email address with a more varied domain ending such as &#x60;123@mailslurp.info&#x60; or &#x60;123@mailslurp.biz&#x60;. When a custom email address is provided the address is split into a domain and the domain is queried against your user. If you have created the domain in the MailSlurp dashboard and verified it you can use any email address that ends with the domain. Send an email to this address and the inbox will receive and store it for you. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID. (optional)
     * @param expiresAt Optional inbox expiration date. If null then this inbox is permanent and the emails in it won&#39;t be deleted. If an expiration date is provided or is required by your plan the inbox will be closed when the expiration time is reached. Expired inboxes still contain their emails but can no longer send or receive emails. An ExpiredInboxRecord is created when an inbox and the email address and inbox ID are recorded. The expiresAt property is a timestamp string in ISO DateTime Format yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSXXX. (optional)
     * @param expiresIn Number of milliseconds that inbox should exist for (optional)
     * @param favourite Is the inbox favorited. Favouriting inboxes is typically done in the dashboard for quick access or filtering (optional)
     * @param name Optional name of the inbox. Displayed in the dashboard for easier search (optional)
     * @param tags Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI. (optional)
     * @param useDomainPool Use the MailSlurp domain name pool with this inbox when creating the email address. Defaults to null. If enabled the inbox will be an email address with a domain randomly chosen from a list of the MailSlurp domains. This is useful when the default &#x60;@mailslurp.com&#x60; email addresses used with inboxes are blocked or considered spam by a provider or receiving service. When domain pool is enabled an email address will be generated ending in &#x60;@mailslurp.{world,info,xyz,...}&#x60; . This means a TLD is randomly selecting from a list of &#x60;.biz&#x60;, &#x60;.info&#x60;, &#x60;.xyz&#x60; etc to add variance to the generated email addresses. When null or false MailSlurp uses the default behavior of &#x60;@mailslurp.com&#x60; or custom email address provided by the emailAddress field. (optional)
     * @return ApiResponse&lt;Inbox&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Inbox> createInboxWithHttpInfo(Boolean allowTeamAccess, String description, String emailAddress, OffsetDateTime expiresAt, Long expiresIn, Boolean favourite, String name, List<String> tags, Boolean useDomainPool) throws ApiException {
        okhttp3.Call localVarCall = createInboxValidateBeforeCall(allowTeamAccess, description, emailAddress, expiresAt, expiresIn, favourite, name, tags, useDomainPool, null);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an Inbox (email address) (asynchronously)
     * Create a new inbox and with a randomized email address to send and receive from. Pass emailAddress parameter if you wish to use a specific email address. Creating an inbox is required before sending or receiving emails. If writing tests it is recommended that you create a new inbox during each test method so that it is unique and empty. 
     * @param allowTeamAccess Grant team access to this inbox and the emails that belong to it for team members of your organization. (optional)
     * @param description Optional description of the inbox for labelling purposes. Is shown in the dashboard and can be used with (optional)
     * @param emailAddress A custom email address to use with the inbox. Defaults to null. When null MailSlurp will assign a random email address to the inbox such as &#x60;123@mailslurp.com&#x60;. If you use the &#x60;useDomainPool&#x60; option when the email address is null it will generate an email address with a more varied domain ending such as &#x60;123@mailslurp.info&#x60; or &#x60;123@mailslurp.biz&#x60;. When a custom email address is provided the address is split into a domain and the domain is queried against your user. If you have created the domain in the MailSlurp dashboard and verified it you can use any email address that ends with the domain. Send an email to this address and the inbox will receive and store it for you. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID. (optional)
     * @param expiresAt Optional inbox expiration date. If null then this inbox is permanent and the emails in it won&#39;t be deleted. If an expiration date is provided or is required by your plan the inbox will be closed when the expiration time is reached. Expired inboxes still contain their emails but can no longer send or receive emails. An ExpiredInboxRecord is created when an inbox and the email address and inbox ID are recorded. The expiresAt property is a timestamp string in ISO DateTime Format yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSXXX. (optional)
     * @param expiresIn Number of milliseconds that inbox should exist for (optional)
     * @param favourite Is the inbox favorited. Favouriting inboxes is typically done in the dashboard for quick access or filtering (optional)
     * @param name Optional name of the inbox. Displayed in the dashboard for easier search (optional)
     * @param tags Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI. (optional)
     * @param useDomainPool Use the MailSlurp domain name pool with this inbox when creating the email address. Defaults to null. If enabled the inbox will be an email address with a domain randomly chosen from a list of the MailSlurp domains. This is useful when the default &#x60;@mailslurp.com&#x60; email addresses used with inboxes are blocked or considered spam by a provider or receiving service. When domain pool is enabled an email address will be generated ending in &#x60;@mailslurp.{world,info,xyz,...}&#x60; . This means a TLD is randomly selecting from a list of &#x60;.biz&#x60;, &#x60;.info&#x60;, &#x60;.xyz&#x60; etc to add variance to the generated email addresses. When null or false MailSlurp uses the default behavior of &#x60;@mailslurp.com&#x60; or custom email address provided by the emailAddress field. (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createInboxAsync(Boolean allowTeamAccess, String description, String emailAddress, OffsetDateTime expiresAt, Long expiresIn, Boolean favourite, String name, List<String> tags, Boolean useDomainPool, final ApiCallback<Inbox> _callback) throws ApiException {

        okhttp3.Call localVarCall = createInboxValidateBeforeCall(allowTeamAccess, description, emailAddress, expiresAt, expiresIn, favourite, name, tags, useDomainPool, _callback);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createInboxWithOptions
     * @param createInboxDto createInboxDto (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createInboxWithOptionsCall(CreateInboxDto createInboxDto, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = createInboxDto;

        // create path and map variables
        String localVarPath = "/inboxes/withOptions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createInboxWithOptionsValidateBeforeCall(CreateInboxDto createInboxDto, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'createInboxDto' is set
        if (createInboxDto == null) {
            throw new ApiException("Missing the required parameter 'createInboxDto' when calling createInboxWithOptions(Async)");
        }
        

        okhttp3.Call localVarCall = createInboxWithOptionsCall(createInboxDto, _callback);
        return localVarCall;

    }

    /**
     * Create an inbox with additional options
     * Additional endpoint that allows inbox creation with request body options. Can be more flexible that other methods for some clients.
     * @param createInboxDto createInboxDto (required)
     * @return Inbox
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public Inbox createInboxWithOptions(CreateInboxDto createInboxDto) throws ApiException {
        ApiResponse<Inbox> localVarResp = createInboxWithOptionsWithHttpInfo(createInboxDto);
        return localVarResp.getData();
    }

    /**
     * Create an inbox with additional options
     * Additional endpoint that allows inbox creation with request body options. Can be more flexible that other methods for some clients.
     * @param createInboxDto createInboxDto (required)
     * @return ApiResponse&lt;Inbox&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Inbox> createInboxWithOptionsWithHttpInfo(CreateInboxDto createInboxDto) throws ApiException {
        okhttp3.Call localVarCall = createInboxWithOptionsValidateBeforeCall(createInboxDto, null);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an inbox with additional options (asynchronously)
     * Additional endpoint that allows inbox creation with request body options. Can be more flexible that other methods for some clients.
     * @param createInboxDto createInboxDto (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createInboxWithOptionsAsync(CreateInboxDto createInboxDto, final ApiCallback<Inbox> _callback) throws ApiException {

        okhttp3.Call localVarCall = createInboxWithOptionsValidateBeforeCall(createInboxDto, _callback);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteAllInboxes
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAllInboxesCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteAllInboxesValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = deleteAllInboxesCall(_callback);
        return localVarCall;

    }

    /**
     * Delete all inboxes
     * Permanently delete all inboxes and associated email addresses. This will also delete all emails within the inboxes. Be careful as inboxes cannot be recovered once deleted. Note: deleting inboxes will not impact your usage limits. Monthly inbox creation limits are based on how many inboxes were created in the last 30 days, not how many inboxes you currently have.
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public void deleteAllInboxes() throws ApiException {
        deleteAllInboxesWithHttpInfo();
    }

    /**
     * Delete all inboxes
     * Permanently delete all inboxes and associated email addresses. This will also delete all emails within the inboxes. Be careful as inboxes cannot be recovered once deleted. Note: deleting inboxes will not impact your usage limits. Monthly inbox creation limits are based on how many inboxes were created in the last 30 days, not how many inboxes you currently have.
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteAllInboxesWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = deleteAllInboxesValidateBeforeCall(null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete all inboxes (asynchronously)
     * Permanently delete all inboxes and associated email addresses. This will also delete all emails within the inboxes. Be careful as inboxes cannot be recovered once deleted. Note: deleting inboxes will not impact your usage limits. Monthly inbox creation limits are based on how many inboxes were created in the last 30 days, not how many inboxes you currently have.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteAllInboxesAsync(final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteAllInboxesValidateBeforeCall(_callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteInbox
     * @param inboxId inboxId (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteInboxCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteInboxValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling deleteInbox(Async)");
        }
        

        okhttp3.Call localVarCall = deleteInboxCall(inboxId, _callback);
        return localVarCall;

    }

    /**
     * Delete inbox
     * Permanently delete an inbox and associated email address as well as all emails within the given inbox. This action cannot be undone. Note: deleting an inbox will not affect your account usage. Monthly inbox usage is based on how many inboxes you create within 30 days, not how many exist at time of request.
     * @param inboxId inboxId (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public void deleteInbox(UUID inboxId) throws ApiException {
        deleteInboxWithHttpInfo(inboxId);
    }

    /**
     * Delete inbox
     * Permanently delete an inbox and associated email address as well as all emails within the given inbox. This action cannot be undone. Note: deleting an inbox will not affect your account usage. Monthly inbox usage is based on how many inboxes you create within 30 days, not how many exist at time of request.
     * @param inboxId inboxId (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> deleteInboxWithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = deleteInboxValidateBeforeCall(inboxId, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete inbox (asynchronously)
     * Permanently delete an inbox and associated email address as well as all emails within the given inbox. This action cannot be undone. Note: deleting an inbox will not affect your account usage. Monthly inbox usage is based on how many inboxes you create within 30 days, not how many exist at time of request.
     * @param inboxId inboxId (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteInboxAsync(UUID inboxId, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteInboxValidateBeforeCall(inboxId, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for getAllInboxes
     * @param favourite Optionally filter results for favourites only (optional, default to false)
     * @param page Optional page index in inbox list pagination (optional, default to 0)
     * @param search Optionally filter by search words partial matching ID, tags, name, and email address (optional)
     * @param size Optional page size in inbox list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param tag Optionally filter by tags. Will return inboxes that include given tags (optional)
     * @param teamAccess Optionally filter by team access. Defaults to false so organization inboxes are not included (optional, default to false)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllInboxesCall(Boolean favourite, Integer page, String search, Integer size, String sort, String tag, Boolean teamAccess, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/paginated";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (favourite != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("favourite", favourite));
        }

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (search != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("search", search));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        if (tag != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tag", tag));
        }

        if (teamAccess != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("teamAccess", teamAccess));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getAllInboxesValidateBeforeCall(Boolean favourite, Integer page, String search, Integer size, String sort, String tag, Boolean teamAccess, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getAllInboxesCall(favourite, page, search, size, sort, tag, teamAccess, _callback);
        return localVarCall;

    }

    /**
     * List All Inboxes Paginated
     * List inboxes in paginated form. The results are available on the &#x60;content&#x60; property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). You Can also filter by whether an inbox is favorited or use email address pattern. This method is the recommended way to query inboxes. The alternative &#x60;getInboxes&#x60; method returns a full list of inboxes but is limited to 100 results. Results do not include team access inboxes by default. Use organization method to list team inboxes or set &#x60;teamAccess&#x60; to true.
     * @param favourite Optionally filter results for favourites only (optional, default to false)
     * @param page Optional page index in inbox list pagination (optional, default to 0)
     * @param search Optionally filter by search words partial matching ID, tags, name, and email address (optional)
     * @param size Optional page size in inbox list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param tag Optionally filter by tags. Will return inboxes that include given tags (optional)
     * @param teamAccess Optionally filter by team access. Defaults to false so organization inboxes are not included (optional, default to false)
     * @return PageInboxProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public PageInboxProjection getAllInboxes(Boolean favourite, Integer page, String search, Integer size, String sort, String tag, Boolean teamAccess) throws ApiException {
        ApiResponse<PageInboxProjection> localVarResp = getAllInboxesWithHttpInfo(favourite, page, search, size, sort, tag, teamAccess);
        return localVarResp.getData();
    }

    /**
     * List All Inboxes Paginated
     * List inboxes in paginated form. The results are available on the &#x60;content&#x60; property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). You Can also filter by whether an inbox is favorited or use email address pattern. This method is the recommended way to query inboxes. The alternative &#x60;getInboxes&#x60; method returns a full list of inboxes but is limited to 100 results. Results do not include team access inboxes by default. Use organization method to list team inboxes or set &#x60;teamAccess&#x60; to true.
     * @param favourite Optionally filter results for favourites only (optional, default to false)
     * @param page Optional page index in inbox list pagination (optional, default to 0)
     * @param search Optionally filter by search words partial matching ID, tags, name, and email address (optional)
     * @param size Optional page size in inbox list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param tag Optionally filter by tags. Will return inboxes that include given tags (optional)
     * @param teamAccess Optionally filter by team access. Defaults to false so organization inboxes are not included (optional, default to false)
     * @return ApiResponse&lt;PageInboxProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageInboxProjection> getAllInboxesWithHttpInfo(Boolean favourite, Integer page, String search, Integer size, String sort, String tag, Boolean teamAccess) throws ApiException {
        okhttp3.Call localVarCall = getAllInboxesValidateBeforeCall(favourite, page, search, size, sort, tag, teamAccess, null);
        Type localVarReturnType = new TypeToken<PageInboxProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List All Inboxes Paginated (asynchronously)
     * List inboxes in paginated form. The results are available on the &#x60;content&#x60; property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). You Can also filter by whether an inbox is favorited or use email address pattern. This method is the recommended way to query inboxes. The alternative &#x60;getInboxes&#x60; method returns a full list of inboxes but is limited to 100 results. Results do not include team access inboxes by default. Use organization method to list team inboxes or set &#x60;teamAccess&#x60; to true.
     * @param favourite Optionally filter results for favourites only (optional, default to false)
     * @param page Optional page index in inbox list pagination (optional, default to 0)
     * @param search Optionally filter by search words partial matching ID, tags, name, and email address (optional)
     * @param size Optional page size in inbox list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param tag Optionally filter by tags. Will return inboxes that include given tags (optional)
     * @param teamAccess Optionally filter by team access. Defaults to false so organization inboxes are not included (optional, default to false)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getAllInboxesAsync(Boolean favourite, Integer page, String search, Integer size, String sort, String tag, Boolean teamAccess, final ApiCallback<PageInboxProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getAllInboxesValidateBeforeCall(favourite, page, search, size, sort, tag, teamAccess, _callback);
        Type localVarReturnType = new TypeToken<PageInboxProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getEmails
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param limit Limit the result set, ordered by received date time sort direction. Maximum 100. For more listing options see the email controller (optional)
     * @param minCount Minimum acceptable email count. Will cause request to hang (and retry) until minCount is satisfied or retryTimeout is reached. (optional)
     * @param retryTimeout Maximum milliseconds to spend retrying inbox database until minCount emails are returned (optional)
     * @param since Exclude emails received before this ISO 8601 date time (optional)
     * @param size Alias for limit. Assessed first before assessing any passed limit. (optional)
     * @param sort Sort the results by received date and direction ASC or DESC (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailsCall(UUID inboxId, Integer limit, Long minCount, Long retryTimeout, OffsetDateTime since, Integer size, String sort, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/emails"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (minCount != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("minCount", minCount));
        }

        if (retryTimeout != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("retryTimeout", retryTimeout));
        }

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEmailsValidateBeforeCall(UUID inboxId, Integer limit, Long minCount, Long retryTimeout, OffsetDateTime since, Integer size, String sort, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getEmails(Async)");
        }
        

        okhttp3.Call localVarCall = getEmailsCall(inboxId, limit, minCount, retryTimeout, since, size, sort, _callback);
        return localVarCall;

    }

    /**
     * Get emails in an Inbox. This method is not idempotent as it allows retries and waits if you want certain conditions to be met before returning. For simple listing and sorting of known emails use the email controller instead.
     * List emails that an inbox has received. Only emails that are sent to the inbox&#39;s email address will appear in the inbox. It may take several seconds for any email you send to an inbox&#39;s email address to appear in the inbox. To make this endpoint wait for a minimum number of emails use the &#x60;minCount&#x60; parameter. The server will retry the inbox database until the &#x60;minCount&#x60; is satisfied or the &#x60;retryTimeout&#x60; is reached
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param limit Limit the result set, ordered by received date time sort direction. Maximum 100. For more listing options see the email controller (optional)
     * @param minCount Minimum acceptable email count. Will cause request to hang (and retry) until minCount is satisfied or retryTimeout is reached. (optional)
     * @param retryTimeout Maximum milliseconds to spend retrying inbox database until minCount emails are returned (optional)
     * @param since Exclude emails received before this ISO 8601 date time (optional)
     * @param size Alias for limit. Assessed first before assessing any passed limit. (optional)
     * @param sort Sort the results by received date and direction ASC or DESC (optional)
     * @return List&lt;EmailPreview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public List<EmailPreview> getEmails(UUID inboxId, Integer limit, Long minCount, Long retryTimeout, OffsetDateTime since, Integer size, String sort) throws ApiException {
        ApiResponse<List<EmailPreview>> localVarResp = getEmailsWithHttpInfo(inboxId, limit, minCount, retryTimeout, since, size, sort);
        return localVarResp.getData();
    }

    /**
     * Get emails in an Inbox. This method is not idempotent as it allows retries and waits if you want certain conditions to be met before returning. For simple listing and sorting of known emails use the email controller instead.
     * List emails that an inbox has received. Only emails that are sent to the inbox&#39;s email address will appear in the inbox. It may take several seconds for any email you send to an inbox&#39;s email address to appear in the inbox. To make this endpoint wait for a minimum number of emails use the &#x60;minCount&#x60; parameter. The server will retry the inbox database until the &#x60;minCount&#x60; is satisfied or the &#x60;retryTimeout&#x60; is reached
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param limit Limit the result set, ordered by received date time sort direction. Maximum 100. For more listing options see the email controller (optional)
     * @param minCount Minimum acceptable email count. Will cause request to hang (and retry) until minCount is satisfied or retryTimeout is reached. (optional)
     * @param retryTimeout Maximum milliseconds to spend retrying inbox database until minCount emails are returned (optional)
     * @param since Exclude emails received before this ISO 8601 date time (optional)
     * @param size Alias for limit. Assessed first before assessing any passed limit. (optional)
     * @param sort Sort the results by received date and direction ASC or DESC (optional)
     * @return ApiResponse&lt;List&lt;EmailPreview&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<EmailPreview>> getEmailsWithHttpInfo(UUID inboxId, Integer limit, Long minCount, Long retryTimeout, OffsetDateTime since, Integer size, String sort) throws ApiException {
        okhttp3.Call localVarCall = getEmailsValidateBeforeCall(inboxId, limit, minCount, retryTimeout, since, size, sort, null);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get emails in an Inbox. This method is not idempotent as it allows retries and waits if you want certain conditions to be met before returning. For simple listing and sorting of known emails use the email controller instead. (asynchronously)
     * List emails that an inbox has received. Only emails that are sent to the inbox&#39;s email address will appear in the inbox. It may take several seconds for any email you send to an inbox&#39;s email address to appear in the inbox. To make this endpoint wait for a minimum number of emails use the &#x60;minCount&#x60; parameter. The server will retry the inbox database until the &#x60;minCount&#x60; is satisfied or the &#x60;retryTimeout&#x60; is reached
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param limit Limit the result set, ordered by received date time sort direction. Maximum 100. For more listing options see the email controller (optional)
     * @param minCount Minimum acceptable email count. Will cause request to hang (and retry) until minCount is satisfied or retryTimeout is reached. (optional)
     * @param retryTimeout Maximum milliseconds to spend retrying inbox database until minCount emails are returned (optional)
     * @param since Exclude emails received before this ISO 8601 date time (optional)
     * @param size Alias for limit. Assessed first before assessing any passed limit. (optional)
     * @param sort Sort the results by received date and direction ASC or DESC (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEmailsAsync(UUID inboxId, Integer limit, Long minCount, Long retryTimeout, OffsetDateTime since, Integer size, String sort, final ApiCallback<List<EmailPreview>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEmailsValidateBeforeCall(inboxId, limit, minCount, retryTimeout, since, size, sort, _callback);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInbox
     * @param inboxId inboxId (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxValidateBeforeCall(UUID inboxId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getInbox(Async)");
        }
        

        okhttp3.Call localVarCall = getInboxCall(inboxId, _callback);
        return localVarCall;

    }

    /**
     * Get Inbox
     * Returns an inbox&#39;s properties, including its email address and ID.
     * @param inboxId inboxId (required)
     * @return Inbox
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public Inbox getInbox(UUID inboxId) throws ApiException {
        ApiResponse<Inbox> localVarResp = getInboxWithHttpInfo(inboxId);
        return localVarResp.getData();
    }

    /**
     * Get Inbox
     * Returns an inbox&#39;s properties, including its email address and ID.
     * @param inboxId inboxId (required)
     * @return ApiResponse&lt;Inbox&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Inbox> getInboxWithHttpInfo(UUID inboxId) throws ApiException {
        okhttp3.Call localVarCall = getInboxValidateBeforeCall(inboxId, null);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Inbox (asynchronously)
     * Returns an inbox&#39;s properties, including its email address and ID.
     * @param inboxId inboxId (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxAsync(UUID inboxId, final ApiCallback<Inbox> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxValidateBeforeCall(inboxId, _callback);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxEmailsPaginated
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param page Optional page index in inbox emails list pagination (optional, default to 0)
     * @param size Optional page size in inbox emails list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxEmailsPaginatedCall(UUID inboxId, Integer page, Integer size, String sort, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/emails/paginated"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxEmailsPaginatedValidateBeforeCall(UUID inboxId, Integer page, Integer size, String sort, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getInboxEmailsPaginated(Async)");
        }
        

        okhttp3.Call localVarCall = getInboxEmailsPaginatedCall(inboxId, page, size, sort, _callback);
        return localVarCall;

    }

    /**
     * Get inbox emails paginated
     * Get a paginated list of emails in an inbox. Does not hold connections open.
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param page Optional page index in inbox emails list pagination (optional, default to 0)
     * @param size Optional page size in inbox emails list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @return PageEmailPreview
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public PageEmailPreview getInboxEmailsPaginated(UUID inboxId, Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageEmailPreview> localVarResp = getInboxEmailsPaginatedWithHttpInfo(inboxId, page, size, sort);
        return localVarResp.getData();
    }

    /**
     * Get inbox emails paginated
     * Get a paginated list of emails in an inbox. Does not hold connections open.
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param page Optional page index in inbox emails list pagination (optional, default to 0)
     * @param size Optional page size in inbox emails list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @return ApiResponse&lt;PageEmailPreview&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageEmailPreview> getInboxEmailsPaginatedWithHttpInfo(UUID inboxId, Integer page, Integer size, String sort) throws ApiException {
        okhttp3.Call localVarCall = getInboxEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageEmailPreview>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get inbox emails paginated (asynchronously)
     * Get a paginated list of emails in an inbox. Does not hold connections open.
     * @param inboxId Id of inbox that emails belongs to (required)
     * @param page Optional page index in inbox emails list pagination (optional, default to 0)
     * @param size Optional page size in inbox emails list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxEmailsPaginatedAsync(UUID inboxId, Integer page, Integer size, String sort, final ApiCallback<PageEmailPreview> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageEmailPreview>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxSentEmails
     * @param inboxId inboxId (required)
     * @param page Optional page index in inbox sent email list pagination (optional, default to 0)
     * @param size Optional page size in inbox sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxSentEmailsCall(UUID inboxId, Integer page, Integer size, String sort, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/sent"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxSentEmailsValidateBeforeCall(UUID inboxId, Integer page, Integer size, String sort, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getInboxSentEmails(Async)");
        }
        

        okhttp3.Call localVarCall = getInboxSentEmailsCall(inboxId, page, size, sort, _callback);
        return localVarCall;

    }

    /**
     * Get Inbox Sent Emails
     * Returns an inbox&#39;s sent email receipts. Call individual sent email endpoints for more details. Note for privacy reasons the full body of sent emails is never stored. An MD5 hash hex is available for comparison instead.
     * @param inboxId inboxId (required)
     * @param page Optional page index in inbox sent email list pagination (optional, default to 0)
     * @param size Optional page size in inbox sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @return PageSentEmailProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public PageSentEmailProjection getInboxSentEmails(UUID inboxId, Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageSentEmailProjection> localVarResp = getInboxSentEmailsWithHttpInfo(inboxId, page, size, sort);
        return localVarResp.getData();
    }

    /**
     * Get Inbox Sent Emails
     * Returns an inbox&#39;s sent email receipts. Call individual sent email endpoints for more details. Note for privacy reasons the full body of sent emails is never stored. An MD5 hash hex is available for comparison instead.
     * @param inboxId inboxId (required)
     * @param page Optional page index in inbox sent email list pagination (optional, default to 0)
     * @param size Optional page size in inbox sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @return ApiResponse&lt;PageSentEmailProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageSentEmailProjection> getInboxSentEmailsWithHttpInfo(UUID inboxId, Integer page, Integer size, String sort) throws ApiException {
        okhttp3.Call localVarCall = getInboxSentEmailsValidateBeforeCall(inboxId, page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageSentEmailProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get Inbox Sent Emails (asynchronously)
     * Returns an inbox&#39;s sent email receipts. Call individual sent email endpoints for more details. Note for privacy reasons the full body of sent emails is never stored. An MD5 hash hex is available for comparison instead.
     * @param inboxId inboxId (required)
     * @param page Optional page index in inbox sent email list pagination (optional, default to 0)
     * @param size Optional page size in inbox sent email list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxSentEmailsAsync(UUID inboxId, Integer page, Integer size, String sort, final ApiCallback<PageSentEmailProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxSentEmailsValidateBeforeCall(inboxId, page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageSentEmailProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxTags
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxTagsCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/tags";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxTagsValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getInboxTagsCall(_callback);
        return localVarCall;

    }

    /**
     * Get inbox tags
     * Get all inbox tags
     * @return List&lt;String&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public List<String> getInboxTags() throws ApiException {
        ApiResponse<List<String>> localVarResp = getInboxTagsWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Get inbox tags
     * Get all inbox tags
     * @return ApiResponse&lt;List&lt;String&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<String>> getInboxTagsWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = getInboxTagsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get inbox tags (asynchronously)
     * Get all inbox tags
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxTagsAsync(final ApiCallback<List<String>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxTagsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getInboxes
     * @param size Optional result size limit. Note an automatic limit of 100 results is applied. See the paginated &#x60;getAllEmails&#x60; for larger queries. (optional, default to 100)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxesCall(Integer size, String sort, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getInboxesValidateBeforeCall(Integer size, String sort, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getInboxesCall(size, sort, _callback);
        return localVarCall;

    }

    /**
     * List Inboxes / Email Addresses
     * List the inboxes you have created. Note use of the more advanced &#x60;getAllEmails&#x60; is recommended. You can provide a limit and sort parameter.
     * @param size Optional result size limit. Note an automatic limit of 100 results is applied. See the paginated &#x60;getAllEmails&#x60; for larger queries. (optional, default to 100)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @return List&lt;Inbox&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public List<Inbox> getInboxes(Integer size, String sort) throws ApiException {
        ApiResponse<List<Inbox>> localVarResp = getInboxesWithHttpInfo(size, sort);
        return localVarResp.getData();
    }

    /**
     * List Inboxes / Email Addresses
     * List the inboxes you have created. Note use of the more advanced &#x60;getAllEmails&#x60; is recommended. You can provide a limit and sort parameter.
     * @param size Optional result size limit. Note an automatic limit of 100 results is applied. See the paginated &#x60;getAllEmails&#x60; for larger queries. (optional, default to 100)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @return ApiResponse&lt;List&lt;Inbox&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Inbox>> getInboxesWithHttpInfo(Integer size, String sort) throws ApiException {
        okhttp3.Call localVarCall = getInboxesValidateBeforeCall(size, sort, null);
        Type localVarReturnType = new TypeToken<List<Inbox>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List Inboxes / Email Addresses (asynchronously)
     * List the inboxes you have created. Note use of the more advanced &#x60;getAllEmails&#x60; is recommended. You can provide a limit and sort parameter.
     * @param size Optional result size limit. Note an automatic limit of 100 results is applied. See the paginated &#x60;getAllEmails&#x60; for larger queries. (optional, default to 100)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getInboxesAsync(Integer size, String sort, final ApiCallback<List<Inbox>> _callback) throws ApiException {

        okhttp3.Call localVarCall = getInboxesValidateBeforeCall(size, sort, _callback);
        Type localVarReturnType = new TypeToken<List<Inbox>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getOrganizationInboxes
     * @param page Optional page index in inbox list pagination (optional, default to 0)
     * @param size Optional page size in inbox list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOrganizationInboxesCall(Integer page, Integer size, String sort, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/inboxes/organization";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (size != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("size", size));
        }

        if (sort != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("sort", sort));
        }

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getOrganizationInboxesValidateBeforeCall(Integer page, Integer size, String sort, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = getOrganizationInboxesCall(page, size, sort, _callback);
        return localVarCall;

    }

    /**
     * List Organization Inboxes Paginated
     * List organization inboxes in paginated form. These are inboxes created with &#x60;allowTeamAccess&#x60; flag enabled. Organization inboxes are &#x60;readOnly&#x60; for non-admin users. The results are available on the &#x60;content&#x60; property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). 
     * @param page Optional page index in inbox list pagination (optional, default to 0)
     * @param size Optional page size in inbox list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @return PageOrganizationInboxProjection
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public PageOrganizationInboxProjection getOrganizationInboxes(Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageOrganizationInboxProjection> localVarResp = getOrganizationInboxesWithHttpInfo(page, size, sort);
        return localVarResp.getData();
    }

    /**
     * List Organization Inboxes Paginated
     * List organization inboxes in paginated form. These are inboxes created with &#x60;allowTeamAccess&#x60; flag enabled. Organization inboxes are &#x60;readOnly&#x60; for non-admin users. The results are available on the &#x60;content&#x60; property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). 
     * @param page Optional page index in inbox list pagination (optional, default to 0)
     * @param size Optional page size in inbox list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @return ApiResponse&lt;PageOrganizationInboxProjection&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<PageOrganizationInboxProjection> getOrganizationInboxesWithHttpInfo(Integer page, Integer size, String sort) throws ApiException {
        okhttp3.Call localVarCall = getOrganizationInboxesValidateBeforeCall(page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageOrganizationInboxProjection>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List Organization Inboxes Paginated (asynchronously)
     * List organization inboxes in paginated form. These are inboxes created with &#x60;allowTeamAccess&#x60; flag enabled. Organization inboxes are &#x60;readOnly&#x60; for non-admin users. The results are available on the &#x60;content&#x60; property of the returned object. This method allows for page index (zero based), page size (how many results to return), and a sort direction (based on createdAt time). 
     * @param page Optional page index in inbox list pagination (optional, default to 0)
     * @param size Optional page size in inbox list pagination (optional, default to 20)
     * @param sort Optional createdAt sort direction ASC or DESC (optional, default to ASC)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getOrganizationInboxesAsync(Integer page, Integer size, String sort, final ApiCallback<PageOrganizationInboxProjection> _callback) throws ApiException {

        okhttp3.Call localVarCall = getOrganizationInboxesValidateBeforeCall(page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageOrganizationInboxProjection>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendEmail
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions Options for the email (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendEmailCall(UUID inboxId, SendEmailOptions sendEmailOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = sendEmailOptions;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendEmailValidateBeforeCall(UUID inboxId, SendEmailOptions sendEmailOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling sendEmail(Async)");
        }
        

        okhttp3.Call localVarCall = sendEmailCall(inboxId, sendEmailOptions, _callback);
        return localVarCall;

    }

    /**
     * Send Email
     * Send an email from an inbox&#39;s email address.  The request body should contain the &#x60;SendEmailOptions&#x60; that include recipients, attachments, body etc. See &#x60;SendEmailOptions&#x60; for all available properties. Note the &#x60;inboxId&#x60; refers to the inbox&#39;s id not the inbox&#39;s email address. See https://www.mailslurp.com/guides/ for more information on how to send emails. This method does not return a sent email entity due to legacy reasons. To send and get a sent email as returned response use the sister method &#x60;sendEmailAndConfirm&#x60;.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions Options for the email (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public void sendEmail(UUID inboxId, SendEmailOptions sendEmailOptions) throws ApiException {
        sendEmailWithHttpInfo(inboxId, sendEmailOptions);
    }

    /**
     * Send Email
     * Send an email from an inbox&#39;s email address.  The request body should contain the &#x60;SendEmailOptions&#x60; that include recipients, attachments, body etc. See &#x60;SendEmailOptions&#x60; for all available properties. Note the &#x60;inboxId&#x60; refers to the inbox&#39;s id not the inbox&#39;s email address. See https://www.mailslurp.com/guides/ for more information on how to send emails. This method does not return a sent email entity due to legacy reasons. To send and get a sent email as returned response use the sister method &#x60;sendEmailAndConfirm&#x60;.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions Options for the email (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> sendEmailWithHttpInfo(UUID inboxId, SendEmailOptions sendEmailOptions) throws ApiException {
        okhttp3.Call localVarCall = sendEmailValidateBeforeCall(inboxId, sendEmailOptions, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Send Email (asynchronously)
     * Send an email from an inbox&#39;s email address.  The request body should contain the &#x60;SendEmailOptions&#x60; that include recipients, attachments, body etc. See &#x60;SendEmailOptions&#x60; for all available properties. Note the &#x60;inboxId&#x60; refers to the inbox&#39;s id not the inbox&#39;s email address. See https://www.mailslurp.com/guides/ for more information on how to send emails. This method does not return a sent email entity due to legacy reasons. To send and get a sent email as returned response use the sister method &#x60;sendEmailAndConfirm&#x60;.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions Options for the email (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendEmailAsync(UUID inboxId, SendEmailOptions sendEmailOptions, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendEmailValidateBeforeCall(inboxId, sendEmailOptions, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendEmailAndConfirm
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions Options for the email (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendEmailAndConfirmCall(UUID inboxId, SendEmailOptions sendEmailOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = sendEmailOptions;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/confirm"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendEmailAndConfirmValidateBeforeCall(UUID inboxId, SendEmailOptions sendEmailOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling sendEmailAndConfirm(Async)");
        }
        

        okhttp3.Call localVarCall = sendEmailAndConfirmCall(inboxId, sendEmailOptions, _callback);
        return localVarCall;

    }

    /**
     * Send email and return sent confirmation
     * Sister method for standard &#x60;sendEmail&#x60; method with the benefit of returning a &#x60;SentEmail&#x60; entity confirming the successful sending of the email with link the the sent object created for it.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions Options for the email (optional)
     * @return SentEmailDto
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public SentEmailDto sendEmailAndConfirm(UUID inboxId, SendEmailOptions sendEmailOptions) throws ApiException {
        ApiResponse<SentEmailDto> localVarResp = sendEmailAndConfirmWithHttpInfo(inboxId, sendEmailOptions);
        return localVarResp.getData();
    }

    /**
     * Send email and return sent confirmation
     * Sister method for standard &#x60;sendEmail&#x60; method with the benefit of returning a &#x60;SentEmail&#x60; entity confirming the successful sending of the email with link the the sent object created for it.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions Options for the email (optional)
     * @return ApiResponse&lt;SentEmailDto&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SentEmailDto> sendEmailAndConfirmWithHttpInfo(UUID inboxId, SendEmailOptions sendEmailOptions) throws ApiException {
        okhttp3.Call localVarCall = sendEmailAndConfirmValidateBeforeCall(inboxId, sendEmailOptions, null);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Send email and return sent confirmation (asynchronously)
     * Sister method for standard &#x60;sendEmail&#x60; method with the benefit of returning a &#x60;SentEmail&#x60; entity confirming the successful sending of the email with link the the sent object created for it.
     * @param inboxId ID of the inbox you want to send the email from (required)
     * @param sendEmailOptions Options for the email (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendEmailAndConfirmAsync(UUID inboxId, SendEmailOptions sendEmailOptions, final ApiCallback<SentEmailDto> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendEmailAndConfirmValidateBeforeCall(inboxId, sendEmailOptions, _callback);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for setInboxFavourited
     * @param inboxId inboxId (required)
     * @param setInboxFavouritedOptions setInboxFavouritedOptions (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setInboxFavouritedCall(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = setInboxFavouritedOptions;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}/favourite"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call setInboxFavouritedValidateBeforeCall(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling setInboxFavourited(Async)");
        }
        
        // verify the required parameter 'setInboxFavouritedOptions' is set
        if (setInboxFavouritedOptions == null) {
            throw new ApiException("Missing the required parameter 'setInboxFavouritedOptions' when calling setInboxFavourited(Async)");
        }
        

        okhttp3.Call localVarCall = setInboxFavouritedCall(inboxId, setInboxFavouritedOptions, _callback);
        return localVarCall;

    }

    /**
     * Set inbox favourited state
     * Set and return new favourite state for an inbox
     * @param inboxId inboxId (required)
     * @param setInboxFavouritedOptions setInboxFavouritedOptions (required)
     * @return Inbox
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public Inbox setInboxFavourited(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions) throws ApiException {
        ApiResponse<Inbox> localVarResp = setInboxFavouritedWithHttpInfo(inboxId, setInboxFavouritedOptions);
        return localVarResp.getData();
    }

    /**
     * Set inbox favourited state
     * Set and return new favourite state for an inbox
     * @param inboxId inboxId (required)
     * @param setInboxFavouritedOptions setInboxFavouritedOptions (required)
     * @return ApiResponse&lt;Inbox&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Inbox> setInboxFavouritedWithHttpInfo(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions) throws ApiException {
        okhttp3.Call localVarCall = setInboxFavouritedValidateBeforeCall(inboxId, setInboxFavouritedOptions, null);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Set inbox favourited state (asynchronously)
     * Set and return new favourite state for an inbox
     * @param inboxId inboxId (required)
     * @param setInboxFavouritedOptions setInboxFavouritedOptions (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 201 </td><td> Created </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> Not Found </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call setInboxFavouritedAsync(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions, final ApiCallback<Inbox> _callback) throws ApiException {

        okhttp3.Call localVarCall = setInboxFavouritedValidateBeforeCall(inboxId, setInboxFavouritedOptions, _callback);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateInbox
     * @param inboxId inboxId (required)
     * @param updateInboxOptions updateInboxOptions (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateInboxCall(UUID inboxId, UpdateInboxOptions updateInboxOptions, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = updateInboxOptions;

        // create path and map variables
        String localVarPath = "/inboxes/{inboxId}"
            .replaceAll("\\{" + "inboxId" + "\\}", localVarApiClient.escapeString(inboxId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "API_KEY" };
        return localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateInboxValidateBeforeCall(UUID inboxId, UpdateInboxOptions updateInboxOptions, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'inboxId' is set
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling updateInbox(Async)");
        }
        
        // verify the required parameter 'updateInboxOptions' is set
        if (updateInboxOptions == null) {
            throw new ApiException("Missing the required parameter 'updateInboxOptions' when calling updateInbox(Async)");
        }
        

        okhttp3.Call localVarCall = updateInboxCall(inboxId, updateInboxOptions, _callback);
        return localVarCall;

    }

    /**
     * Update Inbox
     * Update editable fields on an inbox
     * @param inboxId inboxId (required)
     * @param updateInboxOptions updateInboxOptions (required)
     * @return Inbox
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public Inbox updateInbox(UUID inboxId, UpdateInboxOptions updateInboxOptions) throws ApiException {
        ApiResponse<Inbox> localVarResp = updateInboxWithHttpInfo(inboxId, updateInboxOptions);
        return localVarResp.getData();
    }

    /**
     * Update Inbox
     * Update editable fields on an inbox
     * @param inboxId inboxId (required)
     * @param updateInboxOptions updateInboxOptions (required)
     * @return ApiResponse&lt;Inbox&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Inbox> updateInboxWithHttpInfo(UUID inboxId, UpdateInboxOptions updateInboxOptions) throws ApiException {
        okhttp3.Call localVarCall = updateInboxValidateBeforeCall(inboxId, updateInboxOptions, null);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update Inbox (asynchronously)
     * Update editable fields on an inbox
     * @param inboxId inboxId (required)
     * @param updateInboxOptions updateInboxOptions (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 204 </td><td> No Content </td><td>  -  </td></tr>
        <tr><td> 401 </td><td> Unauthorized </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Forbidden </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateInboxAsync(UUID inboxId, UpdateInboxOptions updateInboxOptions, final ApiCallback<Inbox> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateInboxValidateBeforeCall(inboxId, updateInboxOptions, _callback);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
