/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.apis;

import com.google.gson.reflect.TypeToken;
import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.models.AliasDto;
import com.mailslurp.models.CreateAliasOptions;
import com.mailslurp.models.PageAlias;
import com.mailslurp.models.PageEmailProjection;
import com.mailslurp.models.PageThreadProjection;
import com.mailslurp.models.ReplyToAliasEmailOptions;
import com.mailslurp.models.SendEmailOptions;
import com.mailslurp.models.SentEmailDto;
import com.mailslurp.models.UpdateAliasOptions;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;

public class AliasControllerApi {
    private ApiClient localVarApiClient;

    public AliasControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AliasControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createAliasCall(CreateAliasOptions createAliasOptions, ApiCallback _callback) throws ApiException {
        CreateAliasOptions localVarPostBody = createAliasOptions;
        String localVarPath = "/aliases";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createAliasValidateBeforeCall(CreateAliasOptions createAliasOptions, ApiCallback _callback) throws ApiException {
        if (createAliasOptions == null) {
            throw new ApiException("Missing the required parameter 'createAliasOptions' when calling createAlias(Async)");
        }
        Call localVarCall = this.createAliasCall(createAliasOptions, _callback);
        return localVarCall;
    }

    public AliasDto createAlias(CreateAliasOptions createAliasOptions) throws ApiException {
        ApiResponse<AliasDto> localVarResp = this.createAliasWithHttpInfo(createAliasOptions);
        return localVarResp.getData();
    }

    public ApiResponse<AliasDto> createAliasWithHttpInfo(CreateAliasOptions createAliasOptions) throws ApiException {
        Call localVarCall = this.createAliasValidateBeforeCall(createAliasOptions, null);
        Type localVarReturnType = new TypeToken<AliasDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createAliasAsync(CreateAliasOptions createAliasOptions, ApiCallback<AliasDto> _callback) throws ApiException {
        Call localVarCall = this.createAliasValidateBeforeCall(createAliasOptions, _callback);
        Type localVarReturnType = new TypeToken<AliasDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAliasCall(UUID aliasId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/aliases/{aliasId}".replaceAll("\\{aliasId\\}", this.localVarApiClient.escapeString(aliasId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAliasValidateBeforeCall(UUID aliasId, ApiCallback _callback) throws ApiException {
        if (aliasId == null) {
            throw new ApiException("Missing the required parameter 'aliasId' when calling deleteAlias(Async)");
        }
        Call localVarCall = this.deleteAliasCall(aliasId, _callback);
        return localVarCall;
    }

    public void deleteAlias(UUID aliasId) throws ApiException {
        this.deleteAliasWithHttpInfo(aliasId);
    }

    public ApiResponse<Void> deleteAliasWithHttpInfo(UUID aliasId) throws ApiException {
        Call localVarCall = this.deleteAliasValidateBeforeCall(aliasId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAliasAsync(UUID aliasId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAliasValidateBeforeCall(aliasId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAliasCall(UUID aliasId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/aliases/{aliasId}".replaceAll("\\{aliasId\\}", this.localVarApiClient.escapeString(aliasId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAliasValidateBeforeCall(UUID aliasId, ApiCallback _callback) throws ApiException {
        if (aliasId == null) {
            throw new ApiException("Missing the required parameter 'aliasId' when calling getAlias(Async)");
        }
        Call localVarCall = this.getAliasCall(aliasId, _callback);
        return localVarCall;
    }

    public AliasDto getAlias(UUID aliasId) throws ApiException {
        ApiResponse<AliasDto> localVarResp = this.getAliasWithHttpInfo(aliasId);
        return localVarResp.getData();
    }

    public ApiResponse<AliasDto> getAliasWithHttpInfo(UUID aliasId) throws ApiException {
        Call localVarCall = this.getAliasValidateBeforeCall(aliasId, null);
        Type localVarReturnType = new TypeToken<AliasDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAliasAsync(UUID aliasId, ApiCallback<AliasDto> _callback) throws ApiException {
        Call localVarCall = this.getAliasValidateBeforeCall(aliasId, _callback);
        Type localVarReturnType = new TypeToken<AliasDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAliasEmailsCall(UUID aliasId, Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/aliases/{aliasId}/emails".replaceAll("\\{aliasId\\}", this.localVarApiClient.escapeString(aliasId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAliasEmailsValidateBeforeCall(UUID aliasId, Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        if (aliasId == null) {
            throw new ApiException("Missing the required parameter 'aliasId' when calling getAliasEmails(Async)");
        }
        Call localVarCall = this.getAliasEmailsCall(aliasId, page, size, sort, _callback);
        return localVarCall;
    }

    public PageEmailProjection getAliasEmails(UUID aliasId, Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageEmailProjection> localVarResp = this.getAliasEmailsWithHttpInfo(aliasId, page, size, sort);
        return localVarResp.getData();
    }

    public ApiResponse<PageEmailProjection> getAliasEmailsWithHttpInfo(UUID aliasId, Integer page, Integer size, String sort) throws ApiException {
        Call localVarCall = this.getAliasEmailsValidateBeforeCall(aliasId, page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAliasEmailsAsync(UUID aliasId, Integer page, Integer size, String sort, ApiCallback<PageEmailProjection> _callback) throws ApiException {
        Call localVarCall = this.getAliasEmailsValidateBeforeCall(aliasId, page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAliasThreadsCall(UUID aliasId, Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/aliases/{aliasId}/threads".replaceAll("\\{aliasId\\}", this.localVarApiClient.escapeString(aliasId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAliasThreadsValidateBeforeCall(UUID aliasId, Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        if (aliasId == null) {
            throw new ApiException("Missing the required parameter 'aliasId' when calling getAliasThreads(Async)");
        }
        Call localVarCall = this.getAliasThreadsCall(aliasId, page, size, sort, _callback);
        return localVarCall;
    }

    public PageThreadProjection getAliasThreads(UUID aliasId, Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageThreadProjection> localVarResp = this.getAliasThreadsWithHttpInfo(aliasId, page, size, sort);
        return localVarResp.getData();
    }

    public ApiResponse<PageThreadProjection> getAliasThreadsWithHttpInfo(UUID aliasId, Integer page, Integer size, String sort) throws ApiException {
        Call localVarCall = this.getAliasThreadsValidateBeforeCall(aliasId, page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageThreadProjection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAliasThreadsAsync(UUID aliasId, Integer page, Integer size, String sort, ApiCallback<PageThreadProjection> _callback) throws ApiException {
        Call localVarCall = this.getAliasThreadsValidateBeforeCall(aliasId, page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageThreadProjection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAliasesCall(Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/aliases";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAliasesValidateBeforeCall(Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAliasesCall(page, size, sort, _callback);
        return localVarCall;
    }

    public PageAlias getAliases(Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageAlias> localVarResp = this.getAliasesWithHttpInfo(page, size, sort);
        return localVarResp.getData();
    }

    public ApiResponse<PageAlias> getAliasesWithHttpInfo(Integer page, Integer size, String sort) throws ApiException {
        Call localVarCall = this.getAliasesValidateBeforeCall(page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageAlias>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAliasesAsync(Integer page, Integer size, String sort, ApiCallback<PageAlias> _callback) throws ApiException {
        Call localVarCall = this.getAliasesValidateBeforeCall(page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageAlias>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replyToAliasEmailCall(UUID aliasId, UUID emailId, ReplyToAliasEmailOptions replyToAliasEmailOptions, ApiCallback _callback) throws ApiException {
        ReplyToAliasEmailOptions localVarPostBody = replyToAliasEmailOptions;
        String localVarPath = "/aliases/{aliasId}/emails/{emailId}".replaceAll("\\{aliasId\\}", this.localVarApiClient.escapeString(aliasId.toString())).replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replyToAliasEmailValidateBeforeCall(UUID aliasId, UUID emailId, ReplyToAliasEmailOptions replyToAliasEmailOptions, ApiCallback _callback) throws ApiException {
        if (aliasId == null) {
            throw new ApiException("Missing the required parameter 'aliasId' when calling replyToAliasEmail(Async)");
        }
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling replyToAliasEmail(Async)");
        }
        if (replyToAliasEmailOptions == null) {
            throw new ApiException("Missing the required parameter 'replyToAliasEmailOptions' when calling replyToAliasEmail(Async)");
        }
        Call localVarCall = this.replyToAliasEmailCall(aliasId, emailId, replyToAliasEmailOptions, _callback);
        return localVarCall;
    }

    public SentEmailDto replyToAliasEmail(UUID aliasId, UUID emailId, ReplyToAliasEmailOptions replyToAliasEmailOptions) throws ApiException {
        ApiResponse<SentEmailDto> localVarResp = this.replyToAliasEmailWithHttpInfo(aliasId, emailId, replyToAliasEmailOptions);
        return localVarResp.getData();
    }

    public ApiResponse<SentEmailDto> replyToAliasEmailWithHttpInfo(UUID aliasId, UUID emailId, ReplyToAliasEmailOptions replyToAliasEmailOptions) throws ApiException {
        Call localVarCall = this.replyToAliasEmailValidateBeforeCall(aliasId, emailId, replyToAliasEmailOptions, null);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replyToAliasEmailAsync(UUID aliasId, UUID emailId, ReplyToAliasEmailOptions replyToAliasEmailOptions, ApiCallback<SentEmailDto> _callback) throws ApiException {
        Call localVarCall = this.replyToAliasEmailValidateBeforeCall(aliasId, emailId, replyToAliasEmailOptions, _callback);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call sendAliasEmailCall(UUID aliasId, SendEmailOptions sendEmailOptions, ApiCallback _callback) throws ApiException {
        SendEmailOptions localVarPostBody = sendEmailOptions;
        String localVarPath = "/aliases/{aliasId}/emails".replaceAll("\\{aliasId\\}", this.localVarApiClient.escapeString(aliasId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call sendAliasEmailValidateBeforeCall(UUID aliasId, SendEmailOptions sendEmailOptions, ApiCallback _callback) throws ApiException {
        if (aliasId == null) {
            throw new ApiException("Missing the required parameter 'aliasId' when calling sendAliasEmail(Async)");
        }
        Call localVarCall = this.sendAliasEmailCall(aliasId, sendEmailOptions, _callback);
        return localVarCall;
    }

    public SentEmailDto sendAliasEmail(UUID aliasId, SendEmailOptions sendEmailOptions) throws ApiException {
        ApiResponse<SentEmailDto> localVarResp = this.sendAliasEmailWithHttpInfo(aliasId, sendEmailOptions);
        return localVarResp.getData();
    }

    public ApiResponse<SentEmailDto> sendAliasEmailWithHttpInfo(UUID aliasId, SendEmailOptions sendEmailOptions) throws ApiException {
        Call localVarCall = this.sendAliasEmailValidateBeforeCall(aliasId, sendEmailOptions, null);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call sendAliasEmailAsync(UUID aliasId, SendEmailOptions sendEmailOptions, ApiCallback<SentEmailDto> _callback) throws ApiException {
        Call localVarCall = this.sendAliasEmailValidateBeforeCall(aliasId, sendEmailOptions, _callback);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateAliasCall(UUID aliasId, UpdateAliasOptions updateAliasOptions, ApiCallback _callback) throws ApiException {
        UpdateAliasOptions localVarPostBody = updateAliasOptions;
        String localVarPath = "/aliases/{aliasId}".replaceAll("\\{aliasId\\}", this.localVarApiClient.escapeString(aliasId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateAliasValidateBeforeCall(UUID aliasId, UpdateAliasOptions updateAliasOptions, ApiCallback _callback) throws ApiException {
        if (aliasId == null) {
            throw new ApiException("Missing the required parameter 'aliasId' when calling updateAlias(Async)");
        }
        if (updateAliasOptions == null) {
            throw new ApiException("Missing the required parameter 'updateAliasOptions' when calling updateAlias(Async)");
        }
        Call localVarCall = this.updateAliasCall(aliasId, updateAliasOptions, _callback);
        return localVarCall;
    }

    public void updateAlias(UUID aliasId, UpdateAliasOptions updateAliasOptions) throws ApiException {
        this.updateAliasWithHttpInfo(aliasId, updateAliasOptions);
    }

    public ApiResponse<Void> updateAliasWithHttpInfo(UUID aliasId, UpdateAliasOptions updateAliasOptions) throws ApiException {
        Call localVarCall = this.updateAliasValidateBeforeCall(aliasId, updateAliasOptions, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateAliasAsync(UUID aliasId, UpdateAliasOptions updateAliasOptions, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateAliasValidateBeforeCall(aliasId, updateAliasOptions, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

