/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.apis;

import com.google.gson.reflect.TypeToken;
import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.models.Inbox;
import com.mailslurp.models.SimpleSendEmailOptions;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;

public class CommonActionsControllerApi {
    private ApiClient localVarApiClient;

    public CommonActionsControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CommonActionsControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createNewEmailAddressCall(Boolean allowTeamAccess, OffsetDateTime expiresAt, Long expiresIn, Boolean useDomainPool, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/createInbox";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (allowTeamAccess != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowTeamAccess", allowTeamAccess));
        }
        if (expiresAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expiresAt", expiresAt));
        }
        if (expiresIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expiresIn", expiresIn));
        }
        if (useDomainPool != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("useDomainPool", useDomainPool));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNewEmailAddressValidateBeforeCall(Boolean allowTeamAccess, OffsetDateTime expiresAt, Long expiresIn, Boolean useDomainPool, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.createNewEmailAddressCall(allowTeamAccess, expiresAt, expiresIn, useDomainPool, _callback);
        return localVarCall;
    }

    public Inbox createNewEmailAddress(Boolean allowTeamAccess, OffsetDateTime expiresAt, Long expiresIn, Boolean useDomainPool) throws ApiException {
        ApiResponse<Inbox> localVarResp = this.createNewEmailAddressWithHttpInfo(allowTeamAccess, expiresAt, expiresIn, useDomainPool);
        return localVarResp.getData();
    }

    public ApiResponse<Inbox> createNewEmailAddressWithHttpInfo(Boolean allowTeamAccess, OffsetDateTime expiresAt, Long expiresIn, Boolean useDomainPool) throws ApiException {
        Call localVarCall = this.createNewEmailAddressValidateBeforeCall(allowTeamAccess, expiresAt, expiresIn, useDomainPool, null);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createNewEmailAddressAsync(Boolean allowTeamAccess, OffsetDateTime expiresAt, Long expiresIn, Boolean useDomainPool, ApiCallback<Inbox> _callback) throws ApiException {
        Call localVarCall = this.createNewEmailAddressValidateBeforeCall(allowTeamAccess, expiresAt, expiresIn, useDomainPool, _callback);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createNewEmailAddress1Call(Boolean allowTeamAccess, OffsetDateTime expiresAt, Long expiresIn, Boolean useDomainPool, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/newEmailAddress";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (allowTeamAccess != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowTeamAccess", allowTeamAccess));
        }
        if (expiresAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expiresAt", expiresAt));
        }
        if (expiresIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expiresIn", expiresIn));
        }
        if (useDomainPool != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("useDomainPool", useDomainPool));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createNewEmailAddress1ValidateBeforeCall(Boolean allowTeamAccess, OffsetDateTime expiresAt, Long expiresIn, Boolean useDomainPool, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.createNewEmailAddress1Call(allowTeamAccess, expiresAt, expiresIn, useDomainPool, _callback);
        return localVarCall;
    }

    public Inbox createNewEmailAddress1(Boolean allowTeamAccess, OffsetDateTime expiresAt, Long expiresIn, Boolean useDomainPool) throws ApiException {
        ApiResponse<Inbox> localVarResp = this.createNewEmailAddress1WithHttpInfo(allowTeamAccess, expiresAt, expiresIn, useDomainPool);
        return localVarResp.getData();
    }

    public ApiResponse<Inbox> createNewEmailAddress1WithHttpInfo(Boolean allowTeamAccess, OffsetDateTime expiresAt, Long expiresIn, Boolean useDomainPool) throws ApiException {
        Call localVarCall = this.createNewEmailAddress1ValidateBeforeCall(allowTeamAccess, expiresAt, expiresIn, useDomainPool, null);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createNewEmailAddress1Async(Boolean allowTeamAccess, OffsetDateTime expiresAt, Long expiresIn, Boolean useDomainPool, ApiCallback<Inbox> _callback) throws ApiException {
        Call localVarCall = this.createNewEmailAddress1ValidateBeforeCall(allowTeamAccess, expiresAt, expiresIn, useDomainPool, _callback);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call emptyInboxCall(UUID inboxId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emptyInbox";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("inboxId", inboxId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call emptyInboxValidateBeforeCall(UUID inboxId, ApiCallback _callback) throws ApiException {
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling emptyInbox(Async)");
        }
        Call localVarCall = this.emptyInboxCall(inboxId, _callback);
        return localVarCall;
    }

    public void emptyInbox(UUID inboxId) throws ApiException {
        this.emptyInboxWithHttpInfo(inboxId);
    }

    public ApiResponse<Void> emptyInboxWithHttpInfo(UUID inboxId) throws ApiException {
        Call localVarCall = this.emptyInboxValidateBeforeCall(inboxId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call emptyInboxAsync(UUID inboxId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.emptyInboxValidateBeforeCall(inboxId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call sendEmailSimpleCall(SimpleSendEmailOptions emailOptions, ApiCallback _callback) throws ApiException {
        SimpleSendEmailOptions localVarPostBody = emailOptions;
        String localVarPath = "/sendEmail";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call sendEmailSimpleValidateBeforeCall(SimpleSendEmailOptions emailOptions, ApiCallback _callback) throws ApiException {
        if (emailOptions == null) {
            throw new ApiException("Missing the required parameter 'emailOptions' when calling sendEmailSimple(Async)");
        }
        Call localVarCall = this.sendEmailSimpleCall(emailOptions, _callback);
        return localVarCall;
    }

    public void sendEmailSimple(SimpleSendEmailOptions emailOptions) throws ApiException {
        this.sendEmailSimpleWithHttpInfo(emailOptions);
    }

    public ApiResponse<Void> sendEmailSimpleWithHttpInfo(SimpleSendEmailOptions emailOptions) throws ApiException {
        Call localVarCall = this.sendEmailSimpleValidateBeforeCall(emailOptions, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call sendEmailSimpleAsync(SimpleSendEmailOptions emailOptions, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.sendEmailSimpleValidateBeforeCall(emailOptions, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

