/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.apis;

import com.google.gson.reflect.TypeToken;
import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.models.ContactDto;
import com.mailslurp.models.ContactProjection;
import com.mailslurp.models.CreateContactOptions;
import com.mailslurp.models.PageContactProjection;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.Call;

public class ContactControllerApi {
    private ApiClient localVarApiClient;

    public ContactControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ContactControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createContactCall(CreateContactOptions createContactOptions, ApiCallback _callback) throws ApiException {
        CreateContactOptions localVarPostBody = createContactOptions;
        String localVarPath = "/contacts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createContactValidateBeforeCall(CreateContactOptions createContactOptions, ApiCallback _callback) throws ApiException {
        if (createContactOptions == null) {
            throw new ApiException("Missing the required parameter 'createContactOptions' when calling createContact(Async)");
        }
        Call localVarCall = this.createContactCall(createContactOptions, _callback);
        return localVarCall;
    }

    public ContactDto createContact(CreateContactOptions createContactOptions) throws ApiException {
        ApiResponse<ContactDto> localVarResp = this.createContactWithHttpInfo(createContactOptions);
        return localVarResp.getData();
    }

    public ApiResponse<ContactDto> createContactWithHttpInfo(CreateContactOptions createContactOptions) throws ApiException {
        Call localVarCall = this.createContactValidateBeforeCall(createContactOptions, null);
        Type localVarReturnType = new TypeToken<ContactDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createContactAsync(CreateContactOptions createContactOptions, ApiCallback<ContactDto> _callback) throws ApiException {
        Call localVarCall = this.createContactValidateBeforeCall(createContactOptions, _callback);
        Type localVarReturnType = new TypeToken<ContactDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteContactCall(UUID contactId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/{contactId}".replaceAll("\\{contactId\\}", this.localVarApiClient.escapeString(contactId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteContactValidateBeforeCall(UUID contactId, ApiCallback _callback) throws ApiException {
        if (contactId == null) {
            throw new ApiException("Missing the required parameter 'contactId' when calling deleteContact(Async)");
        }
        Call localVarCall = this.deleteContactCall(contactId, _callback);
        return localVarCall;
    }

    public void deleteContact(UUID contactId) throws ApiException {
        this.deleteContactWithHttpInfo(contactId);
    }

    public ApiResponse<Void> deleteContactWithHttpInfo(UUID contactId) throws ApiException {
        Call localVarCall = this.deleteContactValidateBeforeCall(contactId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteContactAsync(UUID contactId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteContactValidateBeforeCall(contactId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAllContactsCall(Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/paginated";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllContactsValidateBeforeCall(Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAllContactsCall(page, size, sort, _callback);
        return localVarCall;
    }

    public PageContactProjection getAllContacts(Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageContactProjection> localVarResp = this.getAllContactsWithHttpInfo(page, size, sort);
        return localVarResp.getData();
    }

    public ApiResponse<PageContactProjection> getAllContactsWithHttpInfo(Integer page, Integer size, String sort) throws ApiException {
        Call localVarCall = this.getAllContactsValidateBeforeCall(page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageContactProjection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllContactsAsync(Integer page, Integer size, String sort, ApiCallback<PageContactProjection> _callback) throws ApiException {
        Call localVarCall = this.getAllContactsValidateBeforeCall(page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageContactProjection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getContactCall(UUID contactId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts/{contactId}".replaceAll("\\{contactId\\}", this.localVarApiClient.escapeString(contactId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getContactValidateBeforeCall(UUID contactId, ApiCallback _callback) throws ApiException {
        if (contactId == null) {
            throw new ApiException("Missing the required parameter 'contactId' when calling getContact(Async)");
        }
        Call localVarCall = this.getContactCall(contactId, _callback);
        return localVarCall;
    }

    public ContactDto getContact(UUID contactId) throws ApiException {
        ApiResponse<ContactDto> localVarResp = this.getContactWithHttpInfo(contactId);
        return localVarResp.getData();
    }

    public ApiResponse<ContactDto> getContactWithHttpInfo(UUID contactId) throws ApiException {
        Call localVarCall = this.getContactValidateBeforeCall(contactId, null);
        Type localVarReturnType = new TypeToken<ContactDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getContactAsync(UUID contactId, ApiCallback<ContactDto> _callback) throws ApiException {
        Call localVarCall = this.getContactValidateBeforeCall(contactId, _callback);
        Type localVarReturnType = new TypeToken<ContactDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getContactsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/contacts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getContactsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getContactsCall(_callback);
        return localVarCall;
    }

    public List<ContactProjection> getContacts() throws ApiException {
        ApiResponse<List<ContactProjection>> localVarResp = this.getContactsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<ContactProjection>> getContactsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getContactsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<ContactProjection>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getContactsAsync(ApiCallback<List<ContactProjection>> _callback) throws ApiException {
        Call localVarCall = this.getContactsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<ContactProjection>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

