/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.apis;

import com.google.gson.reflect.TypeToken;
import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.models.AttachmentMetaData;
import com.mailslurp.models.ContentMatchOptions;
import com.mailslurp.models.DownloadAttachmentDto;
import com.mailslurp.models.Email;
import com.mailslurp.models.EmailContentMatchResult;
import com.mailslurp.models.EmailTextLinesResult;
import com.mailslurp.models.ForwardEmailOptions;
import com.mailslurp.models.PageEmailProjection;
import com.mailslurp.models.RawEmailJson;
import com.mailslurp.models.ReplyToEmailOptions;
import com.mailslurp.models.SentEmailDto;
import com.mailslurp.models.UnreadCount;
import com.mailslurp.models.ValidationDto;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.Call;

public class EmailControllerApi {
    private ApiClient localVarApiClient;

    public EmailControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EmailControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call deleteAllEmailsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAllEmailsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.deleteAllEmailsCall(_callback);
        return localVarCall;
    }

    public void deleteAllEmails() throws ApiException {
        this.deleteAllEmailsWithHttpInfo();
    }

    public ApiResponse<Void> deleteAllEmailsWithHttpInfo() throws ApiException {
        Call localVarCall = this.deleteAllEmailsValidateBeforeCall(null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAllEmailsAsync(ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAllEmailsValidateBeforeCall(_callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteEmailCall(UUID emailId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/{emailId}".replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteEmailValidateBeforeCall(UUID emailId, ApiCallback _callback) throws ApiException {
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling deleteEmail(Async)");
        }
        Call localVarCall = this.deleteEmailCall(emailId, _callback);
        return localVarCall;
    }

    public void deleteEmail(UUID emailId) throws ApiException {
        this.deleteEmailWithHttpInfo(emailId);
    }

    public ApiResponse<Void> deleteEmailWithHttpInfo(UUID emailId) throws ApiException {
        Call localVarCall = this.deleteEmailValidateBeforeCall(emailId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteEmailAsync(UUID emailId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteEmailValidateBeforeCall(emailId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call downloadAttachmentCall(String attachmentId, UUID emailId, String apiKey, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/{emailId}/attachments/{attachmentId}".replaceAll("\\{attachmentId\\}", this.localVarApiClient.escapeString(attachmentId.toString())).replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (apiKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("apiKey", apiKey));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadAttachmentValidateBeforeCall(String attachmentId, UUID emailId, String apiKey, ApiCallback _callback) throws ApiException {
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling downloadAttachment(Async)");
        }
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling downloadAttachment(Async)");
        }
        Call localVarCall = this.downloadAttachmentCall(attachmentId, emailId, apiKey, _callback);
        return localVarCall;
    }

    public byte[] downloadAttachment(String attachmentId, UUID emailId, String apiKey) throws ApiException {
        ApiResponse<byte[]> localVarResp = this.downloadAttachmentWithHttpInfo(attachmentId, emailId, apiKey);
        return localVarResp.getData();
    }

    public ApiResponse<byte[]> downloadAttachmentWithHttpInfo(String attachmentId, UUID emailId, String apiKey) throws ApiException {
        Call localVarCall = this.downloadAttachmentValidateBeforeCall(attachmentId, emailId, apiKey, null);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call downloadAttachmentAsync(String attachmentId, UUID emailId, String apiKey, ApiCallback<byte[]> _callback) throws ApiException {
        Call localVarCall = this.downloadAttachmentValidateBeforeCall(attachmentId, emailId, apiKey, _callback);
        Type localVarReturnType = new TypeToken<byte[]>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call downloadAttachmentBase64Call(String attachmentId, UUID emailId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/{emailId}/attachments/{attachmentId}/base64".replaceAll("\\{attachmentId\\}", this.localVarApiClient.escapeString(attachmentId.toString())).replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call downloadAttachmentBase64ValidateBeforeCall(String attachmentId, UUID emailId, ApiCallback _callback) throws ApiException {
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling downloadAttachmentBase64(Async)");
        }
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling downloadAttachmentBase64(Async)");
        }
        Call localVarCall = this.downloadAttachmentBase64Call(attachmentId, emailId, _callback);
        return localVarCall;
    }

    public DownloadAttachmentDto downloadAttachmentBase64(String attachmentId, UUID emailId) throws ApiException {
        ApiResponse<DownloadAttachmentDto> localVarResp = this.downloadAttachmentBase64WithHttpInfo(attachmentId, emailId);
        return localVarResp.getData();
    }

    public ApiResponse<DownloadAttachmentDto> downloadAttachmentBase64WithHttpInfo(String attachmentId, UUID emailId) throws ApiException {
        Call localVarCall = this.downloadAttachmentBase64ValidateBeforeCall(attachmentId, emailId, null);
        Type localVarReturnType = new TypeToken<DownloadAttachmentDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call downloadAttachmentBase64Async(String attachmentId, UUID emailId, ApiCallback<DownloadAttachmentDto> _callback) throws ApiException {
        Call localVarCall = this.downloadAttachmentBase64ValidateBeforeCall(attachmentId, emailId, _callback);
        Type localVarReturnType = new TypeToken<DownloadAttachmentDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call forwardEmailCall(UUID emailId, ForwardEmailOptions forwardEmailOptions, ApiCallback _callback) throws ApiException {
        ForwardEmailOptions localVarPostBody = forwardEmailOptions;
        String localVarPath = "/emails/{emailId}/forward".replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call forwardEmailValidateBeforeCall(UUID emailId, ForwardEmailOptions forwardEmailOptions, ApiCallback _callback) throws ApiException {
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling forwardEmail(Async)");
        }
        if (forwardEmailOptions == null) {
            throw new ApiException("Missing the required parameter 'forwardEmailOptions' when calling forwardEmail(Async)");
        }
        Call localVarCall = this.forwardEmailCall(emailId, forwardEmailOptions, _callback);
        return localVarCall;
    }

    public void forwardEmail(UUID emailId, ForwardEmailOptions forwardEmailOptions) throws ApiException {
        this.forwardEmailWithHttpInfo(emailId, forwardEmailOptions);
    }

    public ApiResponse<Void> forwardEmailWithHttpInfo(UUID emailId, ForwardEmailOptions forwardEmailOptions) throws ApiException {
        Call localVarCall = this.forwardEmailValidateBeforeCall(emailId, forwardEmailOptions, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call forwardEmailAsync(UUID emailId, ForwardEmailOptions forwardEmailOptions, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.forwardEmailValidateBeforeCall(emailId, forwardEmailOptions, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAttachmentMetaDataCall(String attachmentId, UUID emailId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/{emailId}/attachments/{attachmentId}/metadata".replaceAll("\\{attachmentId\\}", this.localVarApiClient.escapeString(attachmentId.toString())).replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAttachmentMetaDataValidateBeforeCall(String attachmentId, UUID emailId, ApiCallback _callback) throws ApiException {
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling getAttachmentMetaData(Async)");
        }
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getAttachmentMetaData(Async)");
        }
        Call localVarCall = this.getAttachmentMetaDataCall(attachmentId, emailId, _callback);
        return localVarCall;
    }

    public AttachmentMetaData getAttachmentMetaData(String attachmentId, UUID emailId) throws ApiException {
        ApiResponse<AttachmentMetaData> localVarResp = this.getAttachmentMetaDataWithHttpInfo(attachmentId, emailId);
        return localVarResp.getData();
    }

    public ApiResponse<AttachmentMetaData> getAttachmentMetaDataWithHttpInfo(String attachmentId, UUID emailId) throws ApiException {
        Call localVarCall = this.getAttachmentMetaDataValidateBeforeCall(attachmentId, emailId, null);
        Type localVarReturnType = new TypeToken<AttachmentMetaData>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAttachmentMetaDataAsync(String attachmentId, UUID emailId, ApiCallback<AttachmentMetaData> _callback) throws ApiException {
        Call localVarCall = this.getAttachmentMetaDataValidateBeforeCall(attachmentId, emailId, _callback);
        Type localVarReturnType = new TypeToken<AttachmentMetaData>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getAttachmentsCall(UUID emailId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/{emailId}/attachments".replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAttachmentsValidateBeforeCall(UUID emailId, ApiCallback _callback) throws ApiException {
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getAttachments(Async)");
        }
        Call localVarCall = this.getAttachmentsCall(emailId, _callback);
        return localVarCall;
    }

    public List<AttachmentMetaData> getAttachments(UUID emailId) throws ApiException {
        ApiResponse<List<AttachmentMetaData>> localVarResp = this.getAttachmentsWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    public ApiResponse<List<AttachmentMetaData>> getAttachmentsWithHttpInfo(UUID emailId) throws ApiException {
        Call localVarCall = this.getAttachmentsValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<List<AttachmentMetaData>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAttachmentsAsync(UUID emailId, ApiCallback<List<AttachmentMetaData>> _callback) throws ApiException {
        Call localVarCall = this.getAttachmentsValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<List<AttachmentMetaData>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEmailCall(UUID emailId, Boolean decode, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/{emailId}".replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (decode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("decode", decode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEmailValidateBeforeCall(UUID emailId, Boolean decode, ApiCallback _callback) throws ApiException {
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmail(Async)");
        }
        Call localVarCall = this.getEmailCall(emailId, decode, _callback);
        return localVarCall;
    }

    public Email getEmail(UUID emailId, Boolean decode) throws ApiException {
        ApiResponse<Email> localVarResp = this.getEmailWithHttpInfo(emailId, decode);
        return localVarResp.getData();
    }

    public ApiResponse<Email> getEmailWithHttpInfo(UUID emailId, Boolean decode) throws ApiException {
        Call localVarCall = this.getEmailValidateBeforeCall(emailId, decode, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEmailAsync(UUID emailId, Boolean decode, ApiCallback<Email> _callback) throws ApiException {
        Call localVarCall = this.getEmailValidateBeforeCall(emailId, decode, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEmailContentMatchCall(UUID emailId, ContentMatchOptions contentMatchOptions, ApiCallback _callback) throws ApiException {
        ContentMatchOptions localVarPostBody = contentMatchOptions;
        String localVarPath = "/emails/{emailId}/contentMatch".replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEmailContentMatchValidateBeforeCall(UUID emailId, ContentMatchOptions contentMatchOptions, ApiCallback _callback) throws ApiException {
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailContentMatch(Async)");
        }
        if (contentMatchOptions == null) {
            throw new ApiException("Missing the required parameter 'contentMatchOptions' when calling getEmailContentMatch(Async)");
        }
        Call localVarCall = this.getEmailContentMatchCall(emailId, contentMatchOptions, _callback);
        return localVarCall;
    }

    public EmailContentMatchResult getEmailContentMatch(UUID emailId, ContentMatchOptions contentMatchOptions) throws ApiException {
        ApiResponse<EmailContentMatchResult> localVarResp = this.getEmailContentMatchWithHttpInfo(emailId, contentMatchOptions);
        return localVarResp.getData();
    }

    public ApiResponse<EmailContentMatchResult> getEmailContentMatchWithHttpInfo(UUID emailId, ContentMatchOptions contentMatchOptions) throws ApiException {
        Call localVarCall = this.getEmailContentMatchValidateBeforeCall(emailId, contentMatchOptions, null);
        Type localVarReturnType = new TypeToken<EmailContentMatchResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEmailContentMatchAsync(UUID emailId, ContentMatchOptions contentMatchOptions, ApiCallback<EmailContentMatchResult> _callback) throws ApiException {
        Call localVarCall = this.getEmailContentMatchValidateBeforeCall(emailId, contentMatchOptions, _callback);
        Type localVarReturnType = new TypeToken<EmailContentMatchResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEmailHTMLCall(UUID emailId, Boolean decode, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/{emailId}/html".replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (decode != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("decode", decode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/html"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEmailHTMLValidateBeforeCall(UUID emailId, Boolean decode, ApiCallback _callback) throws ApiException {
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailHTML(Async)");
        }
        Call localVarCall = this.getEmailHTMLCall(emailId, decode, _callback);
        return localVarCall;
    }

    public String getEmailHTML(UUID emailId, Boolean decode) throws ApiException {
        ApiResponse<String> localVarResp = this.getEmailHTMLWithHttpInfo(emailId, decode);
        return localVarResp.getData();
    }

    public ApiResponse<String> getEmailHTMLWithHttpInfo(UUID emailId, Boolean decode) throws ApiException {
        Call localVarCall = this.getEmailHTMLValidateBeforeCall(emailId, decode, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEmailHTMLAsync(UUID emailId, Boolean decode, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getEmailHTMLValidateBeforeCall(emailId, decode, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEmailHTMLQueryCall(UUID emailId, String htmlSelector, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/{emailId}/htmlQuery".replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (htmlSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("htmlSelector", htmlSelector));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEmailHTMLQueryValidateBeforeCall(UUID emailId, String htmlSelector, ApiCallback _callback) throws ApiException {
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailHTMLQuery(Async)");
        }
        Call localVarCall = this.getEmailHTMLQueryCall(emailId, htmlSelector, _callback);
        return localVarCall;
    }

    public EmailTextLinesResult getEmailHTMLQuery(UUID emailId, String htmlSelector) throws ApiException {
        ApiResponse<EmailTextLinesResult> localVarResp = this.getEmailHTMLQueryWithHttpInfo(emailId, htmlSelector);
        return localVarResp.getData();
    }

    public ApiResponse<EmailTextLinesResult> getEmailHTMLQueryWithHttpInfo(UUID emailId, String htmlSelector) throws ApiException {
        Call localVarCall = this.getEmailHTMLQueryValidateBeforeCall(emailId, htmlSelector, null);
        Type localVarReturnType = new TypeToken<EmailTextLinesResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEmailHTMLQueryAsync(UUID emailId, String htmlSelector, ApiCallback<EmailTextLinesResult> _callback) throws ApiException {
        Call localVarCall = this.getEmailHTMLQueryValidateBeforeCall(emailId, htmlSelector, _callback);
        Type localVarReturnType = new TypeToken<EmailTextLinesResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEmailTextLinesCall(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/{emailId}/textLines".replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (decodeHtmlEntities != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("decodeHtmlEntities", decodeHtmlEntities));
        }
        if (lineSeparator != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("lineSeparator", lineSeparator));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEmailTextLinesValidateBeforeCall(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator, ApiCallback _callback) throws ApiException {
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getEmailTextLines(Async)");
        }
        Call localVarCall = this.getEmailTextLinesCall(emailId, decodeHtmlEntities, lineSeparator, _callback);
        return localVarCall;
    }

    public EmailTextLinesResult getEmailTextLines(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator) throws ApiException {
        ApiResponse<EmailTextLinesResult> localVarResp = this.getEmailTextLinesWithHttpInfo(emailId, decodeHtmlEntities, lineSeparator);
        return localVarResp.getData();
    }

    public ApiResponse<EmailTextLinesResult> getEmailTextLinesWithHttpInfo(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator) throws ApiException {
        Call localVarCall = this.getEmailTextLinesValidateBeforeCall(emailId, decodeHtmlEntities, lineSeparator, null);
        Type localVarReturnType = new TypeToken<EmailTextLinesResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEmailTextLinesAsync(UUID emailId, Boolean decodeHtmlEntities, String lineSeparator, ApiCallback<EmailTextLinesResult> _callback) throws ApiException {
        Call localVarCall = this.getEmailTextLinesValidateBeforeCall(emailId, decodeHtmlEntities, lineSeparator, _callback);
        Type localVarReturnType = new TypeToken<EmailTextLinesResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEmailsPaginatedCall(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "inboxId", inboxId));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (unreadOnly != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEmailsPaginatedValidateBeforeCall(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getEmailsPaginatedCall(inboxId, page, size, sort, unreadOnly, _callback);
        return localVarCall;
    }

    public PageEmailProjection getEmailsPaginated(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly) throws ApiException {
        ApiResponse<PageEmailProjection> localVarResp = this.getEmailsPaginatedWithHttpInfo(inboxId, page, size, sort, unreadOnly);
        return localVarResp.getData();
    }

    public ApiResponse<PageEmailProjection> getEmailsPaginatedWithHttpInfo(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly) throws ApiException {
        Call localVarCall = this.getEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, unreadOnly, null);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEmailsPaginatedAsync(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, ApiCallback<PageEmailProjection> _callback) throws ApiException {
        Call localVarCall = this.getEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, unreadOnly, _callback);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLatestEmailCall(List<UUID> inboxIds, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/latest";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxIds != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "inboxIds", inboxIds));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLatestEmailValidateBeforeCall(List<UUID> inboxIds, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getLatestEmailCall(inboxIds, _callback);
        return localVarCall;
    }

    public Email getLatestEmail(List<UUID> inboxIds) throws ApiException {
        ApiResponse<Email> localVarResp = this.getLatestEmailWithHttpInfo(inboxIds);
        return localVarResp.getData();
    }

    public ApiResponse<Email> getLatestEmailWithHttpInfo(List<UUID> inboxIds) throws ApiException {
        Call localVarCall = this.getLatestEmailValidateBeforeCall(inboxIds, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLatestEmailAsync(List<UUID> inboxIds, ApiCallback<Email> _callback) throws ApiException {
        Call localVarCall = this.getLatestEmailValidateBeforeCall(inboxIds, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getLatestEmailInInboxCall(UUID inboxId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/latestIn";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("inboxId", inboxId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getLatestEmailInInboxValidateBeforeCall(UUID inboxId, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getLatestEmailInInboxCall(inboxId, _callback);
        return localVarCall;
    }

    public Email getLatestEmailInInbox(UUID inboxId) throws ApiException {
        ApiResponse<Email> localVarResp = this.getLatestEmailInInboxWithHttpInfo(inboxId);
        return localVarResp.getData();
    }

    public ApiResponse<Email> getLatestEmailInInboxWithHttpInfo(UUID inboxId) throws ApiException {
        Call localVarCall = this.getLatestEmailInInboxValidateBeforeCall(inboxId, null);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getLatestEmailInInboxAsync(UUID inboxId, ApiCallback<Email> _callback) throws ApiException {
        Call localVarCall = this.getLatestEmailInInboxValidateBeforeCall(inboxId, _callback);
        Type localVarReturnType = new TypeToken<Email>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOrganizationEmailsPaginatedCall(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/organization";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (inboxId != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "inboxId", inboxId));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (unreadOnly != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("unreadOnly", unreadOnly));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrganizationEmailsPaginatedValidateBeforeCall(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getOrganizationEmailsPaginatedCall(inboxId, page, size, sort, unreadOnly, _callback);
        return localVarCall;
    }

    public PageEmailProjection getOrganizationEmailsPaginated(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly) throws ApiException {
        ApiResponse<PageEmailProjection> localVarResp = this.getOrganizationEmailsPaginatedWithHttpInfo(inboxId, page, size, sort, unreadOnly);
        return localVarResp.getData();
    }

    public ApiResponse<PageEmailProjection> getOrganizationEmailsPaginatedWithHttpInfo(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly) throws ApiException {
        Call localVarCall = this.getOrganizationEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, unreadOnly, null);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOrganizationEmailsPaginatedAsync(List<UUID> inboxId, Integer page, Integer size, String sort, Boolean unreadOnly, ApiCallback<PageEmailProjection> _callback) throws ApiException {
        Call localVarCall = this.getOrganizationEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, unreadOnly, _callback);
        Type localVarReturnType = new TypeToken<PageEmailProjection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRawEmailContentsCall(UUID emailId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/{emailId}/raw".replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRawEmailContentsValidateBeforeCall(UUID emailId, ApiCallback _callback) throws ApiException {
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getRawEmailContents(Async)");
        }
        Call localVarCall = this.getRawEmailContentsCall(emailId, _callback);
        return localVarCall;
    }

    public String getRawEmailContents(UUID emailId) throws ApiException {
        ApiResponse<String> localVarResp = this.getRawEmailContentsWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    public ApiResponse<String> getRawEmailContentsWithHttpInfo(UUID emailId) throws ApiException {
        Call localVarCall = this.getRawEmailContentsValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRawEmailContentsAsync(UUID emailId, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.getRawEmailContentsValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getRawEmailJsonCall(UUID emailId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/{emailId}/raw/json".replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getRawEmailJsonValidateBeforeCall(UUID emailId, ApiCallback _callback) throws ApiException {
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling getRawEmailJson(Async)");
        }
        Call localVarCall = this.getRawEmailJsonCall(emailId, _callback);
        return localVarCall;
    }

    public RawEmailJson getRawEmailJson(UUID emailId) throws ApiException {
        ApiResponse<RawEmailJson> localVarResp = this.getRawEmailJsonWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    public ApiResponse<RawEmailJson> getRawEmailJsonWithHttpInfo(UUID emailId) throws ApiException {
        Call localVarCall = this.getRawEmailJsonValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<RawEmailJson>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getRawEmailJsonAsync(UUID emailId, ApiCallback<RawEmailJson> _callback) throws ApiException {
        Call localVarCall = this.getRawEmailJsonValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<RawEmailJson>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUnreadEmailCountCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/unreadCount";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUnreadEmailCountValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getUnreadEmailCountCall(_callback);
        return localVarCall;
    }

    public UnreadCount getUnreadEmailCount() throws ApiException {
        ApiResponse<UnreadCount> localVarResp = this.getUnreadEmailCountWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<UnreadCount> getUnreadEmailCountWithHttpInfo() throws ApiException {
        Call localVarCall = this.getUnreadEmailCountValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<UnreadCount>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUnreadEmailCountAsync(ApiCallback<UnreadCount> _callback) throws ApiException {
        Call localVarCall = this.getUnreadEmailCountValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<UnreadCount>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call replyToEmailCall(UUID emailId, ReplyToEmailOptions replyToEmailOptions, ApiCallback _callback) throws ApiException {
        ReplyToEmailOptions localVarPostBody = replyToEmailOptions;
        String localVarPath = "/emails/{emailId}".replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replyToEmailValidateBeforeCall(UUID emailId, ReplyToEmailOptions replyToEmailOptions, ApiCallback _callback) throws ApiException {
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling replyToEmail(Async)");
        }
        if (replyToEmailOptions == null) {
            throw new ApiException("Missing the required parameter 'replyToEmailOptions' when calling replyToEmail(Async)");
        }
        Call localVarCall = this.replyToEmailCall(emailId, replyToEmailOptions, _callback);
        return localVarCall;
    }

    public SentEmailDto replyToEmail(UUID emailId, ReplyToEmailOptions replyToEmailOptions) throws ApiException {
        ApiResponse<SentEmailDto> localVarResp = this.replyToEmailWithHttpInfo(emailId, replyToEmailOptions);
        return localVarResp.getData();
    }

    public ApiResponse<SentEmailDto> replyToEmailWithHttpInfo(UUID emailId, ReplyToEmailOptions replyToEmailOptions) throws ApiException {
        Call localVarCall = this.replyToEmailValidateBeforeCall(emailId, replyToEmailOptions, null);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call replyToEmailAsync(UUID emailId, ReplyToEmailOptions replyToEmailOptions, ApiCallback<SentEmailDto> _callback) throws ApiException {
        Call localVarCall = this.replyToEmailValidateBeforeCall(emailId, replyToEmailOptions, _callback);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call validateEmailCall(UUID emailId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/emails/{emailId}/validate".replaceAll("\\{emailId\\}", this.localVarApiClient.escapeString(emailId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call validateEmailValidateBeforeCall(UUID emailId, ApiCallback _callback) throws ApiException {
        if (emailId == null) {
            throw new ApiException("Missing the required parameter 'emailId' when calling validateEmail(Async)");
        }
        Call localVarCall = this.validateEmailCall(emailId, _callback);
        return localVarCall;
    }

    public ValidationDto validateEmail(UUID emailId) throws ApiException {
        ApiResponse<ValidationDto> localVarResp = this.validateEmailWithHttpInfo(emailId);
        return localVarResp.getData();
    }

    public ApiResponse<ValidationDto> validateEmailWithHttpInfo(UUID emailId) throws ApiException {
        Call localVarCall = this.validateEmailValidateBeforeCall(emailId, null);
        Type localVarReturnType = new TypeToken<ValidationDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call validateEmailAsync(UUID emailId, ApiCallback<ValidationDto> _callback) throws ApiException {
        Call localVarCall = this.validateEmailValidateBeforeCall(emailId, _callback);
        Type localVarReturnType = new TypeToken<ValidationDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

