/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.apis;

import com.google.gson.reflect.TypeToken;
import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.models.ExpirationDefaults;
import com.mailslurp.models.ExpiredInboxDto;
import com.mailslurp.models.PageExpiredInboxRecordProjection;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import okhttp3.Call;

public class ExpiredControllerApi {
    private ApiClient localVarApiClient;

    public ExpiredControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ExpiredControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getExpirationDefaultsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/expired/defaults";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExpirationDefaultsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getExpirationDefaultsCall(_callback);
        return localVarCall;
    }

    public ExpirationDefaults getExpirationDefaults() throws ApiException {
        ApiResponse<ExpirationDefaults> localVarResp = this.getExpirationDefaultsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<ExpirationDefaults> getExpirationDefaultsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getExpirationDefaultsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ExpirationDefaults>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExpirationDefaultsAsync(ApiCallback<ExpirationDefaults> _callback) throws ApiException {
        Call localVarCall = this.getExpirationDefaultsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ExpirationDefaults>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExpiredInboxByInboxIdCall(UUID inboxId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/expired/inbox/{inboxId}".replaceAll("\\{inboxId\\}", this.localVarApiClient.escapeString(inboxId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExpiredInboxByInboxIdValidateBeforeCall(UUID inboxId, ApiCallback _callback) throws ApiException {
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getExpiredInboxByInboxId(Async)");
        }
        Call localVarCall = this.getExpiredInboxByInboxIdCall(inboxId, _callback);
        return localVarCall;
    }

    public ExpiredInboxDto getExpiredInboxByInboxId(UUID inboxId) throws ApiException {
        ApiResponse<ExpiredInboxDto> localVarResp = this.getExpiredInboxByInboxIdWithHttpInfo(inboxId);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiredInboxDto> getExpiredInboxByInboxIdWithHttpInfo(UUID inboxId) throws ApiException {
        Call localVarCall = this.getExpiredInboxByInboxIdValidateBeforeCall(inboxId, null);
        Type localVarReturnType = new TypeToken<ExpiredInboxDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExpiredInboxByInboxIdAsync(UUID inboxId, ApiCallback<ExpiredInboxDto> _callback) throws ApiException {
        Call localVarCall = this.getExpiredInboxByInboxIdValidateBeforeCall(inboxId, _callback);
        Type localVarReturnType = new TypeToken<ExpiredInboxDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExpiredInboxRecordCall(UUID expiredId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/expired/{expiredId}".replaceAll("\\{expiredId\\}", this.localVarApiClient.escapeString(expiredId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExpiredInboxRecordValidateBeforeCall(UUID expiredId, ApiCallback _callback) throws ApiException {
        if (expiredId == null) {
            throw new ApiException("Missing the required parameter 'expiredId' when calling getExpiredInboxRecord(Async)");
        }
        Call localVarCall = this.getExpiredInboxRecordCall(expiredId, _callback);
        return localVarCall;
    }

    public ExpiredInboxDto getExpiredInboxRecord(UUID expiredId) throws ApiException {
        ApiResponse<ExpiredInboxDto> localVarResp = this.getExpiredInboxRecordWithHttpInfo(expiredId);
        return localVarResp.getData();
    }

    public ApiResponse<ExpiredInboxDto> getExpiredInboxRecordWithHttpInfo(UUID expiredId) throws ApiException {
        Call localVarCall = this.getExpiredInboxRecordValidateBeforeCall(expiredId, null);
        Type localVarReturnType = new TypeToken<ExpiredInboxDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExpiredInboxRecordAsync(UUID expiredId, ApiCallback<ExpiredInboxDto> _callback) throws ApiException {
        Call localVarCall = this.getExpiredInboxRecordValidateBeforeCall(expiredId, _callback);
        Type localVarReturnType = new TypeToken<ExpiredInboxDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getExpiredInboxesCall(Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/expired";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getExpiredInboxesValidateBeforeCall(Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getExpiredInboxesCall(page, size, sort, _callback);
        return localVarCall;
    }

    public PageExpiredInboxRecordProjection getExpiredInboxes(Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageExpiredInboxRecordProjection> localVarResp = this.getExpiredInboxesWithHttpInfo(page, size, sort);
        return localVarResp.getData();
    }

    public ApiResponse<PageExpiredInboxRecordProjection> getExpiredInboxesWithHttpInfo(Integer page, Integer size, String sort) throws ApiException {
        Call localVarCall = this.getExpiredInboxesValidateBeforeCall(page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageExpiredInboxRecordProjection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getExpiredInboxesAsync(Integer page, Integer size, String sort, ApiCallback<PageExpiredInboxRecordProjection> _callback) throws ApiException {
        Call localVarCall = this.getExpiredInboxesValidateBeforeCall(page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageExpiredInboxRecordProjection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

