/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.apis;

import com.google.gson.reflect.TypeToken;
import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.models.CreateGroupOptions;
import com.mailslurp.models.GroupContactsDto;
import com.mailslurp.models.GroupDto;
import com.mailslurp.models.GroupProjection;
import com.mailslurp.models.PageContactProjection;
import com.mailslurp.models.PageGroupProjection;
import com.mailslurp.models.UpdateGroupContacts;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.Call;

public class GroupControllerApi {
    private ApiClient localVarApiClient;

    public GroupControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GroupControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call addContactsToGroupCall(UUID groupId, UpdateGroupContacts updateGroupContactsOption, ApiCallback _callback) throws ApiException {
        UpdateGroupContacts localVarPostBody = updateGroupContactsOption;
        String localVarPath = "/groups/{groupId}/contacts".replaceAll("\\{groupId\\}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call addContactsToGroupValidateBeforeCall(UUID groupId, UpdateGroupContacts updateGroupContactsOption, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling addContactsToGroup(Async)");
        }
        if (updateGroupContactsOption == null) {
            throw new ApiException("Missing the required parameter 'updateGroupContactsOption' when calling addContactsToGroup(Async)");
        }
        Call localVarCall = this.addContactsToGroupCall(groupId, updateGroupContactsOption, _callback);
        return localVarCall;
    }

    public GroupContactsDto addContactsToGroup(UUID groupId, UpdateGroupContacts updateGroupContactsOption) throws ApiException {
        ApiResponse<GroupContactsDto> localVarResp = this.addContactsToGroupWithHttpInfo(groupId, updateGroupContactsOption);
        return localVarResp.getData();
    }

    public ApiResponse<GroupContactsDto> addContactsToGroupWithHttpInfo(UUID groupId, UpdateGroupContacts updateGroupContactsOption) throws ApiException {
        Call localVarCall = this.addContactsToGroupValidateBeforeCall(groupId, updateGroupContactsOption, null);
        Type localVarReturnType = new TypeToken<GroupContactsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call addContactsToGroupAsync(UUID groupId, UpdateGroupContacts updateGroupContactsOption, ApiCallback<GroupContactsDto> _callback) throws ApiException {
        Call localVarCall = this.addContactsToGroupValidateBeforeCall(groupId, updateGroupContactsOption, _callback);
        Type localVarReturnType = new TypeToken<GroupContactsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createGroupCall(CreateGroupOptions createGroupOptions, ApiCallback _callback) throws ApiException {
        CreateGroupOptions localVarPostBody = createGroupOptions;
        String localVarPath = "/groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createGroupValidateBeforeCall(CreateGroupOptions createGroupOptions, ApiCallback _callback) throws ApiException {
        if (createGroupOptions == null) {
            throw new ApiException("Missing the required parameter 'createGroupOptions' when calling createGroup(Async)");
        }
        Call localVarCall = this.createGroupCall(createGroupOptions, _callback);
        return localVarCall;
    }

    public GroupDto createGroup(CreateGroupOptions createGroupOptions) throws ApiException {
        ApiResponse<GroupDto> localVarResp = this.createGroupWithHttpInfo(createGroupOptions);
        return localVarResp.getData();
    }

    public ApiResponse<GroupDto> createGroupWithHttpInfo(CreateGroupOptions createGroupOptions) throws ApiException {
        Call localVarCall = this.createGroupValidateBeforeCall(createGroupOptions, null);
        Type localVarReturnType = new TypeToken<GroupDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createGroupAsync(CreateGroupOptions createGroupOptions, ApiCallback<GroupDto> _callback) throws ApiException {
        Call localVarCall = this.createGroupValidateBeforeCall(createGroupOptions, _callback);
        Type localVarReturnType = new TypeToken<GroupDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteGroupCall(UUID groupId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/groups/{groupId}".replaceAll("\\{groupId\\}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteGroupValidateBeforeCall(UUID groupId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling deleteGroup(Async)");
        }
        Call localVarCall = this.deleteGroupCall(groupId, _callback);
        return localVarCall;
    }

    public void deleteGroup(UUID groupId) throws ApiException {
        this.deleteGroupWithHttpInfo(groupId);
    }

    public ApiResponse<Void> deleteGroupWithHttpInfo(UUID groupId) throws ApiException {
        Call localVarCall = this.deleteGroupValidateBeforeCall(groupId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteGroupAsync(UUID groupId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteGroupValidateBeforeCall(groupId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAllGroupsCall(Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/groups/paginated";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllGroupsValidateBeforeCall(Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAllGroupsCall(page, size, sort, _callback);
        return localVarCall;
    }

    public PageGroupProjection getAllGroups(Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageGroupProjection> localVarResp = this.getAllGroupsWithHttpInfo(page, size, sort);
        return localVarResp.getData();
    }

    public ApiResponse<PageGroupProjection> getAllGroupsWithHttpInfo(Integer page, Integer size, String sort) throws ApiException {
        Call localVarCall = this.getAllGroupsValidateBeforeCall(page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageGroupProjection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllGroupsAsync(Integer page, Integer size, String sort, ApiCallback<PageGroupProjection> _callback) throws ApiException {
        Call localVarCall = this.getAllGroupsValidateBeforeCall(page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageGroupProjection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getGroupCall(UUID groupId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/groups/{groupId}".replaceAll("\\{groupId\\}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupValidateBeforeCall(UUID groupId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling getGroup(Async)");
        }
        Call localVarCall = this.getGroupCall(groupId, _callback);
        return localVarCall;
    }

    public GroupDto getGroup(UUID groupId) throws ApiException {
        ApiResponse<GroupDto> localVarResp = this.getGroupWithHttpInfo(groupId);
        return localVarResp.getData();
    }

    public ApiResponse<GroupDto> getGroupWithHttpInfo(UUID groupId) throws ApiException {
        Call localVarCall = this.getGroupValidateBeforeCall(groupId, null);
        Type localVarReturnType = new TypeToken<GroupDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGroupAsync(UUID groupId, ApiCallback<GroupDto> _callback) throws ApiException {
        Call localVarCall = this.getGroupValidateBeforeCall(groupId, _callback);
        Type localVarReturnType = new TypeToken<GroupDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getGroupWithContactsCall(UUID groupId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/groups/{groupId}/contacts".replaceAll("\\{groupId\\}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupWithContactsValidateBeforeCall(UUID groupId, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling getGroupWithContacts(Async)");
        }
        Call localVarCall = this.getGroupWithContactsCall(groupId, _callback);
        return localVarCall;
    }

    public GroupContactsDto getGroupWithContacts(UUID groupId) throws ApiException {
        ApiResponse<GroupContactsDto> localVarResp = this.getGroupWithContactsWithHttpInfo(groupId);
        return localVarResp.getData();
    }

    public ApiResponse<GroupContactsDto> getGroupWithContactsWithHttpInfo(UUID groupId) throws ApiException {
        Call localVarCall = this.getGroupWithContactsValidateBeforeCall(groupId, null);
        Type localVarReturnType = new TypeToken<GroupContactsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGroupWithContactsAsync(UUID groupId, ApiCallback<GroupContactsDto> _callback) throws ApiException {
        Call localVarCall = this.getGroupWithContactsValidateBeforeCall(groupId, _callback);
        Type localVarReturnType = new TypeToken<GroupContactsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getGroupWithContactsPaginatedCall(UUID groupId, Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/groups/{groupId}/contacts-paginated".replaceAll("\\{groupId\\}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupWithContactsPaginatedValidateBeforeCall(UUID groupId, Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling getGroupWithContactsPaginated(Async)");
        }
        Call localVarCall = this.getGroupWithContactsPaginatedCall(groupId, page, size, sort, _callback);
        return localVarCall;
    }

    public PageContactProjection getGroupWithContactsPaginated(UUID groupId, Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageContactProjection> localVarResp = this.getGroupWithContactsPaginatedWithHttpInfo(groupId, page, size, sort);
        return localVarResp.getData();
    }

    public ApiResponse<PageContactProjection> getGroupWithContactsPaginatedWithHttpInfo(UUID groupId, Integer page, Integer size, String sort) throws ApiException {
        Call localVarCall = this.getGroupWithContactsPaginatedValidateBeforeCall(groupId, page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageContactProjection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGroupWithContactsPaginatedAsync(UUID groupId, Integer page, Integer size, String sort, ApiCallback<PageContactProjection> _callback) throws ApiException {
        Call localVarCall = this.getGroupWithContactsPaginatedValidateBeforeCall(groupId, page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageContactProjection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getGroupsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getGroupsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getGroupsCall(_callback);
        return localVarCall;
    }

    public List<GroupProjection> getGroups() throws ApiException {
        ApiResponse<List<GroupProjection>> localVarResp = this.getGroupsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<GroupProjection>> getGroupsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getGroupsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<GroupProjection>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getGroupsAsync(ApiCallback<List<GroupProjection>> _callback) throws ApiException {
        Call localVarCall = this.getGroupsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<GroupProjection>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call removeContactsFromGroupCall(UUID groupId, UpdateGroupContacts updateGroupContactsOption, ApiCallback _callback) throws ApiException {
        UpdateGroupContacts localVarPostBody = updateGroupContactsOption;
        String localVarPath = "/groups/{groupId}/contacts".replaceAll("\\{groupId\\}", this.localVarApiClient.escapeString(groupId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call removeContactsFromGroupValidateBeforeCall(UUID groupId, UpdateGroupContacts updateGroupContactsOption, ApiCallback _callback) throws ApiException {
        if (groupId == null) {
            throw new ApiException("Missing the required parameter 'groupId' when calling removeContactsFromGroup(Async)");
        }
        if (updateGroupContactsOption == null) {
            throw new ApiException("Missing the required parameter 'updateGroupContactsOption' when calling removeContactsFromGroup(Async)");
        }
        Call localVarCall = this.removeContactsFromGroupCall(groupId, updateGroupContactsOption, _callback);
        return localVarCall;
    }

    public GroupContactsDto removeContactsFromGroup(UUID groupId, UpdateGroupContacts updateGroupContactsOption) throws ApiException {
        ApiResponse<GroupContactsDto> localVarResp = this.removeContactsFromGroupWithHttpInfo(groupId, updateGroupContactsOption);
        return localVarResp.getData();
    }

    public ApiResponse<GroupContactsDto> removeContactsFromGroupWithHttpInfo(UUID groupId, UpdateGroupContacts updateGroupContactsOption) throws ApiException {
        Call localVarCall = this.removeContactsFromGroupValidateBeforeCall(groupId, updateGroupContactsOption, null);
        Type localVarReturnType = new TypeToken<GroupContactsDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call removeContactsFromGroupAsync(UUID groupId, UpdateGroupContacts updateGroupContactsOption, ApiCallback<GroupContactsDto> _callback) throws ApiException {
        Call localVarCall = this.removeContactsFromGroupValidateBeforeCall(groupId, updateGroupContactsOption, _callback);
        Type localVarReturnType = new TypeToken<GroupContactsDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

