/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.apis;

import com.google.gson.reflect.TypeToken;
import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.models.CreateInboxDto;
import com.mailslurp.models.EmailPreview;
import com.mailslurp.models.Inbox;
import com.mailslurp.models.PageEmailPreview;
import com.mailslurp.models.PageInboxProjection;
import com.mailslurp.models.PageOrganizationInboxProjection;
import com.mailslurp.models.PageSentEmailProjection;
import com.mailslurp.models.SendEmailOptions;
import com.mailslurp.models.SentEmailDto;
import com.mailslurp.models.SetInboxFavouritedOptions;
import com.mailslurp.models.UpdateInboxOptions;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.Call;

public class InboxControllerApi {
    private ApiClient localVarApiClient;

    public InboxControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public InboxControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createInboxCall(Boolean allowTeamAccess, String description, String emailAddress, OffsetDateTime expiresAt, Long expiresIn, Boolean favourite, String name, List<String> tags, Boolean useDomainPool, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inboxes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (allowTeamAccess != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowTeamAccess", allowTeamAccess));
        }
        if (description != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("description", description));
        }
        if (emailAddress != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("emailAddress", emailAddress));
        }
        if (expiresAt != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expiresAt", expiresAt));
        }
        if (expiresIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expiresIn", expiresIn));
        }
        if (favourite != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("favourite", favourite));
        }
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (tags != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "tags", tags));
        }
        if (useDomainPool != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("useDomainPool", useDomainPool));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createInboxValidateBeforeCall(Boolean allowTeamAccess, String description, String emailAddress, OffsetDateTime expiresAt, Long expiresIn, Boolean favourite, String name, List<String> tags, Boolean useDomainPool, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.createInboxCall(allowTeamAccess, description, emailAddress, expiresAt, expiresIn, favourite, name, tags, useDomainPool, _callback);
        return localVarCall;
    }

    public Inbox createInbox(Boolean allowTeamAccess, String description, String emailAddress, OffsetDateTime expiresAt, Long expiresIn, Boolean favourite, String name, List<String> tags, Boolean useDomainPool) throws ApiException {
        ApiResponse<Inbox> localVarResp = this.createInboxWithHttpInfo(allowTeamAccess, description, emailAddress, expiresAt, expiresIn, favourite, name, tags, useDomainPool);
        return localVarResp.getData();
    }

    public ApiResponse<Inbox> createInboxWithHttpInfo(Boolean allowTeamAccess, String description, String emailAddress, OffsetDateTime expiresAt, Long expiresIn, Boolean favourite, String name, List<String> tags, Boolean useDomainPool) throws ApiException {
        Call localVarCall = this.createInboxValidateBeforeCall(allowTeamAccess, description, emailAddress, expiresAt, expiresIn, favourite, name, tags, useDomainPool, null);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createInboxAsync(Boolean allowTeamAccess, String description, String emailAddress, OffsetDateTime expiresAt, Long expiresIn, Boolean favourite, String name, List<String> tags, Boolean useDomainPool, ApiCallback<Inbox> _callback) throws ApiException {
        Call localVarCall = this.createInboxValidateBeforeCall(allowTeamAccess, description, emailAddress, expiresAt, expiresIn, favourite, name, tags, useDomainPool, _callback);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createInboxWithOptionsCall(CreateInboxDto createInboxDto, ApiCallback _callback) throws ApiException {
        CreateInboxDto localVarPostBody = createInboxDto;
        String localVarPath = "/inboxes/withOptions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createInboxWithOptionsValidateBeforeCall(CreateInboxDto createInboxDto, ApiCallback _callback) throws ApiException {
        if (createInboxDto == null) {
            throw new ApiException("Missing the required parameter 'createInboxDto' when calling createInboxWithOptions(Async)");
        }
        Call localVarCall = this.createInboxWithOptionsCall(createInboxDto, _callback);
        return localVarCall;
    }

    public Inbox createInboxWithOptions(CreateInboxDto createInboxDto) throws ApiException {
        ApiResponse<Inbox> localVarResp = this.createInboxWithOptionsWithHttpInfo(createInboxDto);
        return localVarResp.getData();
    }

    public ApiResponse<Inbox> createInboxWithOptionsWithHttpInfo(CreateInboxDto createInboxDto) throws ApiException {
        Call localVarCall = this.createInboxWithOptionsValidateBeforeCall(createInboxDto, null);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createInboxWithOptionsAsync(CreateInboxDto createInboxDto, ApiCallback<Inbox> _callback) throws ApiException {
        Call localVarCall = this.createInboxWithOptionsValidateBeforeCall(createInboxDto, _callback);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAllInboxesCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inboxes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAllInboxesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.deleteAllInboxesCall(_callback);
        return localVarCall;
    }

    public void deleteAllInboxes() throws ApiException {
        this.deleteAllInboxesWithHttpInfo();
    }

    public ApiResponse<Void> deleteAllInboxesWithHttpInfo() throws ApiException {
        Call localVarCall = this.deleteAllInboxesValidateBeforeCall(null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteAllInboxesAsync(ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteAllInboxesValidateBeforeCall(_callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteInboxCall(UUID inboxId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inboxes/{inboxId}".replaceAll("\\{inboxId\\}", this.localVarApiClient.escapeString(inboxId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteInboxValidateBeforeCall(UUID inboxId, ApiCallback _callback) throws ApiException {
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling deleteInbox(Async)");
        }
        Call localVarCall = this.deleteInboxCall(inboxId, _callback);
        return localVarCall;
    }

    public void deleteInbox(UUID inboxId) throws ApiException {
        this.deleteInboxWithHttpInfo(inboxId);
    }

    public ApiResponse<Void> deleteInboxWithHttpInfo(UUID inboxId) throws ApiException {
        Call localVarCall = this.deleteInboxValidateBeforeCall(inboxId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteInboxAsync(UUID inboxId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteInboxValidateBeforeCall(inboxId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAllInboxesCall(Boolean favourite, Integer page, String search, Integer size, String sort, String tag, Boolean teamAccess, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inboxes/paginated";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (favourite != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("favourite", favourite));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (search != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("search", search));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        if (tag != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tag", tag));
        }
        if (teamAccess != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("teamAccess", teamAccess));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllInboxesValidateBeforeCall(Boolean favourite, Integer page, String search, Integer size, String sort, String tag, Boolean teamAccess, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAllInboxesCall(favourite, page, search, size, sort, tag, teamAccess, _callback);
        return localVarCall;
    }

    public PageInboxProjection getAllInboxes(Boolean favourite, Integer page, String search, Integer size, String sort, String tag, Boolean teamAccess) throws ApiException {
        ApiResponse<PageInboxProjection> localVarResp = this.getAllInboxesWithHttpInfo(favourite, page, search, size, sort, tag, teamAccess);
        return localVarResp.getData();
    }

    public ApiResponse<PageInboxProjection> getAllInboxesWithHttpInfo(Boolean favourite, Integer page, String search, Integer size, String sort, String tag, Boolean teamAccess) throws ApiException {
        Call localVarCall = this.getAllInboxesValidateBeforeCall(favourite, page, search, size, sort, tag, teamAccess, null);
        Type localVarReturnType = new TypeToken<PageInboxProjection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllInboxesAsync(Boolean favourite, Integer page, String search, Integer size, String sort, String tag, Boolean teamAccess, ApiCallback<PageInboxProjection> _callback) throws ApiException {
        Call localVarCall = this.getAllInboxesValidateBeforeCall(favourite, page, search, size, sort, tag, teamAccess, _callback);
        Type localVarReturnType = new TypeToken<PageInboxProjection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getEmailsCall(UUID inboxId, Integer limit, Long minCount, Long retryTimeout, OffsetDateTime since, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inboxes/{inboxId}/emails".replaceAll("\\{inboxId\\}", this.localVarApiClient.escapeString(inboxId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (minCount != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("minCount", minCount));
        }
        if (retryTimeout != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("retryTimeout", retryTimeout));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since", since));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getEmailsValidateBeforeCall(UUID inboxId, Integer limit, Long minCount, Long retryTimeout, OffsetDateTime since, Integer size, String sort, ApiCallback _callback) throws ApiException {
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getEmails(Async)");
        }
        Call localVarCall = this.getEmailsCall(inboxId, limit, minCount, retryTimeout, since, size, sort, _callback);
        return localVarCall;
    }

    public List<EmailPreview> getEmails(UUID inboxId, Integer limit, Long minCount, Long retryTimeout, OffsetDateTime since, Integer size, String sort) throws ApiException {
        ApiResponse<List<EmailPreview>> localVarResp = this.getEmailsWithHttpInfo(inboxId, limit, minCount, retryTimeout, since, size, sort);
        return localVarResp.getData();
    }

    public ApiResponse<List<EmailPreview>> getEmailsWithHttpInfo(UUID inboxId, Integer limit, Long minCount, Long retryTimeout, OffsetDateTime since, Integer size, String sort) throws ApiException {
        Call localVarCall = this.getEmailsValidateBeforeCall(inboxId, limit, minCount, retryTimeout, since, size, sort, null);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getEmailsAsync(UUID inboxId, Integer limit, Long minCount, Long retryTimeout, OffsetDateTime since, Integer size, String sort, ApiCallback<List<EmailPreview>> _callback) throws ApiException {
        Call localVarCall = this.getEmailsValidateBeforeCall(inboxId, limit, minCount, retryTimeout, since, size, sort, _callback);
        Type localVarReturnType = new TypeToken<List<EmailPreview>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getInboxCall(UUID inboxId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inboxes/{inboxId}".replaceAll("\\{inboxId\\}", this.localVarApiClient.escapeString(inboxId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInboxValidateBeforeCall(UUID inboxId, ApiCallback _callback) throws ApiException {
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getInbox(Async)");
        }
        Call localVarCall = this.getInboxCall(inboxId, _callback);
        return localVarCall;
    }

    public Inbox getInbox(UUID inboxId) throws ApiException {
        ApiResponse<Inbox> localVarResp = this.getInboxWithHttpInfo(inboxId);
        return localVarResp.getData();
    }

    public ApiResponse<Inbox> getInboxWithHttpInfo(UUID inboxId) throws ApiException {
        Call localVarCall = this.getInboxValidateBeforeCall(inboxId, null);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getInboxAsync(UUID inboxId, ApiCallback<Inbox> _callback) throws ApiException {
        Call localVarCall = this.getInboxValidateBeforeCall(inboxId, _callback);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getInboxEmailsPaginatedCall(UUID inboxId, Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inboxes/{inboxId}/emails/paginated".replaceAll("\\{inboxId\\}", this.localVarApiClient.escapeString(inboxId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInboxEmailsPaginatedValidateBeforeCall(UUID inboxId, Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getInboxEmailsPaginated(Async)");
        }
        Call localVarCall = this.getInboxEmailsPaginatedCall(inboxId, page, size, sort, _callback);
        return localVarCall;
    }

    public PageEmailPreview getInboxEmailsPaginated(UUID inboxId, Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageEmailPreview> localVarResp = this.getInboxEmailsPaginatedWithHttpInfo(inboxId, page, size, sort);
        return localVarResp.getData();
    }

    public ApiResponse<PageEmailPreview> getInboxEmailsPaginatedWithHttpInfo(UUID inboxId, Integer page, Integer size, String sort) throws ApiException {
        Call localVarCall = this.getInboxEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageEmailPreview>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getInboxEmailsPaginatedAsync(UUID inboxId, Integer page, Integer size, String sort, ApiCallback<PageEmailPreview> _callback) throws ApiException {
        Call localVarCall = this.getInboxEmailsPaginatedValidateBeforeCall(inboxId, page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageEmailPreview>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getInboxSentEmailsCall(UUID inboxId, Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inboxes/{inboxId}/sent".replaceAll("\\{inboxId\\}", this.localVarApiClient.escapeString(inboxId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInboxSentEmailsValidateBeforeCall(UUID inboxId, Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getInboxSentEmails(Async)");
        }
        Call localVarCall = this.getInboxSentEmailsCall(inboxId, page, size, sort, _callback);
        return localVarCall;
    }

    public PageSentEmailProjection getInboxSentEmails(UUID inboxId, Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageSentEmailProjection> localVarResp = this.getInboxSentEmailsWithHttpInfo(inboxId, page, size, sort);
        return localVarResp.getData();
    }

    public ApiResponse<PageSentEmailProjection> getInboxSentEmailsWithHttpInfo(UUID inboxId, Integer page, Integer size, String sort) throws ApiException {
        Call localVarCall = this.getInboxSentEmailsValidateBeforeCall(inboxId, page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageSentEmailProjection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getInboxSentEmailsAsync(UUID inboxId, Integer page, Integer size, String sort, ApiCallback<PageSentEmailProjection> _callback) throws ApiException {
        Call localVarCall = this.getInboxSentEmailsValidateBeforeCall(inboxId, page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageSentEmailProjection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getInboxTagsCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inboxes/tags";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInboxTagsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getInboxTagsCall(_callback);
        return localVarCall;
    }

    public List<String> getInboxTags() throws ApiException {
        ApiResponse<List<String>> localVarResp = this.getInboxTagsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<String>> getInboxTagsWithHttpInfo() throws ApiException {
        Call localVarCall = this.getInboxTagsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getInboxTagsAsync(ApiCallback<List<String>> _callback) throws ApiException {
        Call localVarCall = this.getInboxTagsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<String>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getInboxesCall(Integer size, String sort, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inboxes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getInboxesValidateBeforeCall(Integer size, String sort, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getInboxesCall(size, sort, _callback);
        return localVarCall;
    }

    public List<Inbox> getInboxes(Integer size, String sort) throws ApiException {
        ApiResponse<List<Inbox>> localVarResp = this.getInboxesWithHttpInfo(size, sort);
        return localVarResp.getData();
    }

    public ApiResponse<List<Inbox>> getInboxesWithHttpInfo(Integer size, String sort) throws ApiException {
        Call localVarCall = this.getInboxesValidateBeforeCall(size, sort, null);
        Type localVarReturnType = new TypeToken<List<Inbox>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getInboxesAsync(Integer size, String sort, ApiCallback<List<Inbox>> _callback) throws ApiException {
        Call localVarCall = this.getInboxesValidateBeforeCall(size, sort, _callback);
        Type localVarReturnType = new TypeToken<List<Inbox>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getOrganizationInboxesCall(Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inboxes/organization";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getOrganizationInboxesValidateBeforeCall(Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getOrganizationInboxesCall(page, size, sort, _callback);
        return localVarCall;
    }

    public PageOrganizationInboxProjection getOrganizationInboxes(Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageOrganizationInboxProjection> localVarResp = this.getOrganizationInboxesWithHttpInfo(page, size, sort);
        return localVarResp.getData();
    }

    public ApiResponse<PageOrganizationInboxProjection> getOrganizationInboxesWithHttpInfo(Integer page, Integer size, String sort) throws ApiException {
        Call localVarCall = this.getOrganizationInboxesValidateBeforeCall(page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageOrganizationInboxProjection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getOrganizationInboxesAsync(Integer page, Integer size, String sort, ApiCallback<PageOrganizationInboxProjection> _callback) throws ApiException {
        Call localVarCall = this.getOrganizationInboxesValidateBeforeCall(page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageOrganizationInboxProjection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call sendEmailCall(UUID inboxId, SendEmailOptions sendEmailOptions, ApiCallback _callback) throws ApiException {
        SendEmailOptions localVarPostBody = sendEmailOptions;
        String localVarPath = "/inboxes/{inboxId}".replaceAll("\\{inboxId\\}", this.localVarApiClient.escapeString(inboxId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call sendEmailValidateBeforeCall(UUID inboxId, SendEmailOptions sendEmailOptions, ApiCallback _callback) throws ApiException {
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling sendEmail(Async)");
        }
        Call localVarCall = this.sendEmailCall(inboxId, sendEmailOptions, _callback);
        return localVarCall;
    }

    public void sendEmail(UUID inboxId, SendEmailOptions sendEmailOptions) throws ApiException {
        this.sendEmailWithHttpInfo(inboxId, sendEmailOptions);
    }

    public ApiResponse<Void> sendEmailWithHttpInfo(UUID inboxId, SendEmailOptions sendEmailOptions) throws ApiException {
        Call localVarCall = this.sendEmailValidateBeforeCall(inboxId, sendEmailOptions, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call sendEmailAsync(UUID inboxId, SendEmailOptions sendEmailOptions, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.sendEmailValidateBeforeCall(inboxId, sendEmailOptions, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call sendEmailAndConfirmCall(UUID inboxId, SendEmailOptions sendEmailOptions, ApiCallback _callback) throws ApiException {
        SendEmailOptions localVarPostBody = sendEmailOptions;
        String localVarPath = "/inboxes/{inboxId}/confirm".replaceAll("\\{inboxId\\}", this.localVarApiClient.escapeString(inboxId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call sendEmailAndConfirmValidateBeforeCall(UUID inboxId, SendEmailOptions sendEmailOptions, ApiCallback _callback) throws ApiException {
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling sendEmailAndConfirm(Async)");
        }
        Call localVarCall = this.sendEmailAndConfirmCall(inboxId, sendEmailOptions, _callback);
        return localVarCall;
    }

    public SentEmailDto sendEmailAndConfirm(UUID inboxId, SendEmailOptions sendEmailOptions) throws ApiException {
        ApiResponse<SentEmailDto> localVarResp = this.sendEmailAndConfirmWithHttpInfo(inboxId, sendEmailOptions);
        return localVarResp.getData();
    }

    public ApiResponse<SentEmailDto> sendEmailAndConfirmWithHttpInfo(UUID inboxId, SendEmailOptions sendEmailOptions) throws ApiException {
        Call localVarCall = this.sendEmailAndConfirmValidateBeforeCall(inboxId, sendEmailOptions, null);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call sendEmailAndConfirmAsync(UUID inboxId, SendEmailOptions sendEmailOptions, ApiCallback<SentEmailDto> _callback) throws ApiException {
        Call localVarCall = this.sendEmailAndConfirmValidateBeforeCall(inboxId, sendEmailOptions, _callback);
        Type localVarReturnType = new TypeToken<SentEmailDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setInboxFavouritedCall(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions, ApiCallback _callback) throws ApiException {
        SetInboxFavouritedOptions localVarPostBody = setInboxFavouritedOptions;
        String localVarPath = "/inboxes/{inboxId}/favourite".replaceAll("\\{inboxId\\}", this.localVarApiClient.escapeString(inboxId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setInboxFavouritedValidateBeforeCall(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions, ApiCallback _callback) throws ApiException {
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling setInboxFavourited(Async)");
        }
        if (setInboxFavouritedOptions == null) {
            throw new ApiException("Missing the required parameter 'setInboxFavouritedOptions' when calling setInboxFavourited(Async)");
        }
        Call localVarCall = this.setInboxFavouritedCall(inboxId, setInboxFavouritedOptions, _callback);
        return localVarCall;
    }

    public Inbox setInboxFavourited(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions) throws ApiException {
        ApiResponse<Inbox> localVarResp = this.setInboxFavouritedWithHttpInfo(inboxId, setInboxFavouritedOptions);
        return localVarResp.getData();
    }

    public ApiResponse<Inbox> setInboxFavouritedWithHttpInfo(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions) throws ApiException {
        Call localVarCall = this.setInboxFavouritedValidateBeforeCall(inboxId, setInboxFavouritedOptions, null);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setInboxFavouritedAsync(UUID inboxId, SetInboxFavouritedOptions setInboxFavouritedOptions, ApiCallback<Inbox> _callback) throws ApiException {
        Call localVarCall = this.setInboxFavouritedValidateBeforeCall(inboxId, setInboxFavouritedOptions, _callback);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateInboxCall(UUID inboxId, UpdateInboxOptions updateInboxOptions, ApiCallback _callback) throws ApiException {
        UpdateInboxOptions localVarPostBody = updateInboxOptions;
        String localVarPath = "/inboxes/{inboxId}".replaceAll("\\{inboxId\\}", this.localVarApiClient.escapeString(inboxId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateInboxValidateBeforeCall(UUID inboxId, UpdateInboxOptions updateInboxOptions, ApiCallback _callback) throws ApiException {
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling updateInbox(Async)");
        }
        if (updateInboxOptions == null) {
            throw new ApiException("Missing the required parameter 'updateInboxOptions' when calling updateInbox(Async)");
        }
        Call localVarCall = this.updateInboxCall(inboxId, updateInboxOptions, _callback);
        return localVarCall;
    }

    public Inbox updateInbox(UUID inboxId, UpdateInboxOptions updateInboxOptions) throws ApiException {
        ApiResponse<Inbox> localVarResp = this.updateInboxWithHttpInfo(inboxId, updateInboxOptions);
        return localVarResp.getData();
    }

    public ApiResponse<Inbox> updateInboxWithHttpInfo(UUID inboxId, UpdateInboxOptions updateInboxOptions) throws ApiException {
        Call localVarCall = this.updateInboxValidateBeforeCall(inboxId, updateInboxOptions, null);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateInboxAsync(UUID inboxId, UpdateInboxOptions updateInboxOptions, ApiCallback<Inbox> _callback) throws ApiException {
        Call localVarCall = this.updateInboxValidateBeforeCall(inboxId, updateInboxOptions, _callback);
        Type localVarReturnType = new TypeToken<Inbox>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

