/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.apis;

import com.google.gson.reflect.TypeToken;
import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.models.CreateTemplateOptions;
import com.mailslurp.models.PageTemplateProjection;
import com.mailslurp.models.TemplateDto;
import com.mailslurp.models.TemplateProjection;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.Call;

public class TemplateControllerApi {
    private ApiClient localVarApiClient;

    public TemplateControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TemplateControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createTemplateCall(CreateTemplateOptions createTemplateOptions, ApiCallback _callback) throws ApiException {
        CreateTemplateOptions localVarPostBody = createTemplateOptions;
        String localVarPath = "/templates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createTemplateValidateBeforeCall(CreateTemplateOptions createTemplateOptions, ApiCallback _callback) throws ApiException {
        if (createTemplateOptions == null) {
            throw new ApiException("Missing the required parameter 'createTemplateOptions' when calling createTemplate(Async)");
        }
        Call localVarCall = this.createTemplateCall(createTemplateOptions, _callback);
        return localVarCall;
    }

    public TemplateDto createTemplate(CreateTemplateOptions createTemplateOptions) throws ApiException {
        ApiResponse<TemplateDto> localVarResp = this.createTemplateWithHttpInfo(createTemplateOptions);
        return localVarResp.getData();
    }

    public ApiResponse<TemplateDto> createTemplateWithHttpInfo(CreateTemplateOptions createTemplateOptions) throws ApiException {
        Call localVarCall = this.createTemplateValidateBeforeCall(createTemplateOptions, null);
        Type localVarReturnType = new TypeToken<TemplateDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createTemplateAsync(CreateTemplateOptions createTemplateOptions, ApiCallback<TemplateDto> _callback) throws ApiException {
        Call localVarCall = this.createTemplateValidateBeforeCall(createTemplateOptions, _callback);
        Type localVarReturnType = new TypeToken<TemplateDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteTemplateCall(UUID templateId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/templates/{TemplateId}".replaceAll("\\{TemplateId\\}", this.localVarApiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteTemplateValidateBeforeCall(UUID templateId, ApiCallback _callback) throws ApiException {
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling deleteTemplate(Async)");
        }
        Call localVarCall = this.deleteTemplateCall(templateId, _callback);
        return localVarCall;
    }

    public void deleteTemplate(UUID templateId) throws ApiException {
        this.deleteTemplateWithHttpInfo(templateId);
    }

    public ApiResponse<Void> deleteTemplateWithHttpInfo(UUID templateId) throws ApiException {
        Call localVarCall = this.deleteTemplateValidateBeforeCall(templateId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteTemplateAsync(UUID templateId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteTemplateValidateBeforeCall(templateId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAllTemplatesCall(Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/templates/paginated";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllTemplatesValidateBeforeCall(Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAllTemplatesCall(page, size, sort, _callback);
        return localVarCall;
    }

    public PageTemplateProjection getAllTemplates(Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageTemplateProjection> localVarResp = this.getAllTemplatesWithHttpInfo(page, size, sort);
        return localVarResp.getData();
    }

    public ApiResponse<PageTemplateProjection> getAllTemplatesWithHttpInfo(Integer page, Integer size, String sort) throws ApiException {
        Call localVarCall = this.getAllTemplatesValidateBeforeCall(page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageTemplateProjection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllTemplatesAsync(Integer page, Integer size, String sort, ApiCallback<PageTemplateProjection> _callback) throws ApiException {
        Call localVarCall = this.getAllTemplatesValidateBeforeCall(page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageTemplateProjection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTemplateCall(UUID templateId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/templates/{TemplateId}".replaceAll("\\{TemplateId\\}", this.localVarApiClient.escapeString(templateId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTemplateValidateBeforeCall(UUID templateId, ApiCallback _callback) throws ApiException {
        if (templateId == null) {
            throw new ApiException("Missing the required parameter 'templateId' when calling getTemplate(Async)");
        }
        Call localVarCall = this.getTemplateCall(templateId, _callback);
        return localVarCall;
    }

    public TemplateDto getTemplate(UUID templateId) throws ApiException {
        ApiResponse<TemplateDto> localVarResp = this.getTemplateWithHttpInfo(templateId);
        return localVarResp.getData();
    }

    public ApiResponse<TemplateDto> getTemplateWithHttpInfo(UUID templateId) throws ApiException {
        Call localVarCall = this.getTemplateValidateBeforeCall(templateId, null);
        Type localVarReturnType = new TypeToken<TemplateDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTemplateAsync(UUID templateId, ApiCallback<TemplateDto> _callback) throws ApiException {
        Call localVarCall = this.getTemplateValidateBeforeCall(templateId, _callback);
        Type localVarReturnType = new TypeToken<TemplateDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getTemplatesCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/templates";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getTemplatesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getTemplatesCall(_callback);
        return localVarCall;
    }

    public List<TemplateProjection> getTemplates() throws ApiException {
        ApiResponse<List<TemplateProjection>> localVarResp = this.getTemplatesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<TemplateProjection>> getTemplatesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getTemplatesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<TemplateProjection>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getTemplatesAsync(ApiCallback<List<TemplateProjection>> _callback) throws ApiException {
        Call localVarCall = this.getTemplatesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<TemplateProjection>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

