/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.apis;

import com.google.gson.reflect.TypeToken;
import com.mailslurp.clients.ApiCallback;
import com.mailslurp.clients.ApiClient;
import com.mailslurp.clients.ApiException;
import com.mailslurp.clients.ApiResponse;
import com.mailslurp.clients.Configuration;
import com.mailslurp.clients.Pair;
import com.mailslurp.models.CreateWebhookOptions;
import com.mailslurp.models.PageWebhookProjection;
import com.mailslurp.models.WebhookDto;
import com.mailslurp.models.WebhookTestResult;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import okhttp3.Call;

public class WebhookControllerApi {
    private ApiClient localVarApiClient;

    public WebhookControllerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WebhookControllerApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createWebhookCall(UUID inboxId, CreateWebhookOptions webhookOptions, ApiCallback _callback) throws ApiException {
        CreateWebhookOptions localVarPostBody = webhookOptions;
        String localVarPath = "/inboxes/{inboxId}/webhooks".replaceAll("\\{inboxId\\}", this.localVarApiClient.escapeString(inboxId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createWebhookValidateBeforeCall(UUID inboxId, CreateWebhookOptions webhookOptions, ApiCallback _callback) throws ApiException {
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling createWebhook(Async)");
        }
        if (webhookOptions == null) {
            throw new ApiException("Missing the required parameter 'webhookOptions' when calling createWebhook(Async)");
        }
        Call localVarCall = this.createWebhookCall(inboxId, webhookOptions, _callback);
        return localVarCall;
    }

    public WebhookDto createWebhook(UUID inboxId, CreateWebhookOptions webhookOptions) throws ApiException {
        ApiResponse<WebhookDto> localVarResp = this.createWebhookWithHttpInfo(inboxId, webhookOptions);
        return localVarResp.getData();
    }

    public ApiResponse<WebhookDto> createWebhookWithHttpInfo(UUID inboxId, CreateWebhookOptions webhookOptions) throws ApiException {
        Call localVarCall = this.createWebhookValidateBeforeCall(inboxId, webhookOptions, null);
        Type localVarReturnType = new TypeToken<WebhookDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createWebhookAsync(UUID inboxId, CreateWebhookOptions webhookOptions, ApiCallback<WebhookDto> _callback) throws ApiException {
        Call localVarCall = this.createWebhookValidateBeforeCall(inboxId, webhookOptions, _callback);
        Type localVarReturnType = new TypeToken<WebhookDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteWebhookCall(UUID inboxId, UUID webhookId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inboxes/{inboxId}/webhooks/{webhookId}".replaceAll("\\{inboxId\\}", this.localVarApiClient.escapeString(inboxId.toString())).replaceAll("\\{webhookId\\}", this.localVarApiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteWebhookValidateBeforeCall(UUID inboxId, UUID webhookId, ApiCallback _callback) throws ApiException {
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling deleteWebhook(Async)");
        }
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling deleteWebhook(Async)");
        }
        Call localVarCall = this.deleteWebhookCall(inboxId, webhookId, _callback);
        return localVarCall;
    }

    public void deleteWebhook(UUID inboxId, UUID webhookId) throws ApiException {
        this.deleteWebhookWithHttpInfo(inboxId, webhookId);
    }

    public ApiResponse<Void> deleteWebhookWithHttpInfo(UUID inboxId, UUID webhookId) throws ApiException {
        Call localVarCall = this.deleteWebhookValidateBeforeCall(inboxId, webhookId, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteWebhookAsync(UUID inboxId, UUID webhookId, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteWebhookValidateBeforeCall(inboxId, webhookId, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getAllWebhooksCall(Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/webhooks/paginated";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (page != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page", page));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("size", size));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sort", sort));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAllWebhooksValidateBeforeCall(Integer page, Integer size, String sort, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getAllWebhooksCall(page, size, sort, _callback);
        return localVarCall;
    }

    public PageWebhookProjection getAllWebhooks(Integer page, Integer size, String sort) throws ApiException {
        ApiResponse<PageWebhookProjection> localVarResp = this.getAllWebhooksWithHttpInfo(page, size, sort);
        return localVarResp.getData();
    }

    public ApiResponse<PageWebhookProjection> getAllWebhooksWithHttpInfo(Integer page, Integer size, String sort) throws ApiException {
        Call localVarCall = this.getAllWebhooksValidateBeforeCall(page, size, sort, null);
        Type localVarReturnType = new TypeToken<PageWebhookProjection>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAllWebhooksAsync(Integer page, Integer size, String sort, ApiCallback<PageWebhookProjection> _callback) throws ApiException {
        Call localVarCall = this.getAllWebhooksValidateBeforeCall(page, size, sort, _callback);
        Type localVarReturnType = new TypeToken<PageWebhookProjection>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getWebhookCall(UUID webhookId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/webhooks/{webhookId}".replaceAll("\\{webhookId\\}", this.localVarApiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWebhookValidateBeforeCall(UUID webhookId, ApiCallback _callback) throws ApiException {
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling getWebhook(Async)");
        }
        Call localVarCall = this.getWebhookCall(webhookId, _callback);
        return localVarCall;
    }

    public WebhookDto getWebhook(UUID webhookId) throws ApiException {
        ApiResponse<WebhookDto> localVarResp = this.getWebhookWithHttpInfo(webhookId);
        return localVarResp.getData();
    }

    public ApiResponse<WebhookDto> getWebhookWithHttpInfo(UUID webhookId) throws ApiException {
        Call localVarCall = this.getWebhookValidateBeforeCall(webhookId, null);
        Type localVarReturnType = new TypeToken<WebhookDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getWebhookAsync(UUID webhookId, ApiCallback<WebhookDto> _callback) throws ApiException {
        Call localVarCall = this.getWebhookValidateBeforeCall(webhookId, _callback);
        Type localVarReturnType = new TypeToken<WebhookDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getWebhooksCall(UUID inboxId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/inboxes/{inboxId}/webhooks".replaceAll("\\{inboxId\\}", this.localVarApiClient.escapeString(inboxId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getWebhooksValidateBeforeCall(UUID inboxId, ApiCallback _callback) throws ApiException {
        if (inboxId == null) {
            throw new ApiException("Missing the required parameter 'inboxId' when calling getWebhooks(Async)");
        }
        Call localVarCall = this.getWebhooksCall(inboxId, _callback);
        return localVarCall;
    }

    public List<WebhookDto> getWebhooks(UUID inboxId) throws ApiException {
        ApiResponse<List<WebhookDto>> localVarResp = this.getWebhooksWithHttpInfo(inboxId);
        return localVarResp.getData();
    }

    public ApiResponse<List<WebhookDto>> getWebhooksWithHttpInfo(UUID inboxId) throws ApiException {
        Call localVarCall = this.getWebhooksValidateBeforeCall(inboxId, null);
        Type localVarReturnType = new TypeToken<List<WebhookDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getWebhooksAsync(UUID inboxId, ApiCallback<List<WebhookDto>> _callback) throws ApiException {
        Call localVarCall = this.getWebhooksValidateBeforeCall(inboxId, _callback);
        Type localVarReturnType = new TypeToken<List<WebhookDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call sendTestDataCall(UUID webhookId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/webhooks/{webhookId}/test".replaceAll("\\{webhookId\\}", this.localVarApiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"API_KEY"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call sendTestDataValidateBeforeCall(UUID webhookId, ApiCallback _callback) throws ApiException {
        if (webhookId == null) {
            throw new ApiException("Missing the required parameter 'webhookId' when calling sendTestData(Async)");
        }
        Call localVarCall = this.sendTestDataCall(webhookId, _callback);
        return localVarCall;
    }

    public WebhookTestResult sendTestData(UUID webhookId) throws ApiException {
        ApiResponse<WebhookTestResult> localVarResp = this.sendTestDataWithHttpInfo(webhookId);
        return localVarResp.getData();
    }

    public ApiResponse<WebhookTestResult> sendTestDataWithHttpInfo(UUID webhookId) throws ApiException {
        Call localVarCall = this.sendTestDataValidateBeforeCall(webhookId, null);
        Type localVarReturnType = new TypeToken<WebhookTestResult>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call sendTestDataAsync(UUID webhookId, ApiCallback<WebhookTestResult> _callback) throws ApiException {
        Call localVarCall = this.sendTestDataValidateBeforeCall(webhookId, _callback);
        Type localVarReturnType = new TypeToken<WebhookTestResult>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

