/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="Email alias representation")
public class AliasDto {
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "emailAddress";
    @SerializedName(value="emailAddress")
    private String emailAddress;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_INBOX_ID = "inboxId";
    @SerializedName(value="inboxId")
    private UUID inboxId;
    public static final String SERIALIZED_NAME_IS_VERIFIED = "isVerified";
    @SerializedName(value="isVerified")
    private Boolean isVerified;
    public static final String SERIALIZED_NAME_MASKED_EMAIL_ADDRESS = "maskedEmailAddress";
    @SerializedName(value="maskedEmailAddress")
    private String maskedEmailAddress;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_USE_THREADS = "useThreads";
    @SerializedName(value="useThreads")
    private Boolean useThreads;
    public static final String SERIALIZED_NAME_USER_ID = "userId";
    @SerializedName(value="userId")
    private UUID userId;

    public AliasDto createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public AliasDto emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The alias's email address for receiving email")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public AliasDto id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public AliasDto inboxId(UUID inboxId) {
        this.inboxId = inboxId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Inbox that is associated with the alias")
    public UUID getInboxId() {
        return this.inboxId;
    }

    public void setInboxId(UUID inboxId) {
        this.inboxId = inboxId;
    }

    public AliasDto isVerified(Boolean isVerified) {
        this.isVerified = isVerified;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Has the alias been verified. You must verify an alias if the masked email address has not yet been verified by your account")
    public Boolean getIsVerified() {
        return this.isVerified;
    }

    public void setIsVerified(Boolean isVerified) {
        this.isVerified = isVerified;
    }

    public AliasDto maskedEmailAddress(String maskedEmailAddress) {
        this.maskedEmailAddress = maskedEmailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The underlying email address that is hidden and will received forwarded email")
    public String getMaskedEmailAddress() {
        return this.maskedEmailAddress;
    }

    public void setMaskedEmailAddress(String maskedEmailAddress) {
        this.maskedEmailAddress = maskedEmailAddress;
    }

    public AliasDto name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AliasDto updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public AliasDto useThreads(Boolean useThreads) {
        this.useThreads = useThreads;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If alias will generate response threads or not when email are received by it")
    public Boolean getUseThreads() {
        return this.useThreads;
    }

    public void setUseThreads(Boolean useThreads) {
        this.useThreads = useThreads;
    }

    public AliasDto userId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public UUID getUserId() {
        return this.userId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasDto aliasDto = (AliasDto)o;
        return Objects.equals(this.createdAt, aliasDto.createdAt) && Objects.equals(this.emailAddress, aliasDto.emailAddress) && Objects.equals(this.id, aliasDto.id) && Objects.equals(this.inboxId, aliasDto.inboxId) && Objects.equals(this.isVerified, aliasDto.isVerified) && Objects.equals(this.maskedEmailAddress, aliasDto.maskedEmailAddress) && Objects.equals(this.name, aliasDto.name) && Objects.equals(this.updatedAt, aliasDto.updatedAt) && Objects.equals(this.useThreads, aliasDto.useThreads) && Objects.equals(this.userId, aliasDto.userId);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.emailAddress, this.id, this.inboxId, this.isVerified, this.maskedEmailAddress, this.name, this.updatedAt, this.useThreads, this.userId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AliasDto {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    inboxId: ").append(this.toIndentedString(this.inboxId)).append("\n");
        sb.append("    isVerified: ").append(this.toIndentedString(this.isVerified)).append("\n");
        sb.append("    maskedEmailAddress: ").append(this.toIndentedString(this.maskedEmailAddress)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    useThreads: ").append(this.toIndentedString(this.useThreads)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

