/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Meta data associated with an attachment. Attachments are stored as byte blobs so the meta data is stored separately.")
public class AttachmentMetaData {
    public static final String SERIALIZED_NAME_CONTENT_LENGTH = "contentLength";
    @SerializedName(value="contentLength")
    private Long contentLength;
    public static final String SERIALIZED_NAME_CONTENT_TYPE = "contentType";
    @SerializedName(value="contentType")
    private String contentType;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;

    public AttachmentMetaData contentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size of attachment in bytes")
    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public AttachmentMetaData contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Content type of attachment")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public AttachmentMetaData id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of attachment")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AttachmentMetaData name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of attachment")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttachmentMetaData attachmentMetaData = (AttachmentMetaData)o;
        return Objects.equals(this.contentLength, attachmentMetaData.contentLength) && Objects.equals(this.contentType, attachmentMetaData.contentType) && Objects.equals(this.id, attachmentMetaData.id) && Objects.equals(this.name, attachmentMetaData.name);
    }

    public int hashCode() {
        return Objects.hash(this.contentLength, this.contentType, this.id, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AttachmentMetaData {\n");
        sb.append("    contentLength: ").append(this.toIndentedString(this.contentLength)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

