/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import com.mailslurp.models.SendEmailOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="Options for bulk sending an email from multiple addresses. See regular `sendEmail` methods for more information.")
public class BulkSendEmailOptions {
    public static final String SERIALIZED_NAME_INBOX_IDS = "inboxIds";
    @SerializedName(value="inboxIds")
    private List<UUID> inboxIds = null;
    public static final String SERIALIZED_NAME_SEND_EMAIL_OPTIONS = "sendEmailOptions";
    @SerializedName(value="sendEmailOptions")
    private SendEmailOptions sendEmailOptions;

    public BulkSendEmailOptions inboxIds(List<UUID> inboxIds) {
        this.inboxIds = inboxIds;
        return this;
    }

    public BulkSendEmailOptions addInboxIdsItem(UUID inboxIdsItem) {
        if (this.inboxIds == null) {
            this.inboxIds = new ArrayList<UUID>();
        }
        this.inboxIds.add(inboxIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Inboxes to send the email from")
    public List<UUID> getInboxIds() {
        return this.inboxIds;
    }

    public void setInboxIds(List<UUID> inboxIds) {
        this.inboxIds = inboxIds;
    }

    public BulkSendEmailOptions sendEmailOptions(SendEmailOptions sendEmailOptions) {
        this.sendEmailOptions = sendEmailOptions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SendEmailOptions getSendEmailOptions() {
        return this.sendEmailOptions;
    }

    public void setSendEmailOptions(SendEmailOptions sendEmailOptions) {
        this.sendEmailOptions = sendEmailOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkSendEmailOptions bulkSendEmailOptions = (BulkSendEmailOptions)o;
        return Objects.equals(this.inboxIds, bulkSendEmailOptions.inboxIds) && Objects.equals(this.sendEmailOptions, bulkSendEmailOptions.sendEmailOptions);
    }

    public int hashCode() {
        return Objects.hash(this.inboxIds, this.sendEmailOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkSendEmailOptions {\n");
        sb.append("    inboxIds: ").append(this.toIndentedString(this.inboxIds)).append("\n");
        sb.append("    sendEmailOptions: ").append(this.toIndentedString(this.sendEmailOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

