/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Options for matching content using regex patterns based on Java Pattern syntax")
public class ContentMatchOptions {
    public static final String SERIALIZED_NAME_PATTERN = "pattern";
    @SerializedName(value="pattern")
    private String pattern;

    public ContentMatchOptions pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Java style regex pattern. Do not include the typical `/` at start or end of regex in some languages. Given an example `your code is: 12345` the pattern to extract match looks like `code is: (\\d{6})`. This will return an array of matches with the first matching the entire pattern and the subsequent matching the groups: `['code is: 123456', '123456']` See https://docs.oracle.com/javase/8/docs/api/java/util/regex/Pattern.html for more information of available patterns.")
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentMatchOptions contentMatchOptions = (ContentMatchOptions)o;
        return Objects.equals(this.pattern, contentMatchOptions.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentMatchOptions {\n");
        sb.append("    pattern: ").append(this.toIndentedString(this.pattern)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

