/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

public class CreateContactOptions {
    public static final String SERIALIZED_NAME_EMAIL_ADDRESSES = "emailAddresses";
    @SerializedName(value="emailAddresses")
    private List<String> emailAddresses = null;
    public static final String SERIALIZED_NAME_FIRST_NAME = "firstName";
    @SerializedName(value="firstName")
    private String firstName;
    public static final String SERIALIZED_NAME_GROUP_ID = "groupId";
    @SerializedName(value="groupId")
    private UUID groupId;
    public static final String SERIALIZED_NAME_META_DATA = "metaData";
    @SerializedName(value="metaData")
    private Object metaData;
    public static final String SERIALIZED_NAME_OPT_OUT = "optOut";
    @SerializedName(value="optOut")
    private Boolean optOut;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_LAST_NAME = "lastName";
    @SerializedName(value="lastName")
    private String lastName;
    public static final String SERIALIZED_NAME_COMPANY = "company";
    @SerializedName(value="company")
    private String company;

    public CreateContactOptions emailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    public CreateContactOptions addEmailAddressesItem(String emailAddressesItem) {
        if (this.emailAddresses == null) {
            this.emailAddresses = new ArrayList<String>();
        }
        this.emailAddresses.add(emailAddressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of email addresses belonging to the contact")
    public List<String> getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    public CreateContactOptions firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public CreateContactOptions groupId(UUID groupId) {
        this.groupId = groupId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Group IDs that contact belongs to")
    public UUID getGroupId() {
        return this.groupId;
    }

    public void setGroupId(UUID groupId) {
        this.groupId = groupId;
    }

    public CreateContactOptions metaData(Object metaData) {
        this.metaData = metaData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Object getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Object metaData) {
        this.metaData = metaData;
    }

    public CreateContactOptions optOut(Boolean optOut) {
        this.optOut = optOut;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Has the user explicitly or implicitly opted out of being contacted? If so MailSlurp will ignore them in all actions.")
    public Boolean getOptOut() {
        return this.optOut;
    }

    public void setOptOut(Boolean optOut) {
        this.optOut = optOut;
    }

    public CreateContactOptions tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public CreateContactOptions addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tags that can be used to search and group contacts")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public CreateContactOptions lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public CreateContactOptions company(String company) {
        this.company = company;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateContactOptions createContactOptions = (CreateContactOptions)o;
        return Objects.equals(this.emailAddresses, createContactOptions.emailAddresses) && Objects.equals(this.firstName, createContactOptions.firstName) && Objects.equals(this.groupId, createContactOptions.groupId) && Objects.equals(this.metaData, createContactOptions.metaData) && Objects.equals(this.optOut, createContactOptions.optOut) && Objects.equals(this.tags, createContactOptions.tags) && Objects.equals(this.lastName, createContactOptions.lastName) && Objects.equals(this.company, createContactOptions.company);
    }

    public int hashCode() {
        return Objects.hash(this.emailAddresses, this.firstName, this.groupId, this.metaData, this.optOut, this.tags, this.lastName, this.company);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateContactOptions {\n");
        sb.append("    emailAddresses: ").append(this.toIndentedString(this.emailAddresses)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    metaData: ").append(this.toIndentedString(this.metaData)).append("\n");
        sb.append("    optOut: ").append(this.toIndentedString(this.optOut)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    company: ").append(this.toIndentedString(this.company)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

