/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Options for creating a domain to use with MailSlurp. You must have ownership access to this domain in order to verify it. Domains will not functionally currently until the domain has been verified. See https://www.mailslurp.com/guides/custom-domains for help.")
public class CreateDomainOptions {
    public static final String SERIALIZED_NAME_CREATED_CATCH_ALL_INBOX = "createdCatchAllInbox";
    @SerializedName(value="createdCatchAllInbox")
    private Boolean createdCatchAllInbox;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DOMAIN = "domain";
    @SerializedName(value="domain")
    private String domain;

    public CreateDomainOptions createdCatchAllInbox(Boolean createdCatchAllInbox) {
        this.createdCatchAllInbox = createdCatchAllInbox;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether to create a catch all inbox for the domain. Any email sent to an address using your domain that cannot be matched to an existing inbox you created with the domain will be routed to the created catch all inbox. You can access emails using the regular methods on this inbox ID.")
    public Boolean getCreatedCatchAllInbox() {
        return this.createdCatchAllInbox;
    }

    public void setCreatedCatchAllInbox(Boolean createdCatchAllInbox) {
        this.createdCatchAllInbox = createdCatchAllInbox;
    }

    public CreateDomainOptions description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional description of the domain.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateDomainOptions domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The top level domain you wish to use with MailSlurp. Do not specify subdomain just the top level. So `test.com` covers all subdomains such as `mail.test.com`. Don't include a protocol such as `http://`. Once added you must complete the verification steps by adding the returned records to your domain.")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateDomainOptions createDomainOptions = (CreateDomainOptions)o;
        return Objects.equals(this.createdCatchAllInbox, createDomainOptions.createdCatchAllInbox) && Objects.equals(this.description, createDomainOptions.description) && Objects.equals(this.domain, createDomainOptions.domain);
    }

    public int hashCode() {
        return Objects.hash(this.createdCatchAllInbox, this.description, this.domain);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateDomainOptions {\n");
        sb.append("    createdCatchAllInbox: ").append(this.toIndentedString(this.createdCatchAllInbox)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

