/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Options for creating an inbox. An inbox has a real email address that can send and receive emails. Inboxes can be permanent or expire at a given time. They can use a custom email address (by verifying your own domain) or a randomly assigned email ending in either `mailslurp.com` or if `useDomainPool` is enabled then ending in a similar domains such as `mailslurp.xyz` (selected at random). ")
public class CreateInboxDto {
    public static final String SERIALIZED_NAME_ALLOW_TEAM_ACCESS = "allowTeamAccess";
    @SerializedName(value="allowTeamAccess")
    private Boolean allowTeamAccess;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "emailAddress";
    @SerializedName(value="emailAddress")
    private String emailAddress;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expiresAt";
    @SerializedName(value="expiresAt")
    private OffsetDateTime expiresAt;
    public static final String SERIALIZED_NAME_EXPIRES_IN = "expiresIn";
    @SerializedName(value="expiresIn")
    private Long expiresIn;
    public static final String SERIALIZED_NAME_FAVOURITE = "favourite";
    @SerializedName(value="favourite")
    private Boolean favourite;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_USE_DOMAIN_POOL = "useDomainPool";
    @SerializedName(value="useDomainPool")
    private Boolean useDomainPool;

    public CreateInboxDto allowTeamAccess(Boolean allowTeamAccess) {
        this.allowTeamAccess = allowTeamAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Grant team access to this inbox and the emails that belong to it for team members of your organization.")
    public Boolean getAllowTeamAccess() {
        return this.allowTeamAccess;
    }

    public void setAllowTeamAccess(Boolean allowTeamAccess) {
        this.allowTeamAccess = allowTeamAccess;
    }

    public CreateInboxDto description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional description of the inbox for labelling purposes. Is shown in the dashboard and can be used with")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateInboxDto emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A custom email address to use with the inbox. Defaults to null. When null MailSlurp will assign a random email address to the inbox such as `123@mailslurp.com`. If you use the `useDomainPool` option when the email address is null it will generate an email address with a more varied domain ending such as `123@mailslurp.info` or `123@mailslurp.biz`. When a custom email address is provided the address is split into a domain and the domain is queried against your user. If you have created the domain in the MailSlurp dashboard and verified it you can use any email address that ends with the domain. Send an email to this address and the inbox will receive and store it for you. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public CreateInboxDto expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional inbox expiration date. If null then this inbox is permanent and the emails in it won't be deleted. If an expiration date is provided or is required by your plan the inbox will be closed when the expiration time is reached. Expired inboxes still contain their emails but can no longer send or receive emails. An ExpiredInboxRecord is created when an inbox and the email address and inbox ID are recorded. The expiresAt property is a timestamp string in ISO DateTime Format yyyy-MM-dd'T'HH:mm:ss.SSSXXX.")
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public CreateInboxDto expiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of milliseconds that inbox should exist for")
    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Long expiresIn) {
        this.expiresIn = expiresIn;
    }

    public CreateInboxDto favourite(Boolean favourite) {
        this.favourite = favourite;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Is the inbox favorited. Favouriting inboxes is typically done in the dashboard for quick access or filtering")
    public Boolean getFavourite() {
        return this.favourite;
    }

    public void setFavourite(Boolean favourite) {
        this.favourite = favourite;
    }

    public CreateInboxDto name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional name of the inbox. Displayed in the dashboard for easier search")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateInboxDto tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public CreateInboxDto addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public CreateInboxDto useDomainPool(Boolean useDomainPool) {
        this.useDomainPool = useDomainPool;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Use the MailSlurp domain name pool with this inbox when creating the email address. Defaults to null. If enabled the inbox will be an email address with a domain randomly chosen from a list of the MailSlurp domains. This is useful when the default `@mailslurp.com` email addresses used with inboxes are blocked or considered spam by a provider or receiving service. When domain pool is enabled an email address will be generated ending in `@mailslurp.{world,info,xyz,...}` . This means a TLD is randomly selecting from a list of `.biz`, `.info`, `.xyz` etc to add variance to the generated email addresses. When null or false MailSlurp uses the default behavior of `@mailslurp.com` or custom email address provided by the emailAddress field.")
    public Boolean getUseDomainPool() {
        return this.useDomainPool;
    }

    public void setUseDomainPool(Boolean useDomainPool) {
        this.useDomainPool = useDomainPool;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateInboxDto createInboxDto = (CreateInboxDto)o;
        return Objects.equals(this.allowTeamAccess, createInboxDto.allowTeamAccess) && Objects.equals(this.description, createInboxDto.description) && Objects.equals(this.emailAddress, createInboxDto.emailAddress) && Objects.equals(this.expiresAt, createInboxDto.expiresAt) && Objects.equals(this.expiresIn, createInboxDto.expiresIn) && Objects.equals(this.favourite, createInboxDto.favourite) && Objects.equals(this.name, createInboxDto.name) && Objects.equals(this.tags, createInboxDto.tags) && Objects.equals(this.useDomainPool, createInboxDto.useDomainPool);
    }

    public int hashCode() {
        return Objects.hash(this.allowTeamAccess, this.description, this.emailAddress, this.expiresAt, this.expiresIn, this.favourite, this.name, this.tags, this.useDomainPool);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateInboxDto {\n");
        sb.append("    allowTeamAccess: ").append(this.toIndentedString(this.allowTeamAccess)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    favourite: ").append(this.toIndentedString(this.favourite)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    useDomainPool: ").append(this.toIndentedString(this.useDomainPool)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

