/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import com.mailslurp.models.BasicAuthOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Options for creating a webhook. Webhooks can be attached to inboxes and MailSlurp will POST a webhook payload to the URL specified whenever the inbox receives an email. Webhooks are great for processing many inbound emails.")
public class CreateWebhookOptions {
    public static final String SERIALIZED_NAME_BASIC_AUTH = "basicAuth";
    @SerializedName(value="basicAuth")
    private BasicAuthOptions basicAuth;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;

    public CreateWebhookOptions basicAuth(BasicAuthOptions basicAuth) {
        this.basicAuth = basicAuth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public BasicAuthOptions getBasicAuth() {
        return this.basicAuth;
    }

    public void setBasicAuth(BasicAuthOptions basicAuth) {
        this.basicAuth = basicAuth;
    }

    public CreateWebhookOptions name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional name for the webhook")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateWebhookOptions url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Public URL on your server that MailSlurp can post WebhookNotification payload to when an email is received. The payload of the submitted JSON is described by https://api.mailslurp.com/schemas/webhook-payload")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateWebhookOptions createWebhookOptions = (CreateWebhookOptions)o;
        return Objects.equals(this.basicAuth, createWebhookOptions.basicAuth) && Objects.equals(this.name, createWebhookOptions.name) && Objects.equals(this.url, createWebhookOptions.url);
    }

    public int hashCode() {
        return Objects.hash(this.basicAuth, this.name, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateWebhookOptions {\n");
        sb.append("    basicAuth: ").append(this.toIndentedString(this.basicAuth)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

