/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Options for DNS query. ")
public class DNSLookupOptions {
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_OMIT_FINAL_D_N_S_DOT = "omitFinalDNSDot";
    @SerializedName(value="omitFinalDNSDot")
    private Boolean omitFinalDNSDot;
    public static final String SERIALIZED_NAME_RECORD_TYPES = "recordTypes";
    @SerializedName(value="recordTypes")
    private List<RecordTypesEnum> recordTypes = null;

    public DNSLookupOptions hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of record types you wish to query such as MX, DNS, TXT, NS, A etc.")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public DNSLookupOptions omitFinalDNSDot(Boolean omitFinalDNSDot) {
        this.omitFinalDNSDot = omitFinalDNSDot;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optionally control whether to omit the final dot in full DNS name values.")
    public Boolean getOmitFinalDNSDot() {
        return this.omitFinalDNSDot;
    }

    public void setOmitFinalDNSDot(Boolean omitFinalDNSDot) {
        this.omitFinalDNSDot = omitFinalDNSDot;
    }

    public DNSLookupOptions recordTypes(List<RecordTypesEnum> recordTypes) {
        this.recordTypes = recordTypes;
        return this;
    }

    public DNSLookupOptions addRecordTypesItem(RecordTypesEnum recordTypesItem) {
        if (this.recordTypes == null) {
            this.recordTypes = new ArrayList<RecordTypesEnum>();
        }
        this.recordTypes.add(recordTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of record types you wish to query such as MX, DNS, TXT, NS, A etc.")
    public List<RecordTypesEnum> getRecordTypes() {
        return this.recordTypes;
    }

    public void setRecordTypes(List<RecordTypesEnum> recordTypes) {
        this.recordTypes = recordTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSLookupOptions dnSLookupOptions = (DNSLookupOptions)o;
        return Objects.equals(this.hostname, dnSLookupOptions.hostname) && Objects.equals(this.omitFinalDNSDot, dnSLookupOptions.omitFinalDNSDot) && Objects.equals(this.recordTypes, dnSLookupOptions.recordTypes);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.omitFinalDNSDot, this.recordTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DNSLookupOptions {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    omitFinalDNSDot: ").append(this.toIndentedString(this.omitFinalDNSDot)).append("\n");
        sb.append("    recordTypes: ").append(this.toIndentedString(this.recordTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RecordTypesEnum {
        A("A"),
        NS("NS"),
        MD("MD"),
        MF("MF"),
        CNAME("CNAME"),
        SOA("SOA"),
        MB("MB"),
        MG("MG"),
        MR("MR"),
        NULL("NULL"),
        WKS("WKS"),
        PTR("PTR"),
        HINFO("HINFO"),
        MINFO("MINFO"),
        MX("MX"),
        TXT("TXT"),
        RP("RP"),
        AFSDB("AFSDB"),
        X25("X25"),
        ISDN("ISDN"),
        RT("RT"),
        NSAP("NSAP"),
        NSAP_PTR("NSAP_PTR"),
        SIG("SIG"),
        KEY("KEY"),
        PX("PX"),
        GPOS("GPOS"),
        AAAA("AAAA"),
        LOC("LOC"),
        NXT("NXT"),
        EID("EID"),
        NIMLOC("NIMLOC"),
        SRV("SRV"),
        ATMA("ATMA"),
        NAPTR("NAPTR"),
        KX("KX"),
        CERT("CERT"),
        A6("A6"),
        DNAME("DNAME"),
        SINK("SINK"),
        OPT("OPT"),
        APL("APL"),
        DS("DS"),
        SSHFP("SSHFP"),
        IPSECKEY("IPSECKEY"),
        RRSIG("RRSIG"),
        NSEC("NSEC"),
        DNSKEY("DNSKEY"),
        DHCID("DHCID"),
        NSEC3("NSEC3"),
        NSEC3PARAM("NSEC3PARAM"),
        TLSA("TLSA"),
        SMIMEA("SMIMEA"),
        HIP("HIP"),
        NINFO("NINFO"),
        RKEY("RKEY"),
        TALINK("TALINK"),
        CDS("CDS"),
        CDNSKEY("CDNSKEY"),
        OPENPGPKEY("OPENPGPKEY"),
        CSYNC("CSYNC"),
        ZONEMD("ZONEMD"),
        SVCB("SVCB"),
        HTTPS("HTTPS"),
        SPF("SPF"),
        UINFO("UINFO"),
        UID("UID"),
        GID("GID"),
        UNSPEC("UNSPEC"),
        NID("NID"),
        L32("L32"),
        L64("L64"),
        LP("LP"),
        EUI48("EUI48"),
        EUI64("EUI64"),
        TKEY("TKEY"),
        TSIG("TSIG"),
        IXFR("IXFR"),
        AXFR("AXFR"),
        MAILB("MAILB"),
        MAILA("MAILA"),
        ANY("ANY"),
        URI("URI"),
        CAA("CAA"),
        AVC("AVC"),
        DOA("DOA"),
        AMTRELAY("AMTRELAY"),
        TA("TA"),
        DLV("DLV");

        private String value;

        private RecordTypesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RecordTypesEnum fromValue(String value) {
            for (RecordTypesEnum b : RecordTypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RecordTypesEnum> {
            public void write(JsonWriter jsonWriter, RecordTypesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RecordTypesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RecordTypesEnum.fromValue(value);
            }
        }
    }
}

