/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DNS lookup result. Includes record type, time to live, raw response, and name value for the name server response.")
public class DNSLookupResult {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_RECORD_ENTRIES = "recordEntries";
    @SerializedName(value="recordEntries")
    private List<String> recordEntries = new ArrayList<String>();
    public static final String SERIALIZED_NAME_RECORD_TYPE = "recordType";
    @SerializedName(value="recordType")
    private RecordTypeEnum recordType;
    public static final String SERIALIZED_NAME_TTL = "ttl";
    @SerializedName(value="ttl")
    private Long ttl;

    public DNSLookupResult name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DNSLookupResult recordEntries(List<String> recordEntries) {
        this.recordEntries = recordEntries;
        return this;
    }

    public DNSLookupResult addRecordEntriesItem(String recordEntriesItem) {
        this.recordEntries.add(recordEntriesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<String> getRecordEntries() {
        return this.recordEntries;
    }

    public void setRecordEntries(List<String> recordEntries) {
        this.recordEntries = recordEntries;
    }

    public DNSLookupResult recordType(RecordTypeEnum recordType) {
        this.recordType = recordType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public RecordTypeEnum getRecordType() {
        return this.recordType;
    }

    public void setRecordType(RecordTypeEnum recordType) {
        this.recordType = recordType;
    }

    public DNSLookupResult ttl(Long ttl) {
        this.ttl = ttl;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Long getTtl() {
        return this.ttl;
    }

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSLookupResult dnSLookupResult = (DNSLookupResult)o;
        return Objects.equals(this.name, dnSLookupResult.name) && Objects.equals(this.recordEntries, dnSLookupResult.recordEntries) && Objects.equals((Object)this.recordType, (Object)dnSLookupResult.recordType) && Objects.equals(this.ttl, dnSLookupResult.ttl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.recordEntries, this.recordType, this.ttl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DNSLookupResult {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    recordEntries: ").append(this.toIndentedString(this.recordEntries)).append("\n");
        sb.append("    recordType: ").append(this.toIndentedString((Object)this.recordType)).append("\n");
        sb.append("    ttl: ").append(this.toIndentedString(this.ttl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RecordTypeEnum {
        A("A"),
        NS("NS"),
        MD("MD"),
        MF("MF"),
        CNAME("CNAME"),
        SOA("SOA"),
        MB("MB"),
        MG("MG"),
        MR("MR"),
        NULL("NULL"),
        WKS("WKS"),
        PTR("PTR"),
        HINFO("HINFO"),
        MINFO("MINFO"),
        MX("MX"),
        TXT("TXT"),
        RP("RP"),
        AFSDB("AFSDB"),
        X25("X25"),
        ISDN("ISDN"),
        RT("RT"),
        NSAP("NSAP"),
        NSAP_PTR("NSAP_PTR"),
        SIG("SIG"),
        KEY("KEY"),
        PX("PX"),
        GPOS("GPOS"),
        AAAA("AAAA"),
        LOC("LOC"),
        NXT("NXT"),
        EID("EID"),
        NIMLOC("NIMLOC"),
        SRV("SRV"),
        ATMA("ATMA"),
        NAPTR("NAPTR"),
        KX("KX"),
        CERT("CERT"),
        A6("A6"),
        DNAME("DNAME"),
        SINK("SINK"),
        OPT("OPT"),
        APL("APL"),
        DS("DS"),
        SSHFP("SSHFP"),
        IPSECKEY("IPSECKEY"),
        RRSIG("RRSIG"),
        NSEC("NSEC"),
        DNSKEY("DNSKEY"),
        DHCID("DHCID"),
        NSEC3("NSEC3"),
        NSEC3PARAM("NSEC3PARAM"),
        TLSA("TLSA"),
        SMIMEA("SMIMEA"),
        HIP("HIP"),
        NINFO("NINFO"),
        RKEY("RKEY"),
        TALINK("TALINK"),
        CDS("CDS"),
        CDNSKEY("CDNSKEY"),
        OPENPGPKEY("OPENPGPKEY"),
        CSYNC("CSYNC"),
        ZONEMD("ZONEMD"),
        SVCB("SVCB"),
        HTTPS("HTTPS"),
        SPF("SPF"),
        UINFO("UINFO"),
        UID("UID"),
        GID("GID"),
        UNSPEC("UNSPEC"),
        NID("NID"),
        L32("L32"),
        L64("L64"),
        LP("LP"),
        EUI48("EUI48"),
        EUI64("EUI64"),
        TKEY("TKEY"),
        TSIG("TSIG"),
        IXFR("IXFR"),
        AXFR("AXFR"),
        MAILB("MAILB"),
        MAILA("MAILA"),
        ANY("ANY"),
        URI("URI"),
        CAA("CAA"),
        AVC("AVC"),
        DOA("DOA"),
        AMTRELAY("AMTRELAY"),
        TA("TA"),
        DLV("DLV");

        private String value;

        private RecordTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RecordTypeEnum fromValue(String value) {
            for (RecordTypeEnum b : RecordTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<RecordTypeEnum> {
            public void write(JsonWriter jsonWriter, RecordTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RecordTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RecordTypeEnum.fromValue(value);
            }
        }
    }
}

