/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import com.mailslurp.models.DomainNameRecord;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="Domain plus verification records and status")
public class DomainDto {
    public static final String SERIALIZED_NAME_CATCH_ALL_INBOX_ID = "catchAllInboxId";
    @SerializedName(value="catchAllInboxId")
    private UUID catchAllInboxId;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_DKIM_TOKENS = "dkimTokens";
    @SerializedName(value="dkimTokens")
    private List<String> dkimTokens = null;
    public static final String SERIALIZED_NAME_DOMAIN = "domain";
    @SerializedName(value="domain")
    private String domain;
    public static final String SERIALIZED_NAME_DOMAIN_NAME_RECORDS = "domainNameRecords";
    @SerializedName(value="domainNameRecords")
    private List<DomainNameRecord> domainNameRecords = null;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_IS_VERIFIED = "isVerified";
    @SerializedName(value="isVerified")
    private Boolean isVerified;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_USER_ID = "userId";
    @SerializedName(value="userId")
    private UUID userId;
    public static final String SERIALIZED_NAME_VERIFICATION_TOKEN = "verificationToken";
    @SerializedName(value="verificationToken")
    private String verificationToken;

    public DomainDto catchAllInboxId(UUID catchAllInboxId) {
        this.catchAllInboxId = catchAllInboxId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The optional catch all inbox that will receive emails sent to the domain that cannot be matched.")
    public UUID getCatchAllInboxId() {
        return this.catchAllInboxId;
    }

    public void setCatchAllInboxId(UUID catchAllInboxId) {
        this.catchAllInboxId = catchAllInboxId;
    }

    public DomainDto createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public DomainDto dkimTokens(List<String> dkimTokens) {
        this.dkimTokens = dkimTokens;
        return this;
    }

    public DomainDto addDkimTokensItem(String dkimTokensItem) {
        if (this.dkimTokens == null) {
            this.dkimTokens = new ArrayList<String>();
        }
        this.dkimTokens.add(dkimTokensItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique token DKIM tokens")
    public List<String> getDkimTokens() {
        return this.dkimTokens;
    }

    public void setDkimTokens(List<String> dkimTokens) {
        this.dkimTokens = dkimTokens;
    }

    public DomainDto domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Custom domain name")
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public DomainDto domainNameRecords(List<DomainNameRecord> domainNameRecords) {
        this.domainNameRecords = domainNameRecords;
        return this;
    }

    public DomainDto addDomainNameRecordsItem(DomainNameRecord domainNameRecordsItem) {
        if (this.domainNameRecords == null) {
            this.domainNameRecords = new ArrayList<DomainNameRecord>();
        }
        this.domainNameRecords.add(domainNameRecordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of DNS domain name records (C, MX, TXT) etc that you must add to the DNS server associated with your domain provider.")
    public List<DomainNameRecord> getDomainNameRecords() {
        return this.domainNameRecords;
    }

    public void setDomainNameRecords(List<DomainNameRecord> domainNameRecords) {
        this.domainNameRecords = domainNameRecords;
    }

    public DomainDto id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public DomainDto isVerified(Boolean isVerified) {
        this.isVerified = isVerified;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether domain has been verified or not. If the domain is not verified after 72 hours there is most likely an issue with the domains DNS records.")
    public Boolean getIsVerified() {
        return this.isVerified;
    }

    public void setIsVerified(Boolean isVerified) {
        this.isVerified = isVerified;
    }

    public DomainDto updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public DomainDto userId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public UUID getUserId() {
        return this.userId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public DomainDto verificationToken(String verificationToken) {
        this.verificationToken = verificationToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Verification tokens")
    public String getVerificationToken() {
        return this.verificationToken;
    }

    public void setVerificationToken(String verificationToken) {
        this.verificationToken = verificationToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainDto domainDto = (DomainDto)o;
        return Objects.equals(this.catchAllInboxId, domainDto.catchAllInboxId) && Objects.equals(this.createdAt, domainDto.createdAt) && Objects.equals(this.dkimTokens, domainDto.dkimTokens) && Objects.equals(this.domain, domainDto.domain) && Objects.equals(this.domainNameRecords, domainDto.domainNameRecords) && Objects.equals(this.id, domainDto.id) && Objects.equals(this.isVerified, domainDto.isVerified) && Objects.equals(this.updatedAt, domainDto.updatedAt) && Objects.equals(this.userId, domainDto.userId) && Objects.equals(this.verificationToken, domainDto.verificationToken);
    }

    public int hashCode() {
        return Objects.hash(this.catchAllInboxId, this.createdAt, this.dkimTokens, this.domain, this.domainNameRecords, this.id, this.isVerified, this.updatedAt, this.userId, this.verificationToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DomainDto {\n");
        sb.append("    catchAllInboxId: ").append(this.toIndentedString(this.catchAllInboxId)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    dkimTokens: ").append(this.toIndentedString(this.dkimTokens)).append("\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    domainNameRecords: ").append(this.toIndentedString(this.domainNameRecords)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isVerified: ").append(this.toIndentedString(this.isVerified)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    verificationToken: ").append(this.toIndentedString(this.verificationToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

