/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Content of attachment")
public class DownloadAttachmentDto {
    public static final String SERIALIZED_NAME_BASE64_FILE_CONTENTS = "base64FileContents";
    @SerializedName(value="base64FileContents")
    private String base64FileContents;
    public static final String SERIALIZED_NAME_CONTENT_TYPE = "contentType";
    @SerializedName(value="contentType")
    private String contentType;
    public static final String SERIALIZED_NAME_SIZE_BYTES = "sizeBytes";
    @SerializedName(value="sizeBytes")
    private Long sizeBytes;

    public DownloadAttachmentDto base64FileContents(String base64FileContents) {
        this.base64FileContents = base64FileContents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base64 encoded string of attachment bytes. Decode the base64 string to get the raw file bytes")
    public String getBase64FileContents() {
        return this.base64FileContents;
    }

    public void setBase64FileContents(String base64FileContents) {
        this.base64FileContents = base64FileContents;
    }

    public DownloadAttachmentDto contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Content type of attachment")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public DownloadAttachmentDto sizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Size in bytes of attachment")
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadAttachmentDto downloadAttachmentDto = (DownloadAttachmentDto)o;
        return Objects.equals(this.base64FileContents, downloadAttachmentDto.base64FileContents) && Objects.equals(this.contentType, downloadAttachmentDto.contentType) && Objects.equals(this.sizeBytes, downloadAttachmentDto.sizeBytes);
    }

    public int hashCode() {
        return Objects.hash(this.base64FileContents, this.contentType, this.sizeBytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DownloadAttachmentDto {\n");
        sb.append("    base64FileContents: ").append(this.toIndentedString(this.base64FileContents)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    sizeBytes: ").append(this.toIndentedString(this.sizeBytes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

