/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import com.mailslurp.models.EmailAnalysis;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="Email model (also referred to as EmailDto). Represents an email that was received by an inbox. If you want the original SMTP message see the `getRawEmail` endpoint.")
public class Email {
    public static final String SERIALIZED_NAME_ANALYSIS = "analysis";
    @SerializedName(value="analysis")
    private EmailAnalysis analysis;
    public static final String SERIALIZED_NAME_ATTACHMENTS = "attachments";
    @SerializedName(value="attachments")
    private List<String> attachments = null;
    public static final String SERIALIZED_NAME_BCC = "bcc";
    @SerializedName(value="bcc")
    private List<String> bcc = null;
    public static final String SERIALIZED_NAME_BODY = "body";
    @SerializedName(value="body")
    private String body;
    public static final String SERIALIZED_NAME_BODY_M_D5_HASH = "bodyMD5Hash";
    @SerializedName(value="bodyMD5Hash")
    private String bodyMD5Hash;
    public static final String SERIALIZED_NAME_CC = "cc";
    @SerializedName(value="cc")
    private List<String> cc = null;
    public static final String SERIALIZED_NAME_CHARSET = "charset";
    @SerializedName(value="charset")
    private String charset;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private String from;
    public static final String SERIALIZED_NAME_HEADERS = "headers";
    @SerializedName(value="headers")
    private Map<String, String> headers = null;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_INBOX_ID = "inboxId";
    @SerializedName(value="inboxId")
    private UUID inboxId;
    public static final String SERIALIZED_NAME_IS_H_T_M_L = "isHTML";
    @SerializedName(value="isHTML")
    private Boolean isHTML;
    public static final String SERIALIZED_NAME_READ = "read";
    @SerializedName(value="read")
    private Boolean read;
    public static final String SERIALIZED_NAME_REPLY_TO = "replyTo";
    @SerializedName(value="replyTo")
    private String replyTo;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;
    public static final String SERIALIZED_NAME_TEAM_ACCESS = "teamAccess";
    @SerializedName(value="teamAccess")
    private Boolean teamAccess;
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private List<String> to = null;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_USER_ID = "userId";
    @SerializedName(value="userId")
    private UUID userId;

    public Email analysis(EmailAnalysis analysis) {
        this.analysis = analysis;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EmailAnalysis getAnalysis() {
        return this.analysis;
    }

    public void setAnalysis(EmailAnalysis analysis) {
        this.analysis = analysis;
    }

    public Email attachments(List<String> attachments) {
        this.attachments = attachments;
        return this;
    }

    public Email addAttachmentsItem(String attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<String>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of IDs of attachments found in the email. Use these IDs with the Inbox and Email Controllers to download attachments and attachment meta data such as filesize, name, extension.")
    public List<String> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<String> attachments) {
        this.attachments = attachments;
    }

    public Email bcc(List<String> bcc) {
        this.bcc = bcc;
        return this;
    }

    public Email addBccItem(String bccItem) {
        if (this.bcc == null) {
            this.bcc = new ArrayList<String>();
        }
        this.bcc.add(bccItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of `BCC` recipients email was addressed to")
    public List<String> getBcc() {
        return this.bcc;
    }

    public void setBcc(List<String> bcc) {
        this.bcc = bcc;
    }

    public Email body(String body) {
        this.body = body;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The body of the email message")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Email bodyMD5Hash(String bodyMD5Hash) {
        this.bodyMD5Hash = bodyMD5Hash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A hash signature of the email message")
    public String getBodyMD5Hash() {
        return this.bodyMD5Hash;
    }

    public void setBodyMD5Hash(String bodyMD5Hash) {
        this.bodyMD5Hash = bodyMD5Hash;
    }

    public Email cc(List<String> cc) {
        this.cc = cc;
        return this;
    }

    public Email addCcItem(String ccItem) {
        if (this.cc == null) {
            this.cc = new ArrayList<String>();
        }
        this.cc.add(ccItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of `CC` recipients email was addressed to")
    public List<String> getCc() {
        return this.cc;
    }

    public void setCc(List<String> cc) {
        this.cc = cc;
    }

    public Email charset(String charset) {
        this.charset = charset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Detected character set of the email body such as UTF-8")
    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Email createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When was the email received by MailSlurp")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Email from(String from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Who the email was sent from")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Email headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public Email putHeadersItem(String key, String headersItem) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, headersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Email id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the email")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Email inboxId(UUID inboxId) {
        this.inboxId = inboxId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the inbox that received the email")
    public UUID getInboxId() {
        return this.inboxId;
    }

    public void setInboxId(UUID inboxId) {
        this.inboxId = inboxId;
    }

    public Email isHTML(Boolean isHTML) {
        this.isHTML = isHTML;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Was HTML sent in the email body")
    public Boolean getIsHTML() {
        return this.isHTML;
    }

    public void setIsHTML(Boolean isHTML) {
        this.isHTML = isHTML;
    }

    public Email read(Boolean read) {
        this.read = read;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Has the email been viewed ever. This means viewed in the dashboard or requested via the full email entity endpoints")
    public Boolean getRead() {
        return this.read;
    }

    public void setRead(Boolean read) {
        this.read = read;
    }

    public Email replyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The replyTo field on the received email")
    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public Email subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The subject line of the email message")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Email teamAccess(Boolean teamAccess) {
        this.teamAccess = teamAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Can the email be accessed by organization team members")
    public Boolean getTeamAccess() {
        return this.teamAccess;
    }

    public void setTeamAccess(Boolean teamAccess) {
        this.teamAccess = teamAccess;
    }

    public Email to(List<String> to) {
        this.to = to;
        return this;
    }

    public Email addToItem(String toItem) {
        if (this.to == null) {
            this.to = new ArrayList<String>();
        }
        this.to.add(toItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of `To` recipients email was addressed to")
    public List<String> getTo() {
        return this.to;
    }

    public void setTo(List<String> to) {
        this.to = to;
    }

    public Email updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When was the email last updated")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Email userId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of user that email belongs")
    public UUID getUserId() {
        return this.userId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Email email = (Email)o;
        return Objects.equals(this.analysis, email.analysis) && Objects.equals(this.attachments, email.attachments) && Objects.equals(this.bcc, email.bcc) && Objects.equals(this.body, email.body) && Objects.equals(this.bodyMD5Hash, email.bodyMD5Hash) && Objects.equals(this.cc, email.cc) && Objects.equals(this.charset, email.charset) && Objects.equals(this.createdAt, email.createdAt) && Objects.equals(this.from, email.from) && Objects.equals(this.headers, email.headers) && Objects.equals(this.id, email.id) && Objects.equals(this.inboxId, email.inboxId) && Objects.equals(this.isHTML, email.isHTML) && Objects.equals(this.read, email.read) && Objects.equals(this.replyTo, email.replyTo) && Objects.equals(this.subject, email.subject) && Objects.equals(this.teamAccess, email.teamAccess) && Objects.equals(this.to, email.to) && Objects.equals(this.updatedAt, email.updatedAt) && Objects.equals(this.userId, email.userId);
    }

    public int hashCode() {
        return Objects.hash(this.analysis, this.attachments, this.bcc, this.body, this.bodyMD5Hash, this.cc, this.charset, this.createdAt, this.from, this.headers, this.id, this.inboxId, this.isHTML, this.read, this.replyTo, this.subject, this.teamAccess, this.to, this.updatedAt, this.userId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Email {\n");
        sb.append("    analysis: ").append(this.toIndentedString(this.analysis)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    bcc: ").append(this.toIndentedString(this.bcc)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    bodyMD5Hash: ").append(this.toIndentedString(this.bodyMD5Hash)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    charset: ").append(this.toIndentedString(this.charset)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    inboxId: ").append(this.toIndentedString(this.inboxId)).append("\n");
        sb.append("    isHTML: ").append(this.toIndentedString(this.isHTML)).append("\n");
        sb.append("    read: ").append(this.toIndentedString(this.read)).append("\n");
        sb.append("    replyTo: ").append(this.toIndentedString(this.replyTo)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    teamAccess: ").append(this.toIndentedString(this.teamAccess)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

