/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Analysis result for email. Each verdict property is a string PASS|FAIL|GRAY or dynamic error message")
public class EmailAnalysis {
    public static final String SERIALIZED_NAME_DKIM_VERDICT = "dkimVerdict";
    @SerializedName(value="dkimVerdict")
    private String dkimVerdict;
    public static final String SERIALIZED_NAME_DMARC_VERDICT = "dmarcVerdict";
    @SerializedName(value="dmarcVerdict")
    private String dmarcVerdict;
    public static final String SERIALIZED_NAME_SPAM_VERDICT = "spamVerdict";
    @SerializedName(value="spamVerdict")
    private String spamVerdict;
    public static final String SERIALIZED_NAME_SPF_VERDICT = "spfVerdict";
    @SerializedName(value="spfVerdict")
    private String spfVerdict;
    public static final String SERIALIZED_NAME_VIRUS_VERDICT = "virusVerdict";
    @SerializedName(value="virusVerdict")
    private String virusVerdict;

    public EmailAnalysis dkimVerdict(String dkimVerdict) {
        this.dkimVerdict = dkimVerdict;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Verdict of DomainKeys Identified Mail analysis")
    public String getDkimVerdict() {
        return this.dkimVerdict;
    }

    public void setDkimVerdict(String dkimVerdict) {
        this.dkimVerdict = dkimVerdict;
    }

    public EmailAnalysis dmarcVerdict(String dmarcVerdict) {
        this.dmarcVerdict = dmarcVerdict;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Verdict of Domain-based Message Authentication Reporting and Conformance analysis")
    public String getDmarcVerdict() {
        return this.dmarcVerdict;
    }

    public void setDmarcVerdict(String dmarcVerdict) {
        this.dmarcVerdict = dmarcVerdict;
    }

    public EmailAnalysis spamVerdict(String spamVerdict) {
        this.spamVerdict = spamVerdict;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Verdict of spam ranking analysis")
    public String getSpamVerdict() {
        return this.spamVerdict;
    }

    public void setSpamVerdict(String spamVerdict) {
        this.spamVerdict = spamVerdict;
    }

    public EmailAnalysis spfVerdict(String spfVerdict) {
        this.spfVerdict = spfVerdict;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Verdict of Send Policy Framework record spoofing analysis")
    public String getSpfVerdict() {
        return this.spfVerdict;
    }

    public void setSpfVerdict(String spfVerdict) {
        this.spfVerdict = spfVerdict;
    }

    public EmailAnalysis virusVerdict(String virusVerdict) {
        this.virusVerdict = virusVerdict;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Verdict of virus scan analysis")
    public String getVirusVerdict() {
        return this.virusVerdict;
    }

    public void setVirusVerdict(String virusVerdict) {
        this.virusVerdict = virusVerdict;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailAnalysis emailAnalysis = (EmailAnalysis)o;
        return Objects.equals(this.dkimVerdict, emailAnalysis.dkimVerdict) && Objects.equals(this.dmarcVerdict, emailAnalysis.dmarcVerdict) && Objects.equals(this.spamVerdict, emailAnalysis.spamVerdict) && Objects.equals(this.spfVerdict, emailAnalysis.spfVerdict) && Objects.equals(this.virusVerdict, emailAnalysis.virusVerdict);
    }

    public int hashCode() {
        return Objects.hash(this.dkimVerdict, this.dmarcVerdict, this.spamVerdict, this.spfVerdict, this.virusVerdict);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailAnalysis {\n");
        sb.append("    dkimVerdict: ").append(this.toIndentedString(this.dkimVerdict)).append("\n");
        sb.append("    dmarcVerdict: ").append(this.toIndentedString(this.dmarcVerdict)).append("\n");
        sb.append("    spamVerdict: ").append(this.toIndentedString(this.spamVerdict)).append("\n");
        sb.append("    spfVerdict: ").append(this.toIndentedString(this.spfVerdict)).append("\n");
        sb.append("    virusVerdict: ").append(this.toIndentedString(this.virusVerdict)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

