/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="Preview of an email message. For full message (including body and attachments) call the `getEmail` or other email endpoints with the provided email ID.")
public class EmailPreview {
    public static final String SERIALIZED_NAME_ATTACHMENTS = "attachments";
    @SerializedName(value="attachments")
    private List<String> attachments = null;
    public static final String SERIALIZED_NAME_BCC = "bcc";
    @SerializedName(value="bcc")
    private List<String> bcc = null;
    public static final String SERIALIZED_NAME_CC = "cc";
    @SerializedName(value="cc")
    private List<String> cc = null;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private String from;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_READ = "read";
    @SerializedName(value="read")
    private Boolean read;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private List<String> to = null;

    public EmailPreview attachments(List<String> attachments) {
        this.attachments = attachments;
        return this;
    }

    public EmailPreview addAttachmentsItem(String attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<String>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of IDs of attachments found in the email. Use these IDs with the Inbox and Email Controllers to download attachments and attachment meta data such as filesize, name, extension.")
    public List<String> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<String> attachments) {
        this.attachments = attachments;
    }

    public EmailPreview bcc(List<String> bcc) {
        this.bcc = bcc;
        return this;
    }

    public EmailPreview addBccItem(String bccItem) {
        if (this.bcc == null) {
            this.bcc = new ArrayList<String>();
        }
        this.bcc.add(bccItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of `BCC` recipients email was addressed to")
    public List<String> getBcc() {
        return this.bcc;
    }

    public void setBcc(List<String> bcc) {
        this.bcc = bcc;
    }

    public EmailPreview cc(List<String> cc) {
        this.cc = cc;
        return this;
    }

    public EmailPreview addCcItem(String ccItem) {
        if (this.cc == null) {
            this.cc = new ArrayList<String>();
        }
        this.cc.add(ccItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of `CC` recipients email was addressed to")
    public List<String> getCc() {
        return this.cc;
    }

    public void setCc(List<String> cc) {
        this.cc = cc;
    }

    public EmailPreview createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When was the email received by MailSlurp")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public EmailPreview from(String from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Who the email was sent from")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public EmailPreview id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the email")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public EmailPreview read(Boolean read) {
        this.read = read;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Has the email been viewed ever. This means viewed in the dashboard or requested via the full email entity endpoints")
    public Boolean getRead() {
        return this.read;
    }

    public void setRead(Boolean read) {
        this.read = read;
    }

    public EmailPreview subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The subject line of the email message")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EmailPreview to(List<String> to) {
        this.to = to;
        return this;
    }

    public EmailPreview addToItem(String toItem) {
        if (this.to == null) {
            this.to = new ArrayList<String>();
        }
        this.to.add(toItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of `To` recipients email was addressed to")
    public List<String> getTo() {
        return this.to;
    }

    public void setTo(List<String> to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailPreview emailPreview = (EmailPreview)o;
        return Objects.equals(this.attachments, emailPreview.attachments) && Objects.equals(this.bcc, emailPreview.bcc) && Objects.equals(this.cc, emailPreview.cc) && Objects.equals(this.createdAt, emailPreview.createdAt) && Objects.equals(this.from, emailPreview.from) && Objects.equals(this.id, emailPreview.id) && Objects.equals(this.read, emailPreview.read) && Objects.equals(this.subject, emailPreview.subject) && Objects.equals(this.to, emailPreview.to);
    }

    public int hashCode() {
        return Objects.hash(this.attachments, this.bcc, this.cc, this.createdAt, this.from, this.id, this.read, this.subject, this.to);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailPreview {\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    bcc: ").append(this.toIndentedString(this.bcc)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    read: ").append(this.toIndentedString(this.read)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

