/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="A compact representation of a full email. Used in list endpoints to keep response sizes low. Body and attachments are not included. To get all fields of the email use the `getEmail` method with the email projection's ID. See `EmailDto` for documentation on projection properties.")
public class EmailProjection {
    public static final String SERIALIZED_NAME_ATTACHMENTS = "attachments";
    @SerializedName(value="attachments")
    private List<String> attachments = null;
    public static final String SERIALIZED_NAME_BCC = "bcc";
    @SerializedName(value="bcc")
    private List<String> bcc = null;
    public static final String SERIALIZED_NAME_BODY_M_D5_HASH = "bodyMD5Hash";
    @SerializedName(value="bodyMD5Hash")
    private String bodyMD5Hash;
    public static final String SERIALIZED_NAME_CC = "cc";
    @SerializedName(value="cc")
    private List<String> cc = null;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private String from;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_INBOX_ID = "inboxId";
    @SerializedName(value="inboxId")
    private UUID inboxId;
    public static final String SERIALIZED_NAME_READ = "read";
    @SerializedName(value="read")
    private Boolean read;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;
    public static final String SERIALIZED_NAME_TEAM_ACCESS = "teamAccess";
    @SerializedName(value="teamAccess")
    private Boolean teamAccess;
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private List<String> to = new ArrayList<String>();

    public EmailProjection attachments(List<String> attachments) {
        this.attachments = attachments;
        return this;
    }

    public EmailProjection addAttachmentsItem(String attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<String>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<String> attachments) {
        this.attachments = attachments;
    }

    public EmailProjection bcc(List<String> bcc) {
        this.bcc = bcc;
        return this;
    }

    public EmailProjection addBccItem(String bccItem) {
        if (this.bcc == null) {
            this.bcc = new ArrayList<String>();
        }
        this.bcc.add(bccItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getBcc() {
        return this.bcc;
    }

    public void setBcc(List<String> bcc) {
        this.bcc = bcc;
    }

    public EmailProjection bodyMD5Hash(String bodyMD5Hash) {
        this.bodyMD5Hash = bodyMD5Hash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getBodyMD5Hash() {
        return this.bodyMD5Hash;
    }

    public void setBodyMD5Hash(String bodyMD5Hash) {
        this.bodyMD5Hash = bodyMD5Hash;
    }

    public EmailProjection cc(List<String> cc) {
        this.cc = cc;
        return this;
    }

    public EmailProjection addCcItem(String ccItem) {
        if (this.cc == null) {
            this.cc = new ArrayList<String>();
        }
        this.cc.add(ccItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getCc() {
        return this.cc;
    }

    public void setCc(List<String> cc) {
        this.cc = cc;
    }

    public EmailProjection createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public EmailProjection from(String from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public EmailProjection id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public EmailProjection inboxId(UUID inboxId) {
        this.inboxId = inboxId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public UUID getInboxId() {
        return this.inboxId;
    }

    public void setInboxId(UUID inboxId) {
        this.inboxId = inboxId;
    }

    public EmailProjection read(Boolean read) {
        this.read = read;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getRead() {
        return this.read;
    }

    public void setRead(Boolean read) {
        this.read = read;
    }

    public EmailProjection subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EmailProjection teamAccess(Boolean teamAccess) {
        this.teamAccess = teamAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getTeamAccess() {
        return this.teamAccess;
    }

    public void setTeamAccess(Boolean teamAccess) {
        this.teamAccess = teamAccess;
    }

    public EmailProjection to(List<String> to) {
        this.to = to;
        return this;
    }

    public EmailProjection addToItem(String toItem) {
        this.to.add(toItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<String> getTo() {
        return this.to;
    }

    public void setTo(List<String> to) {
        this.to = to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailProjection emailProjection = (EmailProjection)o;
        return Objects.equals(this.attachments, emailProjection.attachments) && Objects.equals(this.bcc, emailProjection.bcc) && Objects.equals(this.bodyMD5Hash, emailProjection.bodyMD5Hash) && Objects.equals(this.cc, emailProjection.cc) && Objects.equals(this.createdAt, emailProjection.createdAt) && Objects.equals(this.from, emailProjection.from) && Objects.equals(this.id, emailProjection.id) && Objects.equals(this.inboxId, emailProjection.inboxId) && Objects.equals(this.read, emailProjection.read) && Objects.equals(this.subject, emailProjection.subject) && Objects.equals(this.teamAccess, emailProjection.teamAccess) && Objects.equals(this.to, emailProjection.to);
    }

    public int hashCode() {
        return Objects.hash(this.attachments, this.bcc, this.bodyMD5Hash, this.cc, this.createdAt, this.from, this.id, this.inboxId, this.read, this.subject, this.teamAccess, this.to);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailProjection {\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    bcc: ").append(this.toIndentedString(this.bcc)).append("\n");
        sb.append("    bodyMD5Hash: ").append(this.toIndentedString(this.bodyMD5Hash)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    inboxId: ").append(this.toIndentedString(this.inboxId)).append("\n");
        sb.append("    read: ").append(this.toIndentedString(this.read)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    teamAccess: ").append(this.toIndentedString(this.teamAccess)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

