/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import com.mailslurp.models.ValidationMessage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="HTML Validation Results")
public class HTMLValidationResult {
    public static final String SERIALIZED_NAME_ERRORS = "errors";
    @SerializedName(value="errors")
    private List<ValidationMessage> errors = null;
    public static final String SERIALIZED_NAME_IS_VALID = "isValid";
    @SerializedName(value="isValid")
    private Boolean isValid;
    public static final String SERIALIZED_NAME_WARNINGS = "warnings";
    @SerializedName(value="warnings")
    private List<ValidationMessage> warnings = null;

    public HTMLValidationResult errors(List<ValidationMessage> errors) {
        this.errors = errors;
        return this;
    }

    public HTMLValidationResult addErrorsItem(ValidationMessage errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<ValidationMessage>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional errors resulting from HTML validation")
    public List<ValidationMessage> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ValidationMessage> errors) {
        this.errors = errors;
    }

    public HTMLValidationResult isValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Is HTML validation result valid")
    public Boolean getIsValid() {
        return this.isValid;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    public HTMLValidationResult warnings(List<ValidationMessage> warnings) {
        this.warnings = warnings;
        return this;
    }

    public HTMLValidationResult addWarningsItem(ValidationMessage warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<ValidationMessage>();
        }
        this.warnings.add(warningsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional warnings resulting from HTML validation")
    public List<ValidationMessage> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<ValidationMessage> warnings) {
        this.warnings = warnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTMLValidationResult htMLValidationResult = (HTMLValidationResult)o;
        return Objects.equals(this.errors, htMLValidationResult.errors) && Objects.equals(this.isValid, htMLValidationResult.isValid) && Objects.equals(this.warnings, htMLValidationResult.warnings);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.isValid, this.warnings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HTMLValidationResult {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    isValid: ").append(this.toIndentedString(this.isValid)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

