/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Options for matching emails in an inbox. Each match option object contains a `field`, `should` and `value` property. Together they form logical conditions such as `SUBJECT` should `CONTAIN` value.")
public class MatchOption {
    public static final String SERIALIZED_NAME_FIELD = "field";
    @SerializedName(value="field")
    private FieldEnum field;
    public static final String SERIALIZED_NAME_SHOULD = "should";
    @SerializedName(value="should")
    private ShouldEnum should;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;

    public MatchOption field(FieldEnum field) {
        this.field = field;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The email property to match on. One of SUBJECT, TO, BCC, CC or FROM")
    public FieldEnum getField() {
        return this.field;
    }

    public void setField(FieldEnum field) {
        this.field = field;
    }

    public MatchOption should(ShouldEnum should) {
        this.should = should;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="What criteria to apply. CONTAIN or EQUAL. Note CONTAIN is recommended due to some SMTP servers adding new lines to fields and body content.")
    public ShouldEnum getShould() {
        return this.should;
    }

    public void setShould(ShouldEnum should) {
        this.should = should;
    }

    public MatchOption value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The value you wish to compare with the value of the field specified using the `should` value passed. For example `BODY` should `CONTAIN` a value passed.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchOption matchOption = (MatchOption)o;
        return Objects.equals((Object)this.field, (Object)matchOption.field) && Objects.equals((Object)this.should, (Object)matchOption.should) && Objects.equals(this.value, matchOption.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.should, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MatchOption {\n");
        sb.append("    field: ").append(this.toIndentedString((Object)this.field)).append("\n");
        sb.append("    should: ").append(this.toIndentedString((Object)this.should)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ShouldEnum {
        CONTAIN("CONTAIN"),
        EQUAL("EQUAL");

        private String value;

        private ShouldEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ShouldEnum fromValue(String value) {
            for (ShouldEnum b : ShouldEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ShouldEnum> {
            public void write(JsonWriter jsonWriter, ShouldEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ShouldEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ShouldEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FieldEnum {
        SUBJECT("SUBJECT"),
        TO("TO"),
        BCC("BCC"),
        CC("CC"),
        FROM("FROM");

        private String value;

        private FieldEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FieldEnum fromValue(String value) {
            for (FieldEnum b : FieldEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FieldEnum> {
            public void write(JsonWriter jsonWriter, FieldEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FieldEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FieldEnum.fromValue(value);
            }
        }
    }
}

