/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import com.mailslurp.models.MatchOption;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Optional filter for matching emails based on fields. For instance filter results to only include emails whose `SUBJECT` value does `CONTAIN` given match value. An example payload would be `{ matches: [{ field: 'SUBJECT', should: 'CONTAIN', value: 'Welcome' }] }`. If you wish to extract regex matches inside the email content see the `getEmailContentMatch` method in the EmailController.")
public class MatchOptions {
    public static final String SERIALIZED_NAME_MATCHES = "matches";
    @SerializedName(value="matches")
    private List<MatchOption> matches = null;

    public MatchOptions matches(List<MatchOption> matches) {
        this.matches = matches;
        return this;
    }

    public MatchOptions addMatchesItem(MatchOption matchesItem) {
        if (this.matches == null) {
            this.matches = new ArrayList<MatchOption>();
        }
        this.matches.add(matchesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="1 or more match options. Options are additive so if one does not match the email is excluded from results")
    public List<MatchOption> getMatches() {
        return this.matches;
    }

    public void setMatches(List<MatchOption> matches) {
        this.matches = matches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchOptions matchOptions = (MatchOptions)o;
        return Objects.equals(this.matches, matchOptions.matches);
    }

    public int hashCode() {
        return Objects.hash(this.matches);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MatchOptions {\n");
        sb.append("    matches: ").append(this.toIndentedString(this.matches)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

