/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

public class OrganizationInboxProjection {
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "emailAddress";
    @SerializedName(value="emailAddress")
    private String emailAddress;
    public static final String SERIALIZED_NAME_FAVOURITE = "favourite";
    @SerializedName(value="favourite")
    private Boolean favourite;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;
    public static final String SERIALIZED_NAME_TEAM_ACCESS = "teamAccess";
    @SerializedName(value="teamAccess")
    private Boolean teamAccess;

    public OrganizationInboxProjection createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When the inbox was created. Time stamps are in ISO DateTime Format `yyyy-MM-dd'T'HH:mm:ss.SSSXXX` e.g. `2000-10-31T01:30:00.000-05:00`.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public OrganizationInboxProjection emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The inbox's email address. Inbox projections and previews may not include the email address. To view the email address fetch the inbox entity directly. Send an email to this address and the inbox will receive and store it for you. Note the email address in MailSlurp match characters exactly and are case sensitive so `+123` additions are considered different addresses. To retrieve the email use the Inbox and Email Controller endpoints with the inbox ID.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public OrganizationInboxProjection favourite(Boolean favourite) {
        this.favourite = favourite;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Is the inbox favorited. Favouriting inboxes is typically done in the dashboard for quick access or filtering")
    public Boolean getFavourite() {
        return this.favourite;
    }

    public void setFavourite(Boolean favourite) {
        this.favourite = favourite;
    }

    public OrganizationInboxProjection id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the inbox. The ID is a UUID-V4 format string. Use the inboxId for calls to Inbox and Email Controller endpoints. See the emailAddress property for the email address or the inbox. To get emails in an inbox use the WaitFor and Inbox Controller methods `waitForLatestEmail` and `getEmails` methods respectively. Inboxes can be used with aliases to forward emails automatically.")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public OrganizationInboxProjection name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the inbox. Displayed in the dashboard for easier search")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OrganizationInboxProjection readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Is the inbox readOnly for the caller. Read only means can not be deleted or modified.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public OrganizationInboxProjection tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public OrganizationInboxProjection addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public OrganizationInboxProjection teamAccess(Boolean teamAccess) {
        this.teamAccess = teamAccess;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Does inbox permit team access for organization team members. If so team users can use inbox and emails associated with it.")
    public Boolean getTeamAccess() {
        return this.teamAccess;
    }

    public void setTeamAccess(Boolean teamAccess) {
        this.teamAccess = teamAccess;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrganizationInboxProjection organizationInboxProjection = (OrganizationInboxProjection)o;
        return Objects.equals(this.createdAt, organizationInboxProjection.createdAt) && Objects.equals(this.emailAddress, organizationInboxProjection.emailAddress) && Objects.equals(this.favourite, organizationInboxProjection.favourite) && Objects.equals(this.id, organizationInboxProjection.id) && Objects.equals(this.name, organizationInboxProjection.name) && Objects.equals(this.readOnly, organizationInboxProjection.readOnly) && Objects.equals(this.tags, organizationInboxProjection.tags) && Objects.equals(this.teamAccess, organizationInboxProjection.teamAccess);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.emailAddress, this.favourite, this.id, this.name, this.readOnly, this.tags, this.teamAccess);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrganizationInboxProjection {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    favourite: ").append(this.toIndentedString(this.favourite)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    teamAccess: ").append(this.toIndentedString(this.teamAccess)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

