/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="Options for replying to an alias email using the alias inbox")
public class ReplyToAliasEmailOptions {
    public static final String SERIALIZED_NAME_ATTACHMENTS = "attachments";
    @SerializedName(value="attachments")
    private List<String> attachments = null;
    public static final String SERIALIZED_NAME_BODY = "body";
    @SerializedName(value="body")
    private String body;
    public static final String SERIALIZED_NAME_CHARSET = "charset";
    @SerializedName(value="charset")
    private String charset;
    public static final String SERIALIZED_NAME_IS_H_T_M_L = "isHTML";
    @SerializedName(value="isHTML")
    private Boolean isHTML;
    public static final String SERIALIZED_NAME_SEND_STRATEGY = "sendStrategy";
    @SerializedName(value="sendStrategy")
    private SendStrategyEnum sendStrategy;
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    private UUID template;
    public static final String SERIALIZED_NAME_TEMPLATE_VARIABLES = "templateVariables";
    @SerializedName(value="templateVariables")
    private Object templateVariables;

    public ReplyToAliasEmailOptions attachments(List<String> attachments) {
        this.attachments = attachments;
        return this;
    }

    public ReplyToAliasEmailOptions addAttachmentsItem(String attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<String>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of uploaded attachments to send with the reply. Optional.")
    public List<String> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<String> attachments) {
        this.attachments = attachments;
    }

    public ReplyToAliasEmailOptions body(String body) {
        this.body = body;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Body of the reply email you want to send")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public ReplyToAliasEmailOptions charset(String charset) {
        this.charset = charset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The charset that your message should be sent with. Optional. Default is UTF-8")
    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public ReplyToAliasEmailOptions isHTML(Boolean isHTML) {
        this.isHTML = isHTML;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Is the reply HTML")
    public Boolean getIsHTML() {
        return this.isHTML;
    }

    public void setIsHTML(Boolean isHTML) {
        this.isHTML = isHTML;
    }

    public ReplyToAliasEmailOptions sendStrategy(SendStrategyEnum sendStrategy) {
        this.sendStrategy = sendStrategy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When to send the email. Typically immediately")
    public SendStrategyEnum getSendStrategy() {
        return this.sendStrategy;
    }

    public void setSendStrategy(SendStrategyEnum sendStrategy) {
        this.sendStrategy = sendStrategy;
    }

    public ReplyToAliasEmailOptions template(UUID template) {
        this.template = template;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Template ID to use instead of body. Will use template variable map to fill defined variable slots.")
    public UUID getTemplate() {
        return this.template;
    }

    public void setTemplate(UUID template) {
        this.template = template;
    }

    public ReplyToAliasEmailOptions templateVariables(Object templateVariables) {
        this.templateVariables = templateVariables;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Template variables if using a template")
    public Object getTemplateVariables() {
        return this.templateVariables;
    }

    public void setTemplateVariables(Object templateVariables) {
        this.templateVariables = templateVariables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplyToAliasEmailOptions replyToAliasEmailOptions = (ReplyToAliasEmailOptions)o;
        return Objects.equals(this.attachments, replyToAliasEmailOptions.attachments) && Objects.equals(this.body, replyToAliasEmailOptions.body) && Objects.equals(this.charset, replyToAliasEmailOptions.charset) && Objects.equals(this.isHTML, replyToAliasEmailOptions.isHTML) && Objects.equals((Object)this.sendStrategy, (Object)replyToAliasEmailOptions.sendStrategy) && Objects.equals(this.template, replyToAliasEmailOptions.template) && Objects.equals(this.templateVariables, replyToAliasEmailOptions.templateVariables);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attachments, this.body, this.charset, this.isHTML, this.sendStrategy, this.template, this.templateVariables});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReplyToAliasEmailOptions {\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    charset: ").append(this.toIndentedString(this.charset)).append("\n");
        sb.append("    isHTML: ").append(this.toIndentedString(this.isHTML)).append("\n");
        sb.append("    sendStrategy: ").append(this.toIndentedString((Object)this.sendStrategy)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    templateVariables: ").append(this.toIndentedString(this.templateVariables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SendStrategyEnum {
        SINGLE_MESSAGE("SINGLE_MESSAGE");

        private String value;

        private SendStrategyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SendStrategyEnum fromValue(String value) {
            for (SendStrategyEnum b : SendStrategyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SendStrategyEnum> {
            public void write(JsonWriter jsonWriter, SendStrategyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SendStrategyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SendStrategyEnum.fromValue(value);
            }
        }
    }
}

