/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="Options for replying to email with API")
public class ReplyToEmailOptions {
    public static final String SERIALIZED_NAME_ATTACHMENTS = "attachments";
    @SerializedName(value="attachments")
    private List<String> attachments = null;
    public static final String SERIALIZED_NAME_BODY = "body";
    @SerializedName(value="body")
    private String body;
    public static final String SERIALIZED_NAME_CHARSET = "charset";
    @SerializedName(value="charset")
    private String charset;
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private String from;
    public static final String SERIALIZED_NAME_IS_H_T_M_L = "isHTML";
    @SerializedName(value="isHTML")
    private Boolean isHTML;
    public static final String SERIALIZED_NAME_REPLY_TO = "replyTo";
    @SerializedName(value="replyTo")
    private String replyTo;
    public static final String SERIALIZED_NAME_SEND_STRATEGY = "sendStrategy";
    @SerializedName(value="sendStrategy")
    private SendStrategyEnum sendStrategy;
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    private UUID template;
    public static final String SERIALIZED_NAME_TEMPLATE_VARIABLES = "templateVariables";
    @SerializedName(value="templateVariables")
    private Object templateVariables;

    public ReplyToEmailOptions attachments(List<String> attachments) {
        this.attachments = attachments;
        return this;
    }

    public ReplyToEmailOptions addAttachmentsItem(String attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<String>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of uploaded attachments to send with the reply. Optional.")
    public List<String> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<String> attachments) {
        this.attachments = attachments;
    }

    public ReplyToEmailOptions body(String body) {
        this.body = body;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Body of the reply email you want to send")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public ReplyToEmailOptions charset(String charset) {
        this.charset = charset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The charset that your message should be sent with. Optional. Default is UTF-8")
    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public ReplyToEmailOptions from(String from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The from header that should be used. Optional")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public ReplyToEmailOptions isHTML(Boolean isHTML) {
        this.isHTML = isHTML;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Is the reply HTML")
    public Boolean getIsHTML() {
        return this.isHTML;
    }

    public void setIsHTML(Boolean isHTML) {
        this.isHTML = isHTML;
    }

    public ReplyToEmailOptions replyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The replyTo header that should be used. Optional")
    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public ReplyToEmailOptions sendStrategy(SendStrategyEnum sendStrategy) {
        this.sendStrategy = sendStrategy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When to send the email. Typically immediately")
    public SendStrategyEnum getSendStrategy() {
        return this.sendStrategy;
    }

    public void setSendStrategy(SendStrategyEnum sendStrategy) {
        this.sendStrategy = sendStrategy;
    }

    public ReplyToEmailOptions template(UUID template) {
        this.template = template;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Template ID to use instead of body. Will use template variable map to fill defined variable slots.")
    public UUID getTemplate() {
        return this.template;
    }

    public void setTemplate(UUID template) {
        this.template = template;
    }

    public ReplyToEmailOptions templateVariables(Object templateVariables) {
        this.templateVariables = templateVariables;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Template variables if using a template")
    public Object getTemplateVariables() {
        return this.templateVariables;
    }

    public void setTemplateVariables(Object templateVariables) {
        this.templateVariables = templateVariables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplyToEmailOptions replyToEmailOptions = (ReplyToEmailOptions)o;
        return Objects.equals(this.attachments, replyToEmailOptions.attachments) && Objects.equals(this.body, replyToEmailOptions.body) && Objects.equals(this.charset, replyToEmailOptions.charset) && Objects.equals(this.from, replyToEmailOptions.from) && Objects.equals(this.isHTML, replyToEmailOptions.isHTML) && Objects.equals(this.replyTo, replyToEmailOptions.replyTo) && Objects.equals((Object)this.sendStrategy, (Object)replyToEmailOptions.sendStrategy) && Objects.equals(this.template, replyToEmailOptions.template) && Objects.equals(this.templateVariables, replyToEmailOptions.templateVariables);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attachments, this.body, this.charset, this.from, this.isHTML, this.replyTo, this.sendStrategy, this.template, this.templateVariables});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReplyToEmailOptions {\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    charset: ").append(this.toIndentedString(this.charset)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    isHTML: ").append(this.toIndentedString(this.isHTML)).append("\n");
        sb.append("    replyTo: ").append(this.toIndentedString(this.replyTo)).append("\n");
        sb.append("    sendStrategy: ").append(this.toIndentedString((Object)this.sendStrategy)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    templateVariables: ").append(this.toIndentedString(this.templateVariables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SendStrategyEnum {
        SINGLE_MESSAGE("SINGLE_MESSAGE");

        private String value;

        private SendStrategyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SendStrategyEnum fromValue(String value) {
            for (SendStrategyEnum b : SendStrategyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SendStrategyEnum> {
            public void write(JsonWriter jsonWriter, SendStrategyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SendStrategyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SendStrategyEnum.fromValue(value);
            }
        }
    }
}

