/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="Options for sending an email message from an inbox. You must provide one of: `to`, `toGroup`, or `toContacts` to send an email. All other parameters are optional. ")
public class SendEmailOptions {
    public static final String SERIALIZED_NAME_ATTACHMENTS = "attachments";
    @SerializedName(value="attachments")
    private List<String> attachments = null;
    public static final String SERIALIZED_NAME_BCC = "bcc";
    @SerializedName(value="bcc")
    private List<String> bcc = null;
    public static final String SERIALIZED_NAME_BODY = "body";
    @SerializedName(value="body")
    private String body;
    public static final String SERIALIZED_NAME_CC = "cc";
    @SerializedName(value="cc")
    private List<String> cc = null;
    public static final String SERIALIZED_NAME_CHARSET = "charset";
    @SerializedName(value="charset")
    private String charset;
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private String from;
    public static final String SERIALIZED_NAME_IS_H_T_M_L = "isHTML";
    @SerializedName(value="isHTML")
    private Boolean isHTML;
    public static final String SERIALIZED_NAME_REPLY_TO = "replyTo";
    @SerializedName(value="replyTo")
    private String replyTo;
    public static final String SERIALIZED_NAME_SEND_STRATEGY = "sendStrategy";
    @SerializedName(value="sendStrategy")
    private SendStrategyEnum sendStrategy;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;
    public static final String SERIALIZED_NAME_TEMPLATE = "template";
    @SerializedName(value="template")
    private UUID template;
    public static final String SERIALIZED_NAME_TEMPLATE_VARIABLES = "templateVariables";
    @SerializedName(value="templateVariables")
    private Object templateVariables;
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private List<String> to = null;
    public static final String SERIALIZED_NAME_TO_CONTACTS = "toContacts";
    @SerializedName(value="toContacts")
    private List<UUID> toContacts = null;
    public static final String SERIALIZED_NAME_TO_GROUP = "toGroup";
    @SerializedName(value="toGroup")
    private UUID toGroup;

    public SendEmailOptions attachments(List<String> attachments) {
        this.attachments = attachments;
        return this;
    }

    public SendEmailOptions addAttachmentsItem(String attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<String>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional list of attachment IDs to send with this email. You must first upload each attachment separately in order to obtain attachment IDs. This way you can reuse attachments with different emails once uploaded.")
    public List<String> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<String> attachments) {
        this.attachments = attachments;
    }

    public SendEmailOptions bcc(List<String> bcc) {
        this.bcc = bcc;
        return this;
    }

    public SendEmailOptions addBccItem(String bccItem) {
        if (this.bcc == null) {
            this.bcc = new ArrayList<String>();
        }
        this.bcc.add(bccItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional list of bcc destination email addresses")
    public List<String> getBcc() {
        return this.bcc;
    }

    public void setBcc(List<String> bcc) {
        this.bcc = bcc;
    }

    public SendEmailOptions body(String body) {
        this.body = body;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional contents of email. If body contains HTML then set `isHTML` to true to ensure that email clients render it correctly. You can use moustache template syntax in the email body in conjunction with `toGroup` contact variables or `templateVariables` data. If you need more templating control consider creating a template and using the `template` property instead of the body.")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public SendEmailOptions cc(List<String> cc) {
        this.cc = cc;
        return this;
    }

    public SendEmailOptions addCcItem(String ccItem) {
        if (this.cc == null) {
            this.cc = new ArrayList<String>();
        }
        this.cc.add(ccItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional list of cc destination email addresses")
    public List<String> getCc() {
        return this.cc;
    }

    public void setCc(List<String> cc) {
        this.cc = cc;
    }

    public SendEmailOptions charset(String charset) {
        this.charset = charset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional charset")
    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public SendEmailOptions from(String from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional from address. If not set the source inbox address will be used for this field. Beware of potential spam penalties when setting this field to an address not used by the inbox. For custom email addresses use a custom domain.")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public SendEmailOptions isHTML(Boolean isHTML) {
        this.isHTML = isHTML;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional HTML flag. If true the `content-type` of the email will be `text/html`. Set to true when sending HTML to ensure proper rending on email clients")
    public Boolean getIsHTML() {
        return this.isHTML;
    }

    public void setIsHTML(Boolean isHTML) {
        this.isHTML = isHTML;
    }

    public SendEmailOptions replyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional replyTo header")
    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public SendEmailOptions sendStrategy(SendStrategyEnum sendStrategy) {
        this.sendStrategy = sendStrategy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional strategy to use when sending the email")
    public SendStrategyEnum getSendStrategy() {
        return this.sendStrategy;
    }

    public void setSendStrategy(SendStrategyEnum sendStrategy) {
        this.sendStrategy = sendStrategy;
    }

    public SendEmailOptions subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional email subject line")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public SendEmailOptions template(UUID template) {
        this.template = template;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional template ID to use for body. Will override body if provided. When using a template make sure you pass the corresponding map of `templateVariables`. You can find which variables are needed by fetching the template itself or viewing it in the dashboard.")
    public UUID getTemplate() {
        return this.template;
    }

    public void setTemplate(UUID template) {
        this.template = template;
    }

    public SendEmailOptions templateVariables(Object templateVariables) {
        this.templateVariables = templateVariables;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional map of template variables. Will replace moustache syntax variables in subject and body or template with the associated values if found.")
    public Object getTemplateVariables() {
        return this.templateVariables;
    }

    public void setTemplateVariables(Object templateVariables) {
        this.templateVariables = templateVariables;
    }

    public SendEmailOptions to(List<String> to) {
        this.to = to;
        return this;
    }

    public SendEmailOptions addToItem(String toItem) {
        if (this.to == null) {
            this.to = new ArrayList<String>();
        }
        this.to.add(toItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of destination email addresses. Even single recipients must be in array form. Maximum recipients per email depends on your plan. If you need to send many emails try using contacts or contact groups or use a non standard sendStrategy to ensure that spam filters are not triggered (many recipients in one email can affect your spam rating).")
    public List<String> getTo() {
        return this.to;
    }

    public void setTo(List<String> to) {
        this.to = to;
    }

    public SendEmailOptions toContacts(List<UUID> toContacts) {
        this.toContacts = toContacts;
        return this;
    }

    public SendEmailOptions addToContactsItem(UUID toContactsItem) {
        if (this.toContacts == null) {
            this.toContacts = new ArrayList<UUID>();
        }
        this.toContacts.add(toContactsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional list of contact IDs to send email to. Manage your contacts via the API or dashboard. When contacts are used the email is sent to each contact separately so they will not see other recipients.")
    public List<UUID> getToContacts() {
        return this.toContacts;
    }

    public void setToContacts(List<UUID> toContacts) {
        this.toContacts = toContacts;
    }

    public SendEmailOptions toGroup(UUID toGroup) {
        this.toGroup = toGroup;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional contact group ID to send email to. You can create contacts and contact groups in the API or dashboard and use them for email campaigns. When contact groups are used the email is sent to each contact separately so they will not see other recipients")
    public UUID getToGroup() {
        return this.toGroup;
    }

    public void setToGroup(UUID toGroup) {
        this.toGroup = toGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendEmailOptions sendEmailOptions = (SendEmailOptions)o;
        return Objects.equals(this.attachments, sendEmailOptions.attachments) && Objects.equals(this.bcc, sendEmailOptions.bcc) && Objects.equals(this.body, sendEmailOptions.body) && Objects.equals(this.cc, sendEmailOptions.cc) && Objects.equals(this.charset, sendEmailOptions.charset) && Objects.equals(this.from, sendEmailOptions.from) && Objects.equals(this.isHTML, sendEmailOptions.isHTML) && Objects.equals(this.replyTo, sendEmailOptions.replyTo) && Objects.equals((Object)this.sendStrategy, (Object)sendEmailOptions.sendStrategy) && Objects.equals(this.subject, sendEmailOptions.subject) && Objects.equals(this.template, sendEmailOptions.template) && Objects.equals(this.templateVariables, sendEmailOptions.templateVariables) && Objects.equals(this.to, sendEmailOptions.to) && Objects.equals(this.toContacts, sendEmailOptions.toContacts) && Objects.equals(this.toGroup, sendEmailOptions.toGroup);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attachments, this.bcc, this.body, this.cc, this.charset, this.from, this.isHTML, this.replyTo, this.sendStrategy, this.subject, this.template, this.templateVariables, this.to, this.toContacts, this.toGroup});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendEmailOptions {\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    bcc: ").append(this.toIndentedString(this.bcc)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    charset: ").append(this.toIndentedString(this.charset)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    isHTML: ").append(this.toIndentedString(this.isHTML)).append("\n");
        sb.append("    replyTo: ").append(this.toIndentedString(this.replyTo)).append("\n");
        sb.append("    sendStrategy: ").append(this.toIndentedString((Object)this.sendStrategy)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    templateVariables: ").append(this.toIndentedString(this.templateVariables)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    toContacts: ").append(this.toIndentedString(this.toContacts)).append("\n");
        sb.append("    toGroup: ").append(this.toIndentedString(this.toGroup)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SendStrategyEnum {
        SINGLE_MESSAGE("SINGLE_MESSAGE");

        private String value;

        private SendStrategyEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SendStrategyEnum fromValue(String value) {
            for (SendStrategyEnum b : SendStrategyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SendStrategyEnum> {
            public void write(JsonWriter jsonWriter, SendStrategyEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SendStrategyEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SendStrategyEnum.fromValue(value);
            }
        }
    }
}

