/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="Sent email details")
public class SentEmailDto {
    public static final String SERIALIZED_NAME_ATTACHMENTS = "attachments";
    @SerializedName(value="attachments")
    private List<String> attachments = null;
    public static final String SERIALIZED_NAME_BCC = "bcc";
    @SerializedName(value="bcc")
    private List<String> bcc = null;
    public static final String SERIALIZED_NAME_BODY = "body";
    @SerializedName(value="body")
    private String body;
    public static final String SERIALIZED_NAME_BODY_M_D5_HASH = "bodyMD5Hash";
    @SerializedName(value="bodyMD5Hash")
    private String bodyMD5Hash;
    public static final String SERIALIZED_NAME_CC = "cc";
    @SerializedName(value="cc")
    private List<String> cc = null;
    public static final String SERIALIZED_NAME_CHARSET = "charset";
    @SerializedName(value="charset")
    private String charset;
    public static final String SERIALIZED_NAME_FROM = "from";
    @SerializedName(value="from")
    private String from;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_INBOX_ID = "inboxId";
    @SerializedName(value="inboxId")
    private UUID inboxId;
    public static final String SERIALIZED_NAME_IS_H_T_M_L = "isHTML";
    @SerializedName(value="isHTML")
    private Boolean isHTML;
    public static final String SERIALIZED_NAME_REPLY_TO = "replyTo";
    @SerializedName(value="replyTo")
    private String replyTo;
    public static final String SERIALIZED_NAME_SENT_AT = "sentAt";
    @SerializedName(value="sentAt")
    private OffsetDateTime sentAt;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;
    public static final String SERIALIZED_NAME_TO = "to";
    @SerializedName(value="to")
    private List<String> to = null;
    public static final String SERIALIZED_NAME_USER_ID = "userId";
    @SerializedName(value="userId")
    private UUID userId;

    public SentEmailDto attachments(List<String> attachments) {
        this.attachments = attachments;
        return this;
    }

    public SentEmailDto addAttachmentsItem(String attachmentsItem) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<String>();
        }
        this.attachments.add(attachmentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Array of IDs of attachments that were sent with this email")
    public List<String> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<String> attachments) {
        this.attachments = attachments;
    }

    public SentEmailDto bcc(List<String> bcc) {
        this.bcc = bcc;
        return this;
    }

    public SentEmailDto addBccItem(String bccItem) {
        if (this.bcc == null) {
            this.bcc = new ArrayList<String>();
        }
        this.bcc.add(bccItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getBcc() {
        return this.bcc;
    }

    public void setBcc(List<String> bcc) {
        this.bcc = bcc;
    }

    public SentEmailDto body(String body) {
        this.body = body;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public SentEmailDto bodyMD5Hash(String bodyMD5Hash) {
        this.bodyMD5Hash = bodyMD5Hash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MD5 Hash")
    public String getBodyMD5Hash() {
        return this.bodyMD5Hash;
    }

    public void setBodyMD5Hash(String bodyMD5Hash) {
        this.bodyMD5Hash = bodyMD5Hash;
    }

    public SentEmailDto cc(List<String> cc) {
        this.cc = cc;
        return this;
    }

    public SentEmailDto addCcItem(String ccItem) {
        if (this.cc == null) {
            this.cc = new ArrayList<String>();
        }
        this.cc.add(ccItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getCc() {
        return this.cc;
    }

    public void setCc(List<String> cc) {
        this.cc = cc;
    }

    public SentEmailDto charset(String charset) {
        this.charset = charset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public SentEmailDto from(String from) {
        this.from = from;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public SentEmailDto id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of sent email")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public SentEmailDto inboxId(UUID inboxId) {
        this.inboxId = inboxId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Inbox ID email was sent from")
    public UUID getInboxId() {
        return this.inboxId;
    }

    public void setInboxId(UUID inboxId) {
        this.inboxId = inboxId;
    }

    public SentEmailDto isHTML(Boolean isHTML) {
        this.isHTML = isHTML;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Boolean getIsHTML() {
        return this.isHTML;
    }

    public void setIsHTML(Boolean isHTML) {
        this.isHTML = isHTML;
    }

    public SentEmailDto replyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public SentEmailDto sentAt(OffsetDateTime sentAt) {
        this.sentAt = sentAt;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public OffsetDateTime getSentAt() {
        return this.sentAt;
    }

    public void setSentAt(OffsetDateTime sentAt) {
        this.sentAt = sentAt;
    }

    public SentEmailDto subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public SentEmailDto to(List<String> to) {
        this.to = to;
        return this;
    }

    public SentEmailDto addToItem(String toItem) {
        if (this.to == null) {
            this.to = new ArrayList<String>();
        }
        this.to.add(toItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Recipients email was sent to")
    public List<String> getTo() {
        return this.to;
    }

    public void setTo(List<String> to) {
        this.to = to;
    }

    public SentEmailDto userId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="User ID")
    public UUID getUserId() {
        return this.userId;
    }

    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentEmailDto sentEmailDto = (SentEmailDto)o;
        return Objects.equals(this.attachments, sentEmailDto.attachments) && Objects.equals(this.bcc, sentEmailDto.bcc) && Objects.equals(this.body, sentEmailDto.body) && Objects.equals(this.bodyMD5Hash, sentEmailDto.bodyMD5Hash) && Objects.equals(this.cc, sentEmailDto.cc) && Objects.equals(this.charset, sentEmailDto.charset) && Objects.equals(this.from, sentEmailDto.from) && Objects.equals(this.id, sentEmailDto.id) && Objects.equals(this.inboxId, sentEmailDto.inboxId) && Objects.equals(this.isHTML, sentEmailDto.isHTML) && Objects.equals(this.replyTo, sentEmailDto.replyTo) && Objects.equals(this.sentAt, sentEmailDto.sentAt) && Objects.equals(this.subject, sentEmailDto.subject) && Objects.equals(this.to, sentEmailDto.to) && Objects.equals(this.userId, sentEmailDto.userId);
    }

    public int hashCode() {
        return Objects.hash(this.attachments, this.bcc, this.body, this.bodyMD5Hash, this.cc, this.charset, this.from, this.id, this.inboxId, this.isHTML, this.replyTo, this.sentAt, this.subject, this.to, this.userId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SentEmailDto {\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    bcc: ").append(this.toIndentedString(this.bcc)).append("\n");
        sb.append("    body: ").append(this.toIndentedString(this.body)).append("\n");
        sb.append("    bodyMD5Hash: ").append(this.toIndentedString(this.bodyMD5Hash)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    charset: ").append(this.toIndentedString(this.charset)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    inboxId: ").append(this.toIndentedString(this.inboxId)).append("\n");
        sb.append("    isHTML: ").append(this.toIndentedString(this.isHTML)).append("\n");
        sb.append("    replyTo: ").append(this.toIndentedString(this.replyTo)).append("\n");
        sb.append("    sentAt: ").append(this.toIndentedString(this.sentAt)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

