/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Options for updating inbox properties")
public class UpdateInboxOptions {
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_EXPIRES_AT = "expiresAt";
    @SerializedName(value="expiresAt")
    private OffsetDateTime expiresAt;
    public static final String SERIALIZED_NAME_FAVOURITE = "favourite";
    @SerializedName(value="favourite")
    private Boolean favourite;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    private List<String> tags = null;

    public UpdateInboxOptions description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of an inbox for labelling and searching purposes")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateInboxOptions expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Inbox expiration time. When, if ever, the inbox should expire and be deleted. If null then this inbox is permanent and the emails in it won't be deleted. This is the default behavior unless expiration date is set. If an expiration date is set and the time is reached MailSlurp will expire the inbox and move it to an expired inbox entity. You can still access the emails belonging to it but it can no longer send or receive email.")
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public UpdateInboxOptions favourite(Boolean favourite) {
        this.favourite = favourite;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Is the inbox favorited. Favouriting inboxes is typically done in the dashboard for quick access or filtering")
    public Boolean getFavourite() {
        return this.favourite;
    }

    public void setFavourite(Boolean favourite) {
        this.favourite = favourite;
    }

    public UpdateInboxOptions name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the inbox. Displayed in the dashboard for easier search")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateInboxOptions tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public UpdateInboxOptions addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Tags that inbox has been tagged with. Tags can be added to inboxes to group different inboxes within an account. You can also search for inboxes by tag in the dashboard UI.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateInboxOptions updateInboxOptions = (UpdateInboxOptions)o;
        return Objects.equals(this.description, updateInboxOptions.description) && Objects.equals(this.expiresAt, updateInboxOptions.expiresAt) && Objects.equals(this.favourite, updateInboxOptions.favourite) && Objects.equals(this.name, updateInboxOptions.name) && Objects.equals(this.tags, updateInboxOptions.tags);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.expiresAt, this.favourite, this.name, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateInboxOptions {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    favourite: ").append(this.toIndentedString(this.favourite)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

