/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Options for uploading files for attachments. When sending emails with the API that require attachments first upload each attachment. Then use the returned attachment ID in your `SendEmailOptions` when sending an email. This way you can use attachments multiple times once they have been uploaded.")
public class UploadAttachmentOptions {
    public static final String SERIALIZED_NAME_BASE64_CONTENTS = "base64Contents";
    @SerializedName(value="base64Contents")
    private String base64Contents;
    public static final String SERIALIZED_NAME_CONTENT_TYPE = "contentType";
    @SerializedName(value="contentType")
    private String contentType;
    public static final String SERIALIZED_NAME_FILENAME = "filename";
    @SerializedName(value="filename")
    private String filename;

    public UploadAttachmentOptions base64Contents(String base64Contents) {
        this.base64Contents = base64Contents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Base64 encoded string of file contents. Typically this means reading the bytes or string content of a file and then converting that to a base64 encoded string.")
    public String getBase64Contents() {
        return this.base64Contents;
    }

    public void setBase64Contents(String base64Contents) {
        this.base64Contents = base64Contents;
    }

    public UploadAttachmentOptions contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional contentType for file. For instance `application/pdf`")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public UploadAttachmentOptions filename(String filename) {
        this.filename = filename;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional filename to save upload with. Will be the name that is shown in email clients")
    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadAttachmentOptions uploadAttachmentOptions = (UploadAttachmentOptions)o;
        return Objects.equals(this.base64Contents, uploadAttachmentOptions.base64Contents) && Objects.equals(this.contentType, uploadAttachmentOptions.contentType) && Objects.equals(this.filename, uploadAttachmentOptions.filename);
    }

    public int hashCode() {
        return Objects.hash(this.base64Contents, this.contentType, this.filename);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UploadAttachmentOptions {\n");
        sb.append("    base64Contents: ").append(this.toIndentedString(this.base64Contents)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    filename: ").append(this.toIndentedString(this.filename)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

