/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mailslurp.models.MatchOption;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="Conditions that a `waitForXEmails` endpoint operates on. The methods wait until given conditions are met or a timeout is reached. If the conditions are met without needing to wait the results will be returned immediately.")
public class WaitForConditions {
    public static final String SERIALIZED_NAME_COUNT = "count";
    @SerializedName(value="count")
    private Integer count;
    public static final String SERIALIZED_NAME_COUNT_TYPE = "countType";
    @SerializedName(value="countType")
    private CountTypeEnum countType;
    public static final String SERIALIZED_NAME_INBOX_ID = "inboxId";
    @SerializedName(value="inboxId")
    private UUID inboxId;
    public static final String SERIALIZED_NAME_MATCHES = "matches";
    @SerializedName(value="matches")
    private List<MatchOption> matches = null;
    public static final String SERIALIZED_NAME_SORT_DIRECTION = "sortDirection";
    @SerializedName(value="sortDirection")
    private SortDirectionEnum sortDirection;
    public static final String SERIALIZED_NAME_TIMEOUT = "timeout";
    @SerializedName(value="timeout")
    private Long timeout;
    public static final String SERIALIZED_NAME_UNREAD_ONLY = "unreadOnly";
    @SerializedName(value="unreadOnly")
    private Boolean unreadOnly;

    public WaitForConditions count(Integer count) {
        this.count = count;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of results that should match conditions. Either exactly or at least this amount based on the `countType`. If count condition is not met and the timeout has not been reached the `waitFor` method will retry the operation.")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public WaitForConditions countType(CountTypeEnum countType) {
        this.countType = countType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="How should the found count be compared to the expected count.")
    public CountTypeEnum getCountType() {
        return this.countType;
    }

    public void setCountType(CountTypeEnum countType) {
        this.countType = countType;
    }

    public WaitForConditions inboxId(UUID inboxId) {
        this.inboxId = inboxId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of inbox to search within and apply conditions to. Essentially filtering the emails found to give a count.")
    public UUID getInboxId() {
        return this.inboxId;
    }

    public void setInboxId(UUID inboxId) {
        this.inboxId = inboxId;
    }

    public WaitForConditions matches(List<MatchOption> matches) {
        this.matches = matches;
        return this;
    }

    public WaitForConditions addMatchesItem(MatchOption matchesItem) {
        if (this.matches == null) {
            this.matches = new ArrayList<MatchOption>();
        }
        this.matches.add(matchesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Conditions that should be matched for an email to qualify for results. Each condition will be applied in order to each email within an inbox to filter a result list of matching emails you are waiting for.")
    public List<MatchOption> getMatches() {
        return this.matches;
    }

    public void setMatches(List<MatchOption> matches) {
        this.matches = matches;
    }

    public WaitForConditions sortDirection(SortDirectionEnum sortDirection) {
        this.sortDirection = sortDirection;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Direction to sort matching emails by created time")
    public SortDirectionEnum getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(SortDirectionEnum sortDirection) {
        this.sortDirection = sortDirection;
    }

    public WaitForConditions timeout(Long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Max time in milliseconds to retry the `waitFor` operation until conditions are met.")
    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public WaitForConditions unreadOnly(Boolean unreadOnly) {
        this.unreadOnly = unreadOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Apply conditions only to **unread** emails. All emails begin with `read=false`. An email is marked `read=true` when an `EmailDto` representation of it has been returned to the user at least once. For example you have called `getEmail` or `waitForLatestEmail` etc., or you have viewed the email in the dashboard. ")
    public Boolean getUnreadOnly() {
        return this.unreadOnly;
    }

    public void setUnreadOnly(Boolean unreadOnly) {
        this.unreadOnly = unreadOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WaitForConditions waitForConditions = (WaitForConditions)o;
        return Objects.equals(this.count, waitForConditions.count) && Objects.equals((Object)this.countType, (Object)waitForConditions.countType) && Objects.equals(this.inboxId, waitForConditions.inboxId) && Objects.equals(this.matches, waitForConditions.matches) && Objects.equals((Object)this.sortDirection, (Object)waitForConditions.sortDirection) && Objects.equals(this.timeout, waitForConditions.timeout) && Objects.equals(this.unreadOnly, waitForConditions.unreadOnly);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.count, this.countType, this.inboxId, this.matches, this.sortDirection, this.timeout, this.unreadOnly});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WaitForConditions {\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    countType: ").append(this.toIndentedString((Object)this.countType)).append("\n");
        sb.append("    inboxId: ").append(this.toIndentedString(this.inboxId)).append("\n");
        sb.append("    matches: ").append(this.toIndentedString(this.matches)).append("\n");
        sb.append("    sortDirection: ").append(this.toIndentedString((Object)this.sortDirection)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    unreadOnly: ").append(this.toIndentedString(this.unreadOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SortDirectionEnum {
        ASC("ASC"),
        DESC("DESC");

        private String value;

        private SortDirectionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SortDirectionEnum fromValue(String value) {
            for (SortDirectionEnum b : SortDirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SortDirectionEnum> {
            public void write(JsonWriter jsonWriter, SortDirectionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SortDirectionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SortDirectionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CountTypeEnum {
        EXACTLY("EXACTLY"),
        ATLEAST("ATLEAST");

        private String value;

        private CountTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CountTypeEnum fromValue(String value) {
            for (CountTypeEnum b : CountTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<CountTypeEnum> {
            public void write(JsonWriter jsonWriter, CountTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CountTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CountTypeEnum.fromValue(value);
            }
        }
    }
}

