/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@ApiModel(description="Representation of a webhook for an inbox. The URL specified will be using by MailSlurp whenever an email is received by the attached inbox.")
public class WebhookDto {
    public static final String SERIALIZED_NAME_BASIC_AUTH = "basicAuth";
    @SerializedName(value="basicAuth")
    private Boolean basicAuth;
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private UUID id;
    public static final String SERIALIZED_NAME_INBOX_ID = "inboxId";
    @SerializedName(value="inboxId")
    private UUID inboxId;
    public static final String SERIALIZED_NAME_METHOD = "method";
    @SerializedName(value="method")
    private MethodEnum method;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PAYLOAD_JSON_SCHEMA = "payloadJsonSchema";
    @SerializedName(value="payloadJsonSchema")
    private String payloadJsonSchema;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updatedAt";
    @SerializedName(value="updatedAt")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;

    public WebhookDto basicAuth(Boolean basicAuth) {
        this.basicAuth = basicAuth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Does webhook expect basic authentication? If true it means you created this webhook with a username and password. MailSlurp will use these in the URL to authenticate itself.")
    public Boolean getBasicAuth() {
        return this.basicAuth;
    }

    public void setBasicAuth(Boolean basicAuth) {
        this.basicAuth = basicAuth;
    }

    public WebhookDto createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When the webhook was created")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public WebhookDto id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the Webhook")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public WebhookDto inboxId(UUID inboxId) {
        this.inboxId = inboxId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The inbox that the Webhook will be triggered by")
    public UUID getInboxId() {
        return this.inboxId;
    }

    public void setInboxId(UUID inboxId) {
        this.inboxId = inboxId;
    }

    public WebhookDto method(MethodEnum method) {
        this.method = method;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="HTTP method that your server endpoint must listen for")
    public MethodEnum getMethod() {
        return this.method;
    }

    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    public WebhookDto name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the webhook")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WebhookDto payloadJsonSchema(String payloadJsonSchema) {
        this.payloadJsonSchema = payloadJsonSchema;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="JSON Schema for the payload that will be sent to your URL via the HTTP method described.")
    public String getPayloadJsonSchema() {
        return this.payloadJsonSchema;
    }

    public void setPayloadJsonSchema(String payloadJsonSchema) {
        this.payloadJsonSchema = payloadJsonSchema;
    }

    public WebhookDto updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public WebhookDto url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL of your server that the webhook will be sent to. The schema of the JSON that is sent is described by the payloadJsonSchema.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookDto webhookDto = (WebhookDto)o;
        return Objects.equals(this.basicAuth, webhookDto.basicAuth) && Objects.equals(this.createdAt, webhookDto.createdAt) && Objects.equals(this.id, webhookDto.id) && Objects.equals(this.inboxId, webhookDto.inboxId) && Objects.equals((Object)this.method, (Object)webhookDto.method) && Objects.equals(this.name, webhookDto.name) && Objects.equals(this.payloadJsonSchema, webhookDto.payloadJsonSchema) && Objects.equals(this.updatedAt, webhookDto.updatedAt) && Objects.equals(this.url, webhookDto.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.basicAuth, this.createdAt, this.id, this.inboxId, this.method, this.name, this.payloadJsonSchema, this.updatedAt, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookDto {\n");
        sb.append("    basicAuth: ").append(this.toIndentedString(this.basicAuth)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    inboxId: ").append(this.toIndentedString(this.inboxId)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    payloadJsonSchema: ").append(this.toIndentedString(this.payloadJsonSchema)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MethodEnum {
        GET("GET"),
        HEAD("HEAD"),
        POST("POST"),
        PUT("PUT"),
        PATCH("PATCH"),
        DELETE("DELETE"),
        OPTIONS("OPTIONS"),
        TRACE("TRACE");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MethodEnum fromValue(String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<MethodEnum> {
            public void write(JsonWriter jsonWriter, MethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MethodEnum.fromValue(value);
            }
        }
    }
}

