/*
 * Decompiled with CFR 0.152.
 */
package com.mailslurp.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class WebhookTestRequest {
    public static final String SERIALIZED_NAME_HEADERS = "headers";
    @SerializedName(value="headers")
    private Map<String, String> headers = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_METHOD = "method";
    @SerializedName(value="method")
    private MethodEnum method;
    public static final String SERIALIZED_NAME_PAYLOAD = "payload";
    @SerializedName(value="payload")
    private String payload;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;

    public WebhookTestRequest headers(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public WebhookTestRequest putHeadersItem(String key, String headersItem) {
        this.headers.put(key, headersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public WebhookTestRequest method(MethodEnum method) {
        this.method = method;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public MethodEnum getMethod() {
        return this.method;
    }

    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    public WebhookTestRequest payload(String payload) {
        this.payload = payload;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public WebhookTestRequest url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookTestRequest webhookTestRequest = (WebhookTestRequest)o;
        return Objects.equals(this.headers, webhookTestRequest.headers) && Objects.equals((Object)this.method, (Object)webhookTestRequest.method) && Objects.equals(this.payload, webhookTestRequest.payload) && Objects.equals(this.url, webhookTestRequest.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.headers, this.method, this.payload, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookTestRequest {\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    payload: ").append(this.toIndentedString(this.payload)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MethodEnum {
        GET("GET"),
        HEAD("HEAD"),
        POST("POST"),
        PUT("PUT"),
        PATCH("PATCH"),
        DELETE("DELETE"),
        OPTIONS("OPTIONS"),
        TRACE("TRACE");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MethodEnum fromValue(String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<MethodEnum> {
            public void write(JsonWriter jsonWriter, MethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MethodEnum.fromValue(value);
            }
        }
    }
}

