/*
 * Decompiled with CFR 0.152.
 */
package com.mainstreethub.ecr;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.ecr.AmazonECRClient;
import com.amazonaws.services.ecr.model.AuthorizationData;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenRequest;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenResult;
import com.google.common.base.Splitter;
import com.google.common.io.BaseEncoding;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="login")
public class LoginMojo
extends AbstractMojo {
    private static final Splitter TOKEN_SPLITTER = Splitter.on((String)":").limit(2).trimResults();
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List splitTokenList;
        AmazonECRClient ecrClient = new AmazonECRClient();
        try {
            this.getLog().info((CharSequence)"Fetching ECR authorization...");
            GetAuthorizationTokenRequest authRequest = new GetAuthorizationTokenRequest();
            GetAuthorizationTokenResult tokenResult = ecrClient.getAuthorizationToken(authRequest);
            List authorizationDataList = tokenResult.getAuthorizationData();
            if (authorizationDataList.isEmpty()) {
                this.getLog().error((CharSequence)"Authorization data not available.");
                return;
            }
            AuthorizationData authorizationData = (AuthorizationData)authorizationDataList.get(0);
            String decodedToken = new String(BaseEncoding.base64().decode((CharSequence)authorizationData.getAuthorizationToken()));
            splitTokenList = TOKEN_SPLITTER.splitToList((CharSequence)decodedToken);
            if (splitTokenList.size() != 2) {
                this.getLog().error((CharSequence)"Authorization data in unsupported format.");
                return;
            }
        }
        catch (AmazonServiceException ex) {
            throw new MojoExecutionException("Error while retrieving authorization data", (Exception)((Object)ex));
        }
        this.getLog().info((CharSequence)"Successfully retrieved ECR docker credentials, exporting variables.");
        this.project.getProperties().setProperty("aws.ecr.login.user", (String)splitTokenList.get(0));
        this.project.getProperties().setProperty("aws.ecr.login.password", (String)splitTokenList.get(1));
    }
}

