/*
 * Decompiled with CFR 0.152.
 */
package com.makeramen.roundedimageview;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ImageView;
import com.makeramen.roundedimageview.RoundedDrawable;
import com.squareup.picasso.Transformation;

public final class RoundedTransformationBuilder {
    private final DisplayMetrics mDisplayMetrics;
    private float mCornerRadius = 0.0f;
    private boolean mOval = false;
    private float mBorderWidth = 0.0f;
    private ColorStateList mBorderColor = ColorStateList.valueOf((int)-16777216);
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;

    public RoundedTransformationBuilder() {
        this.mDisplayMetrics = Resources.getSystem().getDisplayMetrics();
    }

    public RoundedTransformationBuilder scaleType(ImageView.ScaleType scaleType) {
        this.mScaleType = scaleType;
        return this;
    }

    public RoundedTransformationBuilder cornerRadius(float radiusPx) {
        this.mCornerRadius = radiusPx;
        return this;
    }

    public RoundedTransformationBuilder cornerRadiusDp(float radiusDp) {
        this.mCornerRadius = TypedValue.applyDimension((int)1, (float)radiusDp, (DisplayMetrics)this.mDisplayMetrics);
        return this;
    }

    public RoundedTransformationBuilder borderWidth(float widthPx) {
        this.mBorderWidth = widthPx;
        return this;
    }

    public RoundedTransformationBuilder borderWidthDp(float widthDp) {
        this.mBorderWidth = TypedValue.applyDimension((int)1, (float)widthDp, (DisplayMetrics)this.mDisplayMetrics);
        return this;
    }

    public RoundedTransformationBuilder borderColor(int color) {
        this.mBorderColor = ColorStateList.valueOf((int)color);
        return this;
    }

    public RoundedTransformationBuilder borderColor(ColorStateList colors) {
        this.mBorderColor = colors;
        return this;
    }

    public RoundedTransformationBuilder oval(boolean oval) {
        this.mOval = oval;
        return this;
    }

    public Transformation build() {
        return new Transformation(){

            public Bitmap transform(Bitmap source) {
                Bitmap transformed = RoundedDrawable.fromBitmap(source).setScaleType(RoundedTransformationBuilder.this.mScaleType).setCornerRadius(RoundedTransformationBuilder.this.mCornerRadius).setBorderWidth(RoundedTransformationBuilder.this.mBorderWidth).setBorderColor(RoundedTransformationBuilder.this.mBorderColor).setOval(RoundedTransformationBuilder.this.mOval).toBitmap();
                if (!source.equals(transformed)) {
                    source.recycle();
                }
                return transformed;
            }

            public String key() {
                return "r:" + RoundedTransformationBuilder.this.mCornerRadius + "b:" + RoundedTransformationBuilder.this.mBorderWidth + "c:" + RoundedTransformationBuilder.this.mBorderColor + "o:" + RoundedTransformationBuilder.this.mOval;
            }
        };
    }
}

