/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.android;

import com.malinskiy.marathon.android.model.AndroidTestBundle;
import com.malinskiy.marathon.exceptions.ConfigurationException;
import com.malinskiy.marathon.execution.bundle.TestBundleIdentifier;
import com.malinskiy.marathon.test.Test;
import com.malinskiy.marathon.test.TestKt;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/malinskiy/marathon/android/AndroidTestBundleIdentifier;", "Lcom/malinskiy/marathon/execution/bundle/TestBundleIdentifier;", "()V", "testToBundle", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/malinskiy/marathon/test/Test;", "Lcom/malinskiy/marathon/android/model/AndroidTestBundle;", "identify", "test", "put", "", "androidTestBundle", "base"})
public final class AndroidTestBundleIdentifier
implements TestBundleIdentifier {
    private final ConcurrentHashMap<Test, AndroidTestBundle> testToBundle = new ConcurrentHashMap();

    @NotNull
    public AndroidTestBundle identify(@NotNull Test test) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        AndroidTestBundle androidTestBundle = this.testToBundle.get(test);
        if (androidTestBundle == null) {
            throw (Throwable)new ConfigurationException("Invalid test " + TestKt.toHumanReadableTestName((Test)test) + ": can't locate test bundle");
        }
        return androidTestBundle;
    }

    public final void put(@NotNull Test test, @NotNull AndroidTestBundle androidTestBundle) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        Intrinsics.checkNotNullParameter((Object)((Object)androidTestBundle), (String)"androidTestBundle");
        ((Map)this.testToBundle).put(test, androidTestBundle);
    }
}

