/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.android;

import com.linkedin.dex.parser.DexParser;
import com.linkedin.dex.parser.TestAnnotation;
import com.linkedin.dex.parser.TestMethod;
import com.malinskiy.marathon.android.AndroidConfiguration;
import com.malinskiy.marathon.android.AndroidTestBundleIdentifier;
import com.malinskiy.marathon.android.AndroidTestParserKt;
import com.malinskiy.marathon.android.model.AndroidTestBundle;
import com.malinskiy.marathon.execution.Configuration;
import com.malinskiy.marathon.execution.TestParser;
import com.malinskiy.marathon.test.MetaProperty;
import com.malinskiy.marathon.test.Test;
import com.malinskiy.marathon.vendor.VendorConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/malinskiy/marathon/android/AndroidTestParser;", "Lcom/malinskiy/marathon/execution/TestParser;", "testBundleIdentifier", "Lcom/malinskiy/marathon/android/AndroidTestBundleIdentifier;", "(Lcom/malinskiy/marathon/android/AndroidTestBundleIdentifier;)V", "extract", "", "Lcom/malinskiy/marathon/test/Test;", "configuration", "Lcom/malinskiy/marathon/execution/Configuration;", "base"})
public final class AndroidTestParser
implements TestParser {
    private final AndroidTestBundleIdentifier testBundleIdentifier;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Test> extract(@NotNull Configuration configuration) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        VendorConfiguration vendorConfiguration = configuration.getVendorConfiguration();
        if (vendorConfiguration == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.malinskiy.marathon.android.AndroidConfiguration");
        }
        AndroidConfiguration androidConfiguration = (AndroidConfiguration)vendorConfiguration;
        List<AndroidTestBundle> testBundles = androidConfiguration.testBundlesCompat();
        Iterable $this$flatMap$iv = testBundles;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            AndroidTestBundle bundle = (AndroidTestBundle)((Object)element$iv$iv);
            boolean bl = false;
            String string = bundle.getTestApplication().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bundle.testApplication.absolutePath");
            List tests = DexParser.Companion.findTestMethods$default((DexParser.Companion)DexParser.Companion, (String)string, null, (int)2, null);
            Iterable $this$map$iv = tests;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                int n;
                String packageAndClassName;
                String methodName;
                List annotations;
                Collection collection;
                block7: {
                    void $this$mapTo$iv$iv2;
                    void it;
                    TestMethod testMethod = (TestMethod)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    String testName = it.getTestName();
                    Iterable $this$map$iv2 = it.getAnnotations();
                    boolean $i$f$map2 = false;
                    Iterable iterable3 = $this$map$iv2;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it2;
                        TestAnnotation testAnnotation = (TestAnnotation)item$iv$iv2;
                        Collection collection2 = destination$iv$iv3;
                        boolean bl3 = false;
                        MetaProperty metaProperty = AndroidTestParserKt.access$toMetaProperty((TestAnnotation)it2);
                        collection2.add(metaProperty);
                    }
                    annotations = (List)destination$iv$iv3;
                    List split = StringsKt.split$default((CharSequence)testName, (String[])new String[]{"#"}, (boolean)false, (int)0, (int)6, null);
                    if (split.size() != 2) {
                        throw (Throwable)new IllegalStateException("Can't parse test " + testName);
                    }
                    methodName = (String)split.get(1);
                    packageAndClassName = (String)split.get(0);
                    CharSequence $this$indexOfLast$iv = packageAndClassName;
                    boolean $i$f$indexOfLast = false;
                    int item$iv$iv2 = $this$indexOfLast$iv.length();
                    --item$iv$iv2;
                    boolean bl4 = false;
                    while (item$iv$iv2 >= 0) {
                        void index$iv;
                        char c = $this$indexOfLast$iv.charAt((int)index$iv);
                        boolean bl5 = false;
                        if (c == '.') {
                            n = index$iv;
                            break block7;
                        }
                        --index$iv;
                    }
                    n = -1;
                }
                int lastDotIndex = n;
                String packageName = StringsKt.substring((String)packageAndClassName, (IntRange)RangesKt.until((int)0, (int)lastDotIndex));
                String className = StringsKt.substring((String)packageAndClassName, (IntRange)RangesKt.until((int)(lastDotIndex + 1), (int)packageAndClassName.length()));
                Test test = new Test(packageName, className, methodName, (Collection)annotations);
                this.testBundleIdentifier.put(test, new AndroidTestBundle(bundle.getApplication(), bundle.getTestApplication()));
                Test test2 = test;
                collection.add(test2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public AndroidTestParser(@NotNull AndroidTestBundleIdentifier testBundleIdentifier) {
        Intrinsics.checkNotNullParameter((Object)testBundleIdentifier, (String)"testBundleIdentifier");
        this.testBundleIdentifier = testBundleIdentifier;
    }
}

