/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.android;

import com.malinskiy.marathon.android.InstrumentationInfo;
import com.shazam.axmlparser.AXMLParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/malinskiy/marathon/android/ApkParser;", "", "()V", "parseInstrumentationInfo", "Lcom/malinskiy/marathon/android/InstrumentationInfo;", "apk", "Ljava/io/File;", "base"})
public final class ApkParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final InstrumentationInfo parseInstrumentationInfo(@NotNull File apk) {
        Intrinsics.checkNotNullParameter((Object)apk, (String)"apk");
        InputStream apkInputStream = null;
        try {
            ZipFile zip = new ZipFile(apk);
            ZipEntry entry = zip.getEntry("AndroidManifest.xml");
            apkInputStream = zip.getInputStream(entry);
            AXMLParser parser = new AXMLParser(apkInputStream);
            int eventType = parser.getType();
            String appPackage = null;
            String testPackage = null;
            String testRunnerClass = null;
            while (eventType != 1) {
                if (eventType == 2) {
                    String parserName = parser.getName();
                    boolean isManifest = Intrinsics.areEqual((Object)"manifest", (Object)parserName);
                    boolean isInstrumentation = Intrinsics.areEqual((Object)"instrumentation", (Object)parserName);
                    if (isManifest || isInstrumentation) {
                        int n = 0;
                        int n2 = parser.getAttributeCount();
                        while (n < n2) {
                            void i;
                            String parserAttributeName = parser.getAttributeName((int)i);
                            if (isManifest && Intrinsics.areEqual((Object)"package", (Object)parserAttributeName)) {
                                testPackage = parser.getAttributeValueString((int)i);
                            } else if (isInstrumentation && Intrinsics.areEqual((Object)"targetPackage", (Object)parserAttributeName)) {
                                appPackage = parser.getAttributeValueString((int)i);
                            } else if (isInstrumentation && Intrinsics.areEqual((Object)"name", (Object)parserAttributeName)) {
                                testRunnerClass = parser.getAttributeValueString((int)i);
                            }
                            ++i;
                        }
                    }
                }
                eventType = parser.next();
            }
            boolean bl = false;
            boolean bl2 = false;
            if (testRunnerClass == null) {
                boolean bl3 = false;
                String string = "Could not find test runner class.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl = false;
            bl2 = false;
            if (testPackage == null) {
                boolean bl4 = false;
                String string = "Could not find test application package.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            bl = false;
            bl2 = false;
            if (appPackage == null) {
                boolean bl5 = false;
                String string = "Could not find application package.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            if (StringsKt.startsWith$default((String)testRunnerClass, (String)".", (boolean)false, (int)2, null)) {
                testRunnerClass = testPackage + testRunnerClass;
            } else if (!StringsKt.contains$default((CharSequence)testRunnerClass, (CharSequence)".", (boolean)false, (int)2, null)) {
                testRunnerClass = testPackage + '.' + testRunnerClass;
            }
            InstrumentationInfo instrumentationInfo2 = new InstrumentationInfo(appPackage, testPackage, testRunnerClass);
            return instrumentationInfo2;
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException("Unable to parse test app AndroidManifest.xml.", e);
        }
        finally {
            block20: {
                InputStream inputStream = apkInputStream;
                if (inputStream == null) break block20;
                inputStream.close();
            }
        }
    }
}

