/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.android;

import com.malinskiy.marathon.android.RecorderTypeSelector$WhenMappings;
import com.malinskiy.marathon.android.ScreenRecordConfiguration;
import com.malinskiy.marathon.device.DeviceFeature;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\t\u001a\u0004\u0018\u00010\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lcom/malinskiy/marathon/android/RecorderTypeSelector;", "", "()V", "recorderEnabled", "", "type", "Lcom/malinskiy/marathon/device/DeviceFeature;", "configuration", "Lcom/malinskiy/marathon/android/ScreenRecordConfiguration;", "selectRecorderType", "supportedFeatures", "", "base"})
public final class RecorderTypeSelector {
    @NotNull
    public static final RecorderTypeSelector INSTANCE;

    @Nullable
    public final DeviceFeature selectRecorderType(@NotNull Collection<? extends DeviceFeature> supportedFeatures, @NotNull ScreenRecordConfiguration configuration) {
        Intrinsics.checkNotNullParameter(supportedFeatures, (String)"supportedFeatures");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        DeviceFeature preferred = configuration.getPreferableRecorderType();
        boolean screenshotEnabled = this.recorderEnabled(DeviceFeature.SCREENSHOT, configuration);
        boolean videoEnabled = this.recorderEnabled(DeviceFeature.VIDEO, configuration);
        if (preferred != null && supportedFeatures.contains(preferred) && this.recorderEnabled(preferred, configuration)) {
            return preferred;
        }
        return supportedFeatures.contains(DeviceFeature.VIDEO) && videoEnabled ? DeviceFeature.VIDEO : (supportedFeatures.contains(DeviceFeature.SCREENSHOT) && screenshotEnabled ? DeviceFeature.SCREENSHOT : null);
    }

    private final boolean recorderEnabled(DeviceFeature type, ScreenRecordConfiguration configuration) {
        boolean bl;
        switch (RecorderTypeSelector$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                bl = configuration.getVideoConfiguration().getEnabled();
                break;
            }
            case 2: {
                bl = configuration.getScreenshotConfiguration().getEnabled();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private RecorderTypeSelector() {
    }

    static {
        RecorderTypeSelector recorderTypeSelector;
        INSTANCE = recorderTypeSelector = new RecorderTypeSelector();
    }
}

