/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.android;

import com.malinskiy.marathon.android.AndroidDevice;
import com.malinskiy.marathon.android.RemoteFileManager;
import com.malinskiy.marathon.extension.StringExtensionsKt;
import com.malinskiy.marathon.log.MarathonLogging;
import com.malinskiy.marathon.test.Test;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0016\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bJ\u0011\u0010\u0017\u001a\u00020\u000eH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J#\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\b2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Lcom/malinskiy/marathon/android/RemoteFileManager;", "", "device", "Lcom/malinskiy/marathon/android/AndroidDevice;", "(Lcom/malinskiy/marathon/android/AndroidDevice;)V", "log", "Lmu/KLogger;", "outputDir", "", "getOutputDir", "()Ljava/lang/String;", "outputDir$delegate", "Lkotlin/Lazy;", "createRemoteDirectory", "", "remoteDir", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "remoteFileForTest", "filename", "remoteVideoForTest", "test", "Lcom/malinskiy/marathon/test/Test;", "testBatchId", "removeRemoteDirectory", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeRemotePath", "remotePath", "recursive", "", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "videoFileName", "Companion", "base"})
public final class RemoteFileManager {
    private final KLogger log;
    private final Lazy outputDir$delegate;
    private final AndroidDevice device;
    public static final int MAX_FILENAME = 255;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final String getOutputDir() {
        Lazy lazy = this.outputDir$delegate;
        RemoteFileManager remoteFileManager = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @Nullable
    public final Object removeRemotePath(@NotNull String remotePath, boolean recursive, @NotNull Continuation<? super Unit> $completion) {
        String errorMessage = "Could not delete remote file(s): " + remotePath;
        Object object = this.device.criticalExecuteShellCommand("rm " + (recursive ? "-r " : "") + remotePath, errorMessage, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object removeRemotePath$default(RemoteFileManager remoteFileManager, String string, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return remoteFileManager.removeRemotePath(string, bl, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object createRemoteDirectory(@NotNull String remoteDir, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.device.criticalExecuteShellCommand("mkdir " + remoteDir, "Could not create remote directory: " + remoteDir, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object createRemoteDirectory$default(RemoteFileManager remoteFileManager, String string, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = remoteFileManager.getOutputDir();
        }
        return remoteFileManager.createRemoteDirectory(string, (Continuation<? super Unit>)continuation);
    }

    @Nullable
    public final Object removeRemoteDirectory(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.device.criticalExecuteShellCommand("rm -r " + this.getOutputDir(), "Could not delete remote directory: " + this.getOutputDir(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final String remoteVideoForTest(@NotNull Test test, @NotNull String testBatchId) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        Intrinsics.checkNotNullParameter((Object)testBatchId, (String)"testBatchId");
        return this.remoteFileForTest(this.videoFileName(test, testBatchId));
    }

    private final String remoteFileForTest(String filename) {
        return this.getOutputDir() + '/' + filename;
    }

    private final String videoFileName(Test test, String testBatchId) {
        String cfr_ignored_0 = test.getPkg() + '.' + test.getClazz() + '-' + test.getMethod() + '-' + testBatchId + ".mp4";
        String testSuffix = '-' + testBatchId + ".mp4";
        String rawTestName = StringExtensionsKt.escape((String)(test.getPkg() + '.' + test.getClazz() + '-' + test.getMethod()));
        String testName = StringsKt.take((String)rawTestName, (int)(255 - testSuffix.length()));
        String fileName = testName + testSuffix;
        if (rawTestName.length() > testName.length()) {
            this.log.error((Function0)new Function0<Object>(fileName){
                final /* synthetic */ String $fileName;

                @Nullable
                public final Object invoke() {
                    return "Remote filename length cannot exceed 255 characters and has been trimmed to " + this.$fileName + " and can create a conflict. This happened because the combination of test class name and test name is too long.";
                }
                {
                    this.$fileName = string;
                    super(0);
                }
            });
        }
        return fileName;
    }

    public RemoteFileManager(@NotNull AndroidDevice device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        this.device = device;
        this.log = MarathonLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
        this.outputDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ RemoteFileManager this$0;

            @NotNull
            public final String invoke() {
                return RemoteFileManager.access$getDevice$p(this.this$0).getExternalStorageMount();
            }
            {
                this.this$0 = remoteFileManager;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ AndroidDevice access$getDevice$p(RemoteFileManager $this) {
        return $this.device;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/malinskiy/marathon/android/RemoteFileManager$Companion;", "", "()V", "MAX_FILENAME", "", "base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

