/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.android.configuration;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import com.malinskiy.marathon.log.MarathonLogConfigurator;
import com.malinskiy.marathon.vendor.VendorConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/malinskiy/marathon/android/configuration/AndroidLogConfigurator;", "Lcom/malinskiy/marathon/log/MarathonLogConfigurator;", "()V", "configure", "", "vendorConfiguration", "Lcom/malinskiy/marathon/vendor/VendorConfiguration;", "base"})
public final class AndroidLogConfigurator
implements MarathonLogConfigurator {
    public void configure(@NotNull VendorConfiguration vendorConfiguration) {
        Intrinsics.checkNotNullParameter((Object)vendorConfiguration, (String)"vendorConfiguration");
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        if (!(iLoggerFactory instanceof LoggerContext)) {
            iLoggerFactory = null;
        }
        LoggerContext loggerContext = (LoggerContext)iLoggerFactory;
        if (loggerContext == null) {
            return;
        }
        LoggerContext loggerContext2 = loggerContext;
        PatternLayout layout = new PatternLayout();
        layout.setPattern("%highlight(%.-1level %d{HH:mm:ss.SSS} [%thread] <%logger{40}> %msg%n)");
        layout.setContext((Context)loggerContext2);
        layout.start();
        LayoutWrappingEncoder encoder = new LayoutWrappingEncoder();
        encoder.setContext((Context)loggerContext2);
        encoder.setLayout((Layout)layout);
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setWithJansi(true);
        consoleAppender.setContext((Context)loggerContext2);
        consoleAppender.setName("android-custom-console-appender");
        consoleAppender.setEncoder((Encoder)encoder);
        consoleAppender.start();
        Logger rootLogger = loggerContext2.getLogger("ROOT");
        rootLogger.detachAndStopAllAppenders();
        rootLogger.addAppender((Appender)consoleAppender);
    }
}

