/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.android.executor.listeners.screenshot;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\""}, d2={"Lcom/malinskiy/marathon/android/executor/listeners/screenshot/GifSequenceWriter;", "", "outputStream", "Ljavax/imageio/stream/ImageOutputStream;", "imageType", "", "timeBetweenFramesMS", "loopContinuously", "", "(Ljavax/imageio/stream/ImageOutputStream;IIZ)V", "gifWriter", "Ljavax/imageio/ImageWriter;", "getGifWriter", "()Ljavax/imageio/ImageWriter;", "setGifWriter", "(Ljavax/imageio/ImageWriter;)V", "imageMetaData", "Ljavax/imageio/metadata/IIOMetadata;", "getImageMetaData", "()Ljavax/imageio/metadata/IIOMetadata;", "setImageMetaData", "(Ljavax/imageio/metadata/IIOMetadata;)V", "imageWriteParam", "Ljavax/imageio/ImageWriteParam;", "getImageWriteParam", "()Ljavax/imageio/ImageWriteParam;", "setImageWriteParam", "(Ljavax/imageio/ImageWriteParam;)V", "close", "", "writeToSequence", "img", "Ljava/awt/image/RenderedImage;", "Companion", "base"})
public final class GifSequenceWriter {
    @NotNull
    private ImageWriter gifWriter;
    @NotNull
    private ImageWriteParam imageWriteParam;
    @NotNull
    private IIOMetadata imageMetaData;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final ImageWriter getGifWriter() {
        return this.gifWriter;
    }

    protected final void setGifWriter(@NotNull ImageWriter imageWriter) {
        Intrinsics.checkNotNullParameter((Object)imageWriter, (String)"<set-?>");
        this.gifWriter = imageWriter;
    }

    @NotNull
    protected final ImageWriteParam getImageWriteParam() {
        return this.imageWriteParam;
    }

    protected final void setImageWriteParam(@NotNull ImageWriteParam imageWriteParam) {
        Intrinsics.checkNotNullParameter((Object)imageWriteParam, (String)"<set-?>");
        this.imageWriteParam = imageWriteParam;
    }

    @NotNull
    protected final IIOMetadata getImageMetaData() {
        return this.imageMetaData;
    }

    protected final void setImageMetaData(@NotNull IIOMetadata iIOMetadata) {
        Intrinsics.checkNotNullParameter((Object)iIOMetadata, (String)"<set-?>");
        this.imageMetaData = iIOMetadata;
    }

    public final void writeToSequence(@NotNull RenderedImage img) throws IOException {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        this.gifWriter.writeToSequence(new IIOImage(img, null, this.imageMetaData), this.imageWriteParam);
    }

    public final void close() throws IOException {
        this.gifWriter.endWriteSequence();
    }

    public GifSequenceWriter(@NotNull ImageOutputStream outputStream, int imageType, int timeBetweenFramesMS, boolean loopContinuously) throws IIOException, IOException {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this.gifWriter = GifSequenceWriter.Companion.getWriter();
        ImageWriteParam imageWriteParam = this.gifWriter.getDefaultWriteParam();
        Intrinsics.checkNotNullExpressionValue((Object)imageWriteParam, (String)"gifWriter.defaultWriteParam");
        this.imageWriteParam = imageWriteParam;
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(imageType);
        IIOMetadata iIOMetadata = this.gifWriter.getDefaultImageMetadata(imageTypeSpecifier, this.imageWriteParam);
        Intrinsics.checkNotNullExpressionValue((Object)iIOMetadata, (String)"gifWriter.getDefaultImag\u2026imageWriteParam\n        )");
        this.imageMetaData = iIOMetadata;
        String metaFormatName = this.imageMetaData.getNativeMetadataFormatName();
        Node node = this.imageMetaData.getAsTree(metaFormatName);
        if (node == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.imageio.metadata.IIOMetadataNode");
        }
        IIOMetadataNode root = (IIOMetadataNode)node;
        IIOMetadataNode graphicsControlExtensionNode = GifSequenceWriter.Companion.getNode(root, "GraphicControlExtension");
        graphicsControlExtensionNode.setAttribute("disposalMethod", "none");
        graphicsControlExtensionNode.setAttribute("userInputFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("transparentColorFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("delayTime", Integer.toString(timeBetweenFramesMS / 10));
        graphicsControlExtensionNode.setAttribute("transparentColorIndex", "0");
        IIOMetadataNode commentsNode = GifSequenceWriter.Companion.getNode(root, "CommentExtensions");
        commentsNode.setAttribute("CommentExtension", "Created by MAH");
        IIOMetadataNode appEntensionsNode = GifSequenceWriter.Companion.getNode(root, "ApplicationExtensions");
        IIOMetadataNode child = new IIOMetadataNode("ApplicationExtension");
        child.setAttribute("applicationID", "NETSCAPE");
        child.setAttribute("authenticationCode", "2.0");
        int loop = loopContinuously ? 0 : 1;
        child.setUserObject(new byte[]{1, (byte)(loop & 0xFF), (byte)(loop >> 8 & 0xFF)});
        appEntensionsNode.appendChild(child);
        this.imageMetaData.setFromTree(metaFormatName, root);
        this.gifWriter.setOutput(outputStream);
        this.gifWriter.prepareWriteSequence(null);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) throws Exception {
        Companion.main(args);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001b\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/malinskiy/marathon/android/executor/listeners/screenshot/GifSequenceWriter$Companion;", "", "()V", "writer", "Ljavax/imageio/ImageWriter;", "getWriter", "()Ljavax/imageio/ImageWriter;", "getNode", "Ljavax/imageio/metadata/IIOMetadataNode;", "rootNode", "nodeName", "", "main", "", "args", "", "([Ljava/lang/String;)V", "base"})
    public static final class Companion {
        private final ImageWriter getWriter() throws IIOException {
            Iterator<ImageWriter> iter = ImageIO.getImageWritersBySuffix("gif");
            if (!iter.hasNext()) {
                throw (Throwable)new IIOException("No GIF Image Writers Exist");
            }
            ImageWriter imageWriter = iter.next();
            Intrinsics.checkNotNullExpressionValue((Object)imageWriter, (String)"iter.next()");
            return imageWriter;
        }

        /*
         * WARNING - void declaration
         */
        private final IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
            int nNodes = rootNode.getLength();
            int n = 0;
            int n2 = nNodes;
            while (n < n2) {
                void i;
                Node node = rootNode.item((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"rootNode.item(i)");
                String string = node.getNodeName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rootNode.item(i).nodeName");
                if (StringsKt.compareTo((String)string, (String)nodeName, (boolean)true) == 0) {
                    Node node2 = rootNode.item((int)i);
                    if (node2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type javax.imageio.metadata.IIOMetadataNode");
                    }
                    return (IIOMetadataNode)node2;
                }
                ++i;
            }
            IIOMetadataNode node = new IIOMetadataNode(nodeName);
            rootNode.appendChild(node);
            return node;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void main(@NotNull String[] args) throws Exception {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length > 1) {
                BufferedImage firstImage = ImageIO.read(new File(args[0]));
                FileImageOutputStream output = new FileImageOutputStream(new File(args[args.length - 1]));
                ImageOutputStream imageOutputStream = output;
                BufferedImage bufferedImage = firstImage;
                Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"firstImage");
                GifSequenceWriter writer = new GifSequenceWriter(imageOutputStream, bufferedImage.getType(), 1, false);
                writer.writeToSequence(firstImage);
                int n = 1;
                int n2 = args.length - 1;
                while (n < n2) {
                    void i;
                    BufferedImage nextImage;
                    BufferedImage bufferedImage2 = nextImage = ImageIO.read(new File(args[i]));
                    Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"nextImage");
                    writer.writeToSequence(bufferedImage2);
                    ++i;
                }
                writer.close();
                output.close();
            } else {
                String string = "Usage: java GifSequenceWriter [list of gif files] [output file]";
                boolean bl = false;
                System.out.println((Object)string);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

